/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaResolveCache {
    private static final NotNullLazyKey<JavaResolveCache, Project> INSTANCE_KEY = ServiceManager.createLazyKey(JavaResolveCache.class);
    private final AtomicReference<Map<PsiVariable, Object>> myVarToConstValueMapPhysical = new AtomicReference();
    private final AtomicReference<Map<PsiVariable, Object>> myVarToConstValueMapNonPhysical = new AtomicReference();
    private static final Object NULL = Key.create((String)"NULL");

    public static JavaResolveCache getInstance(Project project) {
        return (JavaResolveCache)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    public JavaResolveCache(@NotNull Project project) {
        project.getMessageBus().connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener(){

            public void beforePsiChanged(boolean isPhysical) {
                JavaResolveCache.this.clearCaches(isPhysical);
            }
        });
    }

    private void clearCaches(boolean isPhysical) {
        if (isPhysical) {
            this.myVarToConstValueMapPhysical.set(null);
        }
        this.myVarToConstValueMapNonPhysical.set(null);
    }

    @Nullable
    public <T extends PsiExpression> PsiType getType(@NotNull T expr2, @NotNull Function<? super T, ? extends PsiType> f) {
        boolean prohibitCaching;
        boolean bl = prohibitCaching = MethodCandidateInfo.isOverloadCheck() && PsiPolyExpressionUtil.isPolyExpression(expr2);
        if (prohibitCaching) {
            return (PsiType)f.fun(expr2);
        }
        return (PsiType)CachedValuesManager.getProjectPsiDependentCache(expr2, param -> (PsiType)f.fun(param));
    }

    @Nullable
    public Object computeConstantValueWithCaching(@NotNull PsiVariable variable, @NotNull ConstValueComputer computer, Set<PsiVariable> visitedVars) {
        Object cached;
        boolean physical = variable.isPhysical();
        AtomicReference<Map<PsiVariable, Object>> ref = physical ? this.myVarToConstValueMapPhysical : this.myVarToConstValueMapNonPhysical;
        Map map2 = ref.get();
        if (map2 == null) {
            map2 = (Map)ConcurrencyUtil.cacheOrGet(ref, (Object)ContainerUtil.createConcurrentWeakMap());
        }
        if ((cached = map2.get(variable)) == NULL) {
            return null;
        }
        if (cached != null) {
            return cached;
        }
        Object result = computer.execute(variable, visitedVars);
        map2.put(variable, result == null ? NULL : result);
        return result;
    }

    @FunctionalInterface
    public static interface ConstValueComputer {
        public Object execute(@NotNull PsiVariable var1, Set<PsiVariable> var2);
    }
}

