/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.source.ClassReferencePointer;
import com.intellij.psi.impl.source.JavaVarTypeUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiDiamondTypeElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeElementImpl
extends CompositePsiElement
implements PsiTypeElement {
    public PsiTypeElementImpl() {
        this(JavaElementType.TYPE);
    }

    PsiTypeElementImpl(@NotNull IElementType type2) {
        super(type2);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitTypeElement((PsiTypeElement)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiType getType() {
        return (PsiType)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this, __ -> this.calculateType());
    }

    @NotNull
    private PsiType calculateType() {
        PsiType inferredType = PsiAugmentProvider.getInferredType((PsiTypeElement)this);
        if (inferredType != null) {
            return inferredType;
        }
        Object type2 = null;
        SmartList annotations = new SmartList();
        PsiElement parent = this.getParent();
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            List<PsiType> types;
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                annotations.add((PsiAnnotation)child);
            } else if (child instanceof PsiTypeElement) {
                assert (type2 == null) : this;
                if (child instanceof PsiDiamondTypeElementImpl) {
                    type2 = new PsiDiamondTypeImpl((PsiManager)this.getManager(), this);
                    break;
                }
                type2 = ((PsiTypeElement)child).getType();
            } else if (PsiUtil.isJavaToken((PsiElement)child, (TokenSet)ElementType.PRIMITIVE_TYPE_BIT_SET)) {
                assert (type2 == null) : this;
                String text2 = child.getText();
                type2 = annotations.isEmpty() ? PsiJavaParserFacadeImpl.getPrimitiveType(text2) : new PsiPrimitiveType(text2, PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations));
            } else if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.VAR_KEYWORD)) {
                assert (type2 == null) : this;
                type2 = this.inferVarType(parent);
            } else if (child instanceof PsiJavaCodeReferenceElement) {
                assert (type2 == null) : this;
                type2 = new PsiClassReferenceType(PsiTypeElementImpl.getReferenceComputable((PsiJavaCodeReferenceElement)child), null, PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations));
            } else if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.LBRACKET)) {
                assert (type2 != null) : this;
                type2 = new PsiArrayType(type2, PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations));
            } else if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.ELLIPSIS)) {
                assert (type2 != null) : this;
                type2 = new PsiEllipsisType(type2, PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations));
            }
            if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.QUEST) || child instanceof ASTNode && ((ASTNode)child).getElementType() == JavaElementType.DUMMY_ELEMENT && "any".equals(child.getText())) {
                assert (type2 == null) : this;
                PsiElement boundKind = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)child);
                PsiElement boundType = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)boundKind);
                type2 = PsiUtil.isJavaToken((PsiElement)boundKind, (IElementType)JavaTokenType.EXTENDS_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createExtends((PsiManager)this.getManager(), (PsiType)((PsiTypeElement)boundType).getType()) : (PsiUtil.isJavaToken((PsiElement)boundKind, (IElementType)JavaTokenType.SUPER_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createSuper((PsiManager)this.getManager(), (PsiType)((PsiTypeElement)boundType).getType()) : PsiWildcardType.createUnbounded((PsiManager)this.getManager()));
                type2 = type2.annotate(PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations));
                break;
            }
            if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.AND)) {
                types = this.collectTypes();
                assert (!types.isEmpty()) : this;
                type2 = PsiIntersectionType.createIntersection((boolean)false, (PsiType[])types.toArray(PsiType.createArray((int)types.size())));
                break;
            }
            if (!PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.OR)) continue;
            types = this.collectTypes();
            assert (!types.isEmpty()) : this;
            type2 = PsiDisjunctionType.createDisjunction(types, (PsiManager)this.getManager());
            break;
        }
        if (type2 == null) {
            return PsiType.NULL;
        }
        if (parent instanceof PsiModifierListOwner) {
            type2 = JavaSharedImplUtil.applyAnnotations(type2, ((PsiModifierListOwner)parent).getModifierList());
        }
        return type2;
    }

    private PsiType inferVarType(PsiElement parent) {
        if (parent instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)parent).getDeclarationScope();
            if (declarationScope instanceof PsiForeachStatement) {
                PsiExpression iteratedValue2 = ((PsiForeachStatement)declarationScope).getIteratedValue();
                if (iteratedValue2 != null) {
                    return JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue2);
                }
                return null;
            }
            if (declarationScope instanceof PsiLambdaExpression) {
                return ((PsiParameter)parent).getType();
            }
        } else {
            for (PsiTypeElementImpl e = this; e != null; e = e.getNextSibling()) {
                if (!(e instanceof PsiExpression)) continue;
                if (!(e instanceof PsiArrayInitializerExpression)) {
                    PsiExpression expression2 = (PsiExpression)e;
                    PsiType type2 = (PsiType)RecursionManager.doPreventingRecursion((Object)expression2, (boolean)true, () -> expression2.getType());
                    return type2 == null ? null : JavaVarTypeUtil.getUpwardProjection(type2);
                }
                return null;
            }
        }
        return null;
    }

    public boolean isInferredType() {
        return PsiUtil.isJavaToken((PsiElement)this.getFirstChild(), (IElementType)JavaTokenType.VAR_KEYWORD) || PsiAugmentProvider.isInferredType((PsiTypeElement)this);
    }

    @NotNull
    private static ClassReferencePointer getReferenceComputable(@NotNull PsiJavaCodeReferenceElement ref) {
        block4: {
            int index;
            PsiElement parent;
            PsiTypeElement rootType;
            block5: {
                rootType = PsiTypeElementImpl.getRootTypeElement(ref);
                if (rootType == null) break block4;
                parent = rootType.getParent();
                if (parent instanceof PsiMethod) break block5;
                if (!(parent instanceof PsiVariable)) break block4;
            }
            if ((index = PsiTypeElementImpl.allReferencesInside(rootType).indexOf(ref::equals)) < 0) {
                throw new AssertionError(rootType.getClass());
            }
            return PsiTypeElementImpl.computeFromTypeOwner(parent, index, new WeakReference<PsiJavaCodeReferenceElement>(ref));
        }
        return ClassReferencePointer.constant(ref);
    }

    @Nullable
    private static PsiTypeElement getRootTypeElement(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement root = (PsiElement)SyntaxTraverser.psiApi().parents((Object)ref.getParent()).takeWhile(it -> it instanceof PsiTypeElement || it instanceof PsiReferenceParameterList || it instanceof PsiJavaCodeReferenceElement).last();
        return (PsiTypeElement)ObjectUtils.tryCast((Object)root, PsiTypeElement.class);
    }

    @NotNull
    private static JBIterable<PsiJavaCodeReferenceElement> allReferencesInside(@NotNull PsiTypeElement rootType) {
        return SyntaxTraverser.psiTraverser((PsiElement)rootType).filter(PsiJavaCodeReferenceElement.class);
    }

    @NotNull
    private static ClassReferencePointer computeFromTypeOwner(final PsiElement parent, final int index, final @NotNull WeakReference<PsiJavaCodeReferenceElement> ref) {
        return new ClassReferencePointer(){
            volatile WeakReference<PsiJavaCodeReferenceElement> myCache;
            {
                this.myCache = ref;
            }

            @Override
            @Nullable
            public PsiJavaCodeReferenceElement retrieveReference() {
                PsiJavaCodeReferenceElement result = (PsiJavaCodeReferenceElement)this.myCache.get();
                if (result == null) {
                    PsiType type2 = this.calcTypeByParent();
                    if (type2 instanceof PsiClassReferenceType) {
                        result = this.findReferenceByIndex((PsiClassReferenceType)type2);
                    }
                    this.myCache = new WeakReference<PsiJavaCodeReferenceElement>(result);
                }
                return result;
            }

            @Nullable
            private PsiJavaCodeReferenceElement findReferenceByIndex(PsiClassReferenceType type2) {
                PsiTypeElement root = PsiTypeElementImpl.getRootTypeElement(type2.getReference());
                return root == null ? null : (PsiJavaCodeReferenceElement)PsiTypeElementImpl.allReferencesInside(root).get(index);
            }

            @Nullable
            private PsiType calcTypeByParent() {
                PsiType type2;
                PsiType psiType = type2 = parent instanceof PsiMethod ? ((PsiMethod)parent).getReturnType() : ((PsiVariable)parent).getType();
                if (type2 instanceof PsiArrayType) {
                    return type2.getDeepComponentType();
                }
                return type2;
            }

            @Override
            @NotNull
            public PsiJavaCodeReferenceElement retrieveNonNullReference() {
                PsiJavaCodeReferenceElement result = this.retrieveReference();
                if (result == null) {
                    PsiType type2 = this.calcTypeByParent();
                    if (!(type2 instanceof PsiClassReferenceType)) {
                        PsiUtilCore.ensureValid((PsiElement)parent);
                        throw new IllegalStateException("No reference type for " + parent.getClass() + "; type: " + (type2 != null ? type2.getClass() : "null"));
                    }
                    result = this.findReferenceByIndex((PsiClassReferenceType)type2);
                    if (result == null) {
                        PsiUtilCore.ensureValid((PsiElement)parent);
                        throw new RuntimeExceptionWithAttachments("Can't retrieve reference by index " + index + " for " + parent.getClass() + "; type: " + type2.getClass(), new Attachment[]{new Attachment("memberType.txt", type2.getCanonicalText())});
                    }
                }
                return result;
            }

            public String toString() {
                String msg = "Type element reference of " + parent.getClass() + " #" + parent.getClass().getSimpleName() + ", index=" + index;
                return parent.isValid() ? msg + " #" + parent.getLanguage() : msg + ", invalid";
            }
        };
    }

    @NotNull
    private static TypeAnnotationProvider createProvider(@NotNull List<PsiAnnotation> annotations) {
        return TypeAnnotationProvider.Static.create((PsiAnnotation[])((PsiAnnotation[])ContainerUtil.copyAndClear(annotations, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY, (boolean)true)));
    }

    @NotNull
    private List<PsiType> collectTypes() {
        List typeElements = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PsiTypeElement.class);
        return ContainerUtil.map((Collection)typeElements, typeElement -> typeElement.getType());
    }

    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        TreeElement firstChildNode = this.getFirstChildNode();
        if (firstChildNode == null) {
            return null;
        }
        if (firstChildNode.getElementType() == JavaElementType.TYPE) {
            return ((PsiTypeElement)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)firstChildNode)).getInnermostComponentReferenceElement();
        }
        return this.getReferenceElement();
    }

    @Nullable
    private PsiJavaCodeReferenceElement getReferenceElement() {
        ASTNode ref = this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
        if (ref == null) {
            return null;
        }
        return (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi((ASTNode)ref);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        return true;
    }

    public PsiAnnotation @NotNull [] getAnnotations() {
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PsiAnnotation.class);
        return annotations != null ? annotations : PsiAnnotation.EMPTY_ARRAY;
    }

    public PsiAnnotation @NotNull [] getApplicableAnnotations() {
        return this.getType().getAnnotations();
    }

    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        return PsiImplUtil.findAnnotation((PsiAnnotationOwner)this, qualifiedName);
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        PsiModifierList modifierList;
        PsiIdentifier identifier;
        PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)this.getProject()).createAnnotationFromText('@' + qualifiedName, (PsiElement)this);
        PsiElement firstChild = this.getFirstChild();
        for (PsiElement child = this.getLastChild(); child != firstChild; child = child.getPrevSibling()) {
            if (!PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.LBRACKET) && !PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.ELLIPSIS)) continue;
            return (PsiAnnotation)this.addBefore((PsiElement)annotation, child);
        }
        if (firstChild instanceof PsiJavaCodeReferenceElement && (identifier = (PsiIdentifier)PsiTreeUtil.getChildOfType((PsiElement)firstChild, PsiIdentifier.class)) != null && identifier != firstChild.getFirstChild()) {
            return (PsiAnnotation)firstChild.addBefore((PsiElement)annotation, (PsiElement)identifier);
        }
        PsiElement parent = this.getParent();
        while (parent instanceof PsiTypeElement && ((PsiTypeElement)parent).getType() instanceof PsiArrayType) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiModifierListOwner && (modifierList = ((PsiModifierListOwner)parent).getModifierList()) != null) {
            PsiTypeParameterList list;
            PsiTypeParameterList psiTypeParameterList = list = parent instanceof PsiTypeParameterListOwner ? ((PsiTypeParameterListOwner)parent).getTypeParameterList() : null;
            if (list == null || list.textMatches((CharSequence)"")) {
                return (PsiAnnotation)modifierList.add((PsiElement)annotation);
            }
        }
        return (PsiAnnotation)this.addBefore((PsiElement)annotation, firstChild);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        PsiElement result;
        if (!(newElement instanceof PsiTypeElement) || !((PsiTypeElement)newElement).isInferredType()) {
            PsiImplUtil.markTypeAnnotations(this);
        }
        if ((result = super.replace(newElement)) instanceof PsiTypeElement) {
            PsiImplUtil.deleteTypeAnnotations((PsiTypeElement)result);
        }
        return result;
    }

    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }
}

