/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.SymbolCollectingProcessor;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.IndexingDataKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiJavaFileBaseImpl
extends PsiFileImpl
implements PsiJavaFile {
    private static final Logger LOG = Logger.getInstance(PsiJavaFileBaseImpl.class);
    private static final String[] IMPLICIT_IMPORTS = new String[]{"java.lang"};
    private final CachedValue<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> myResolveCache;
    private volatile String myPackageName;
    private static final NotNullLazyKey<LanguageLevel, PsiJavaFileBaseImpl> LANGUAGE_LEVEL_KEY = NotNullLazyKey.create((String)"LANGUAGE_LEVEL", file -> file.getLanguageLevelInner());

    protected PsiJavaFileBaseImpl(IElementType elementType, IElementType contentElementType, FileViewProvider viewProvider) {
        super(elementType, contentElementType, viewProvider);
        this.myResolveCache = CachedValuesManager.getManager((Project)this.myManager.getProject()).createCachedValue((CachedValueProvider)new MyCacheBuilder(this), false);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myPackageName = null;
    }

    public PsiClass @NotNull [] getClasses() {
        StubElement stub = this.getGreenStub();
        if (stub != null) {
            return (PsiClass[])stub.getChildrenByType((IElementType)JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
        }
        return (PsiClass[])this.calcTreeElement().getChildrenAsPsiElements(Constants.CLASS_BIT_SET, PsiClass.ARRAY_FACTORY);
    }

    public PsiPackageStatement getPackageStatement() {
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.PACKAGE_STATEMENT);
        return node != null ? (PsiPackageStatement)node.getPsi() : null;
    }

    @NotNull
    public String getPackageName() {
        PsiJavaFileStub stub = (PsiJavaFileStub)this.getGreenStub();
        if (stub != null) {
            return stub.getPackageName();
        }
        String name2 = this.myPackageName;
        if (name2 == null) {
            PsiPackageStatement statement = this.getPackageStatement();
            name2 = statement == null ? "" : statement.getPackageName();
            this.myPackageName = name2;
        }
        return name2;
    }

    public void setPackageName(String packageName) throws IncorrectOperationException {
        if (PsiUtil.isModuleFile((PsiFile)this)) {
            throw new IncorrectOperationException("Cannot set package name for module declarations");
        }
        PsiPackageStatement packageStatement = this.getPackageStatement();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.getProject());
        if (packageStatement != null) {
            if (!packageName.isEmpty()) {
                PsiJavaCodeReferenceElement reference = packageStatement.getPackageReference();
                reference.replace((PsiElement)factory.createReferenceFromText(packageName, (PsiElement)packageStatement));
            } else {
                packageStatement.delete();
            }
        } else if (!packageName.isEmpty()) {
            this.cleanupBrokenPackageKeyword();
            PsiElement anchor = this.getFirstChild();
            if ("package-info.java".equals(this.getName())) {
                String text2;
                anchor = this.getImportList();
                assert (anchor != null);
                PsiElement prev = anchor.getPrevSibling();
                if (prev instanceof PsiComment && (text2 = prev.getText().trim()).startsWith("/*") && !text2.endsWith("*/")) {
                    prev.replace((PsiElement)factory.createCommentFromText(text2 + (StringUtil.containsLineBreak((CharSequence)text2) ? "\n*/" : " */"), prev));
                }
            }
            this.addBefore((PsiElement)factory.createPackageStatement(packageName), anchor);
        }
    }

    private void cleanupBrokenPackageKeyword() {
        PsiElement child = this.getFirstChild();
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof PsiErrorElement) {
            if (child instanceof PsiErrorElement && child.getFirstChild() != null && child.getFirstChild().textMatches((CharSequence)"package")) {
                child.delete();
                break;
            }
            child = child.getNextSibling();
        }
    }

    public PsiImportList getImportList() {
        StubElement stub = this.getGreenStub();
        if (stub != null) {
            PsiImportList[] nodes = (PsiImportList[])stub.getChildrenByType((IElementType)JavaStubElementTypes.IMPORT_LIST, PsiImportList.ARRAY_FACTORY);
            if (nodes.length == 1) {
                return nodes[0];
            }
            assert (nodes.length == 0);
            return null;
        }
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.IMPORT_LIST);
        return (PsiImportList)SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
    }

    public PsiElement @NotNull [] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            return EMPTY_ARRAY;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement resolved;
            if (!statement.isOnDemand() || (resolved = statement.resolve()) == null) continue;
            array.add(resolved);
        }
        if (includeImplicit) {
            PsiJavaCodeReferenceElement[] implicitRefs;
            for (PsiJavaCodeReferenceElement implicitRef : implicitRefs = this.getImplicitlyImportedPackageReferences()) {
                PsiElement resolved = implicitRef.resolve();
                if (resolved == null) continue;
                array.add(resolved);
            }
        }
        return PsiUtilCore.toPsiElementArray(array);
    }

    public PsiClass @NotNull [] getSingleClassImports(boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> array = new ArrayList<PsiClass>();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement ref;
            if (statement.isOnDemand() || !((ref = statement.resolve()) instanceof PsiClass)) continue;
            array.add((PsiClass)ref);
        }
        return array.toArray(PsiClass.EMPTY_ARRAY);
    }

    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        PsiImportList importList = this.getImportList();
        if (importList != null) {
            PsiImportStatement[] statements;
            for (PsiImportStatement statement : statements = importList.getImportStatements()) {
                PsiElement ref;
                if (statement.isOnDemand() || (ref = statement.resolve()) == null || !this.getManager().areElementsEquivalent(ref, (PsiElement)aClass)) continue;
                return statement.getImportReference();
            }
        }
        return null;
    }

    public String @NotNull [] getImplicitlyImportedPackages() {
        return IMPLICIT_IMPORTS;
    }

    public PsiJavaCodeReferenceElement @NotNull [] getImplicitlyImportedPackageReferences() {
        return PsiImplUtil.namesToPackageReferences((PsiManager)this.myManager, IMPLICIT_IMPORTS);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        Iterable iterable;
        NameHint nameHint = (NameHint)processor2.getHint(NameHint.KEY);
        String name2 = nameHint != null ? nameHint.getName(state) : null;
        Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> explicitlyEnumerated = this.getExplicitlyEnumeratedDeclarations();
        Iterable iterable2 = iterable = name2 != null ? explicitlyEnumerated.get(name2) : ContainerUtil.concat((Iterable[])explicitlyEnumerated.values().toArray(new Iterable[0]));
        if (iterable != null && !ContainerUtil.process((Iterable)iterable, (Processor)new MyResolveCacheProcessor(processor2, state))) {
            return false;
        }
        if (processor2 instanceof ClassResolverProcessor && this.isPhysical() && (this.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING) == Boolean.TRUE || this.myResolveCache.hasUpToDateValue()) && !PsiUtil.isInsideJavadocComment((PsiElement)place)) {
            MostlySingularMultiMap cache = (MostlySingularMultiMap)this.myResolveCache.getValue();
            MyResolveCacheProcessor cacheProcessor = new MyResolveCacheProcessor(processor2, state);
            return name2 != null ? cache.processForKey((Object)name2, (Processor)cacheProcessor) : cache.processAllValues((Processor)cacheProcessor);
        }
        return this.processOnDemandPackages(processor2, state, place);
    }

    private Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> getExplicitlyEnumeratedDeclarations() {
        return (Map)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            MultiMap ownClasses = MultiMap.create();
            MultiMap typeImports = MultiMap.create();
            MultiMap staticImports = MultiMap.create();
            for (PsiClass psiClass : this.getClasses()) {
                String name2 = psiClass.getName();
                if (name2 == null) continue;
                ownClasses.putValue((Object)name2, (Object)psiClass);
            }
            for (PsiClass psiClass : this.getImportStatements()) {
                String qName;
                if (psiClass.isOnDemand() || (qName = psiClass.getQualifiedName()) == null) continue;
                typeImports.putValue((Object)StringUtil.getShortName((String)qName), (Object)psiClass);
            }
            for (PsiClass psiClass : this.getImportStaticStatements()) {
                String name2 = psiClass.getReferenceName();
                if (name2 == null) continue;
                staticImports.putValue((Object)name2, (Object)psiClass);
            }
            LinkedHashMap result = new LinkedHashMap();
            for (String name3 : ContainerUtil.newLinkedHashSet((Iterable)ContainerUtil.concat((Iterable[])new Iterable[]{ownClasses.keySet(), typeImports.keySet(), staticImports.keySet()}))) {
                VolatileNotNullLazyValue volatileNotNullLazyValue = VolatileNotNullLazyValue.createValue(() -> PsiJavaFileBaseImpl.findExplicitDeclarations(name3, (MultiMap<String, PsiClass>)ownClasses, (MultiMap<String, PsiImportStatement>)typeImports, (MultiMap<String, PsiImportStaticStatement>)staticImports));
                result.put(name3, () -> ((Iterable)lazy.getValue()).iterator());
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static Iterable<SymbolCollectingProcessor.ResultWithContext> findExplicitDeclarations(String name2, MultiMap<String, PsiClass> ownClasses, MultiMap<String, PsiImportStatement> typeImports, MultiMap<String, PsiImportStaticStatement> staticImports) {
        ArrayList<SymbolCollectingProcessor.ResultWithContext> result = new ArrayList<SymbolCollectingProcessor.ResultWithContext>();
        for (PsiClass psiClass : ownClasses.get((Object)name2)) {
            result.add(new SymbolCollectingProcessor.ResultWithContext((PsiNamedElement)psiClass, null));
        }
        for (PsiImportStatement statement : typeImports.get((Object)name2)) {
            PsiElement target = statement.resolve();
            if (!(target instanceof PsiClass)) continue;
            result.add(new SymbolCollectingProcessor.ResultWithContext((PsiNamedElement)target, (PsiElement)statement));
        }
        for (PsiImportStatement statement : staticImports.get((Object)name2)) {
            PsiJavaCodeReferenceElement reference = statement.getImportReference();
            if (reference == null) continue;
            for (JavaResolveResult result1 : reference.multiResolve(false)) {
                PsiElement element = result1.getElement();
                if (!(element instanceof PsiNamedElement)) continue;
                result.add(new SymbolCollectingProcessor.ResultWithContext((PsiNamedElement)element, (PsiElement)statement));
            }
        }
        return JBIterable.from(result).unique(SymbolCollectingProcessor.ResultWithContext::getElement);
    }

    private boolean processOnDemandPackages(PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement place) {
        boolean shouldProcessClasses;
        ElementClassHint classHint2 = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        boolean bl = shouldProcessClasses = classHint2 == null || classHint2.shouldProcess(ElementClassHint.DeclarationKind.CLASS);
        if (shouldProcessClasses) {
            if (!this.processCurrentPackage(processor2, state, place)) {
                return false;
            }
            if (!this.processOnDemandTypeImports(processor2, state, place)) {
                return false;
            }
        }
        if (!this.processOnDemandStaticImports(state, new StaticImportFilteringProcessor(processor2, this.getExplicitlyEnumeratedDeclarations()))) {
            return false;
        }
        return !shouldProcessClasses || this.processImplicitImports(processor2, state, place);
    }

    private PsiImportStaticStatement[] getImportStaticStatements() {
        return this.getImportList() != null ? this.getImportList().getImportStaticStatements() : PsiImportStaticStatement.EMPTY_ARRAY;
    }

    private PsiImportStatement[] getImportStatements() {
        return this.getImportList() != null ? this.getImportList().getImportStatements() : PsiImportStatement.EMPTY_ARRAY;
    }

    private boolean processCurrentPackage(PsiScopeProcessor processor2, ResolveState state, PsiElement place) {
        processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findPackage(this.getPackageName());
        return aPackage == null || PsiJavaFileBaseImpl.processPackageDeclarations(processor2, state, place, aPackage);
    }

    private boolean processOnDemandTypeImports(PsiScopeProcessor processor2, ResolveState state, PsiElement place) {
        for (PsiImportStatement statement : this.getImportStatements()) {
            PsiElement resolved;
            if (!statement.isOnDemand() || (resolved = statement.resolve()) == null) continue;
            processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)statement);
            if (PsiJavaFileBaseImpl.processOnDemandTarget(resolved, processor2, state, place)) continue;
            return false;
        }
        return true;
    }

    private boolean processOnDemandStaticImports(ResolveState state, StaticImportFilteringProcessor processor2) {
        for (PsiImportStaticStatement importStaticStatement : this.getImportStaticStatements()) {
            PsiClass targetElement;
            if (!importStaticStatement.isOnDemand() || (targetElement = importStaticStatement.resolveTargetClass()) == null) continue;
            processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, importStaticStatement);
            if (PsiClassImplUtil.processAllMembersWithoutSubstitutors(targetElement, (PsiScopeProcessor)processor2, state)) continue;
            return false;
        }
        return true;
    }

    private boolean processImplicitImports(PsiScopeProcessor processor2, ResolveState state, PsiElement place) {
        processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
        for (PsiJavaCodeReferenceElement aImplicitlyImported : this.getImplicitlyImportedPackageReferences()) {
            PsiElement resolved = aImplicitlyImported.resolve();
            if (resolved == null || PsiJavaFileBaseImpl.processOnDemandTarget(resolved, processor2, state, place)) continue;
            return false;
        }
        return true;
    }

    private static boolean processPackageDeclarations(PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement place, @NotNull PsiPackage aPackage) {
        if (!aPackage.getQualifiedName().isEmpty()) {
            processor2 = new DelegatingScopeProcessor((PsiScopeProcessor)processor2){

                @Nullable
                public <T> T getHint(@NotNull Key<T> hintKey) {
                    if (hintKey == ElementClassHint.KEY) {
                        return (T)((ElementClassHint)kind2 -> kind2 == ElementClassHint.DeclarationKind.CLASS);
                    }
                    return (T)super.getHint(hintKey);
                }
            };
        }
        return aPackage.processDeclarations(processor2, state, null, place);
    }

    @NotNull
    private static PsiSubstitutor createRawSubstitutor(PsiClass containingClass) {
        return JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)containingClass);
    }

    private static boolean processOnDemandTarget(PsiElement target, PsiScopeProcessor processor2, ResolveState substitutor, PsiElement place) {
        if (target instanceof PsiPackage) {
            if (!PsiJavaFileBaseImpl.processPackageDeclarations(processor2, substitutor, place, (PsiPackage)target)) {
                return false;
            }
        } else if (target instanceof PsiClass) {
            PsiClass[] inners = ((PsiClass)target).getInnerClasses();
            if (((PsiClass)target).hasTypeParameters()) {
                substitutor = substitutor.put(PsiSubstitutor.KEY, (Object)PsiJavaFileBaseImpl.createRawSubstitutor((PsiClass)target));
            }
            for (PsiClass inner : inners) {
                if (processor2.execute((PsiElement)inner, substitutor)) continue;
                return false;
            }
        } else {
            LOG.error((Object)target);
        }
        return true;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitJavaFile((PsiJavaFile)this);
        } else {
            visitor2.visitFile((PsiFile)this);
        }
    }

    @NotNull
    public Language getLanguage() {
        return JavaLanguage.INSTANCE;
    }

    public boolean importClass(@NotNull PsiClass aClass) {
        return JavaCodeStyleManager.getInstance((Project)this.getProject()).addImport((PsiJavaFile)this, aClass);
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        return (LanguageLevel)LANGUAGE_LEVEL_KEY.getValue((UserDataHolder)this);
    }

    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        return null;
    }

    public void clearCaches() {
        super.clearCaches();
        this.putUserData((Key)LANGUAGE_LEVEL_KEY, null);
    }

    public void setOriginalFile(@NotNull PsiFile originalFile) {
        super.setOriginalFile(originalFile);
        this.clearCaches();
    }

    private LanguageLevel getLanguageLevelInner() {
        if (this.myOriginalFile instanceof PsiJavaFile) {
            return ((PsiJavaFile)this.myOriginalFile).getLanguageLevel();
        }
        LanguageLevel forcedLanguageLevel = (LanguageLevel)this.getUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY);
        if (forcedLanguageLevel != null) {
            return forcedLanguageLevel;
        }
        VirtualFile virtualFile = (VirtualFile)this.getUserData(IndexingDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            virtualFile = this.getViewProvider().getVirtualFile();
        }
        return JavaPsiImplementationHelper.getInstance(this.getProject()).getEffectiveLanguageLevel(virtualFile);
    }

    private static class MyResolveCacheProcessor
    implements Processor<SymbolCollectingProcessor.ResultWithContext> {
        private final PsiScopeProcessor myProcessor;
        private final ResolveState myState;

        MyResolveCacheProcessor(PsiScopeProcessor processor2, ResolveState state) {
            this.myProcessor = processor2;
            this.myState = state;
        }

        public boolean process(SymbolCollectingProcessor.ResultWithContext result) {
            PsiClass containingClass;
            PsiElement context = result.getFileContext();
            this.myProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)context);
            PsiNamedElement element = result.getElement();
            if (element instanceof PsiClass && context instanceof PsiImportStatement && (containingClass = ((PsiClass)element).getContainingClass()) != null && containingClass.hasTypeParameters()) {
                return this.myProcessor.execute((PsiElement)element, this.myState.put(PsiSubstitutor.KEY, (Object)PsiJavaFileBaseImpl.createRawSubstitutor(containingClass)));
            }
            return this.myProcessor.execute((PsiElement)element, this.myState);
        }
    }

    private static class MyCacheBuilder
    implements CachedValueProvider<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> {
        private final PsiJavaFileBaseImpl myFile;

        MyCacheBuilder(PsiJavaFileBaseImpl file) {
            this.myFile = file;
        }

        public CachedValueProvider.Result<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> compute() {
            SymbolCollectingProcessor p = new SymbolCollectingProcessor();
            this.myFile.processOnDemandPackages(p, ResolveState.initial(), (PsiElement)this.myFile);
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> results = p.getResults();
            return CachedValueProvider.Result.create(results, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this.myFile});
        }
    }

    private static class StaticImportFilteringProcessor
    extends DelegatingScopeProcessor {
        private final Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> myExplicitlyEnumerated;
        private final Collection<PsiElement> myCollectedElements = new HashSet<PsiElement>();

        StaticImportFilteringProcessor(PsiScopeProcessor delegate, Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> explicitlyEnumerated) {
            super(delegate);
            this.myExplicitlyEnumerated = explicitlyEnumerated;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("static")) {
                String name2;
                Iterable<SymbolCollectingProcessor.ResultWithContext> shadowing;
                if (element instanceof PsiNamedElement && (shadowing = this.myExplicitlyEnumerated.get(name2 = ((PsiNamedElement)element).getName())) != null && ContainerUtil.exists(shadowing, rwc -> StaticImportFilteringProcessor.hasSameDeclarationKind(element, (PsiElement)rwc.getElement()))) {
                    return true;
                }
                if (this.myCollectedElements.add(element)) {
                    return this.getDelegate().execute(element, state);
                }
            }
            return true;
        }

        private static boolean hasSameDeclarationKind(PsiElement e1, PsiElement e2) {
            return e1 instanceof PsiClass ? e2 instanceof PsiClass : (e1 instanceof PsiMethod ? e2 instanceof PsiMethod : e2 instanceof PsiField);
        }
    }
}

