/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiAnonymousClassImpl
extends PsiClassImpl
implements PsiAnonymousClass {
    private static final Key<PsiAnonymousClassImpl> STUB_BASE_CLASS_REFERENCE_HOLDER = Key.create((String)"STUB_BASE_CLASS_REFERENCE_HOLDER");
    private SoftReference<PsiClassType> myCachedBaseType;

    public PsiAnonymousClassImpl(PsiClassStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ANONYMOUS_CLASS);
    }

    public PsiAnonymousClassImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected Object clone() {
        PsiAnonymousClassImpl clone = (PsiAnonymousClassImpl)super.clone();
        clone.myCachedBaseType = null;
        return clone;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedBaseType = null;
    }

    public PsiExpressionList getArgumentList() {
        return (PsiExpressionList)this.getNode().findChildByRoleAsPsiElement(73);
    }

    @NotNull
    public PsiJavaCodeReferenceElement getBaseClassReference() {
        PsiElement baseRef = this.getFirstChild();
        assert (baseRef instanceof PsiJavaCodeReferenceElement) : this.getText();
        return (PsiJavaCodeReferenceElement)baseRef;
    }

    @NotNull
    public PsiClassType getBaseClassType() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub == null) {
            this.myCachedBaseType = null;
            return this.getTypeByTree();
        }
        PsiClassType type2 = (PsiClassType)SoftReference.dereference(this.myCachedBaseType);
        if (type2 != null) {
            return type2;
        }
        if (!this.isInQualifiedNew() && !this.isDiamond(stub)) {
            String refText = stub.getBaseClassReferenceText();
            assert (refText != null) : stub;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.getProject());
            try {
                PsiJavaCodeReferenceElement ref = factory.createReferenceFromText(refText, (PsiElement)this);
                ((PsiJavaCodeReferenceElementImpl)ref).setKindWhenDummy(PsiJavaCodeReferenceElementImpl.Kind.CLASS_NAME_KIND);
                ref.getContainingFile().putUserData(STUB_BASE_CLASS_REFERENCE_HOLDER, (Object)this);
                type2 = factory.createType(ref);
            }
            catch (IncorrectOperationException e) {
                type2 = PsiType.getJavaLangObject((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope());
            }
            this.myCachedBaseType = new SoftReference((Object)type2);
            return type2;
        }
        return this.getTypeByTree();
    }

    private boolean isDiamond(@NotNull PsiClassStub<?> stub) {
        String referenceText;
        if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)this) && (referenceText = stub.getBaseClassReferenceText()) != null && referenceText.endsWith(">")) {
            return StringUtil.trimEnd((String)referenceText, (String)">").trim().endsWith("<");
        }
        return false;
    }

    private PsiClassType getTypeByTree() {
        return JavaPsiFacade.getElementFactory((Project)this.getProject()).createType(this.getBaseClassReference());
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return null;
    }

    @Override
    public PsiModifierList getModifierList() {
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name2) {
        return name2.equals("final");
    }

    @Override
    public PsiReferenceList getExtendsList() {
        return null;
    }

    @Override
    public PsiReferenceList getImplementsList() {
        return null;
    }

    @Override
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitAnonymousClass((PsiAnonymousClass)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiAnonymousClass";
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (lastParent instanceof PsiExpressionList) {
            return true;
        }
        if (lastParent != null && this.isBaseClassReference(lastParent)) {
            return true;
        }
        return super.processDeclarations(processor2, state, lastParent, place);
    }

    public boolean isBaseClassReference(@NotNull PsiElement element) {
        if (element instanceof PsiJavaCodeReferenceElement) {
            PsiElement parent = element.getParent();
            return parent == this && element == this.getBaseClassReference() || this.isBaseClassReferenceHolder(parent);
        }
        return this.isBaseClassReferenceHolder(element);
    }

    private boolean isBaseClassReferenceHolder(@NotNull PsiElement element) {
        return element instanceof DummyHolder && element.getUserData(STUB_BASE_CLASS_REFERENCE_HOLDER) == this;
    }

    public boolean isInQualifiedNew() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isAnonymousInQualifiedNew();
        }
        PsiElement parent = this.getParent();
        return parent instanceof PsiNewExpression && ((PsiNewExpression)parent).getQualifier() != null;
    }
}

