/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypeVisitorEx;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaVarTypeUtil {
    public static PsiType getUpwardProjection(@NotNull PsiType t) {
        return (PsiType)t.accept((PsiTypeVisitor)new UpwardProjectionTypeVisitor());
    }

    public static PsiType getDownwardProjection(@NotNull PsiType type2) {
        return (PsiType)type2.accept((PsiTypeVisitor)new DownwardProjectionTypeVisitor());
    }

    private static boolean mentionsRestrictedTypeVariables(PsiType type2) {
        return (Boolean)type2.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

            public Boolean visitType(@NotNull PsiType type2) {
                return false;
            }

            public Boolean visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
                return true;
            }
        });
    }

    private static class DownwardProjectionTypeVisitor
    extends PsiTypeVisitor<PsiType> {
        private DownwardProjectionTypeVisitor() {
        }

        public PsiType visitType(@NotNull PsiType type2) {
            return type2;
        }

        public PsiType visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
            return (PsiType)capturedWildcardType.getLowerBound().accept((PsiTypeVisitor)this);
        }

        public PsiType visitArrayType(@NotNull PsiArrayType arrayType) {
            PsiType projection = (PsiType)arrayType.getComponentType().accept((PsiTypeVisitor)this);
            if (projection == PsiType.NULL) {
                return PsiType.NULL;
            }
            return projection.createArrayType();
        }

        public PsiType visitIntersectionType(@NotNull PsiIntersectionType intersectionType) {
            Object[] conjuncts = (PsiType[])Arrays.stream(intersectionType.getConjuncts()).map(conjunct -> (PsiType)conjunct.accept((PsiTypeVisitor)this)).toArray(PsiType[]::new);
            if (ArrayUtil.find((Object[])conjuncts, (Object)PsiType.NULL) > -1) {
                return PsiType.NULL;
            }
            return PsiIntersectionType.createIntersection((PsiType[])conjuncts);
        }

        public PsiType visitLambdaExpressionType(@NotNull PsiLambdaExpressionType lambdaExpressionType) {
            return lambdaExpressionType;
        }

        public PsiType visitMethodReferenceType(@NotNull PsiMethodReferenceType methodReferenceType) {
            return methodReferenceType;
        }

        public PsiType visitClassType(@NotNull PsiClassType classType) {
            PsiClassType.ClassResolveResult result = classType.resolveGenerics();
            PsiClass aClass = result.getElement();
            if (aClass != null) {
                PsiSubstitutor substitutor = result.getSubstitutor();
                PsiSubstitutor targetSubstitutor = PsiSubstitutor.EMPTY;
                for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass)) {
                    PsiType ai = substitutor.substitute(parameter2);
                    if (ai == null) {
                        return PsiType.NULL;
                    }
                    if (!JavaVarTypeUtil.mentionsRestrictedTypeVariables(ai)) {
                        targetSubstitutor = targetSubstitutor.put(parameter2, ai);
                        continue;
                    }
                    if (ai instanceof PsiWildcardType) {
                        if (((PsiWildcardType)ai).isExtends()) {
                            PsiType extendsBound = ((PsiWildcardType)ai).getExtendsBound();
                            PsiType projection = (PsiType)extendsBound.accept((PsiTypeVisitor)this);
                            if (projection == PsiType.NULL) {
                                return PsiType.NULL;
                            }
                            targetSubstitutor = targetSubstitutor.put(parameter2, (PsiType)PsiWildcardType.createExtends((PsiManager)parameter2.getManager(), (PsiType)projection));
                            continue;
                        }
                        if (((PsiWildcardType)ai).isSuper()) {
                            PsiType superBound = ((PsiWildcardType)ai).getSuperBound();
                            targetSubstitutor = targetSubstitutor.put(parameter2, JavaVarTypeUtil.getUpwardProjection(superBound));
                            continue;
                        }
                        return PsiType.NULL;
                    }
                    return PsiType.NULL;
                }
                return JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass, targetSubstitutor);
            }
            return PsiType.NULL;
        }
    }

    private static class UpwardProjectionTypeVisitor
    extends PsiTypeVisitorEx<PsiType> {
        private UpwardProjectionTypeVisitor() {
        }

        public PsiType visitType(@NotNull PsiType type2) {
            return type2;
        }

        @Nullable
        public PsiType visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
            return (PsiType)capturedWildcardType.getUpperBound().accept((PsiTypeVisitor)this);
        }

        public PsiType visitArrayType(@NotNull PsiArrayType arrayType) {
            PsiType componentType = arrayType.getComponentType();
            return ((PsiType)componentType.accept((PsiTypeVisitor)this)).createArrayType();
        }

        @Nullable
        public PsiType visitLambdaExpressionType(@NotNull PsiLambdaExpressionType lambdaExpressionType) {
            return lambdaExpressionType;
        }

        public PsiType visitMethodReferenceType(@NotNull PsiMethodReferenceType methodReferenceType) {
            return methodReferenceType;
        }

        public PsiType visitIntersectionType(@NotNull PsiIntersectionType intersectionType) {
            return PsiIntersectionType.createIntersection((PsiType[])((PsiType[])Arrays.stream(intersectionType.getConjuncts()).map(conjunct -> (PsiType)conjunct.accept((PsiTypeVisitor)this)).toArray(PsiType[]::new)));
        }

        public PsiType visitClassType(@NotNull PsiClassType classType) {
            PsiClassType.ClassResolveResult result = classType.resolveGenerics();
            PsiClass aClass = result.getElement();
            if (aClass != null) {
                PsiManager manager = aClass.getManager();
                PsiSubstitutor targetSubstitutor = PsiSubstitutor.EMPTY;
                PsiSubstitutor substitutor = result.getSubstitutor();
                for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass)) {
                    PsiType ai = substitutor.substitute(parameter2);
                    targetSubstitutor = targetSubstitutor.put(parameter2, ai);
                    if (ai == null || !JavaVarTypeUtil.mentionsRestrictedTypeVariables(ai)) continue;
                    if (ai instanceof PsiWildcardType) {
                        if (((PsiWildcardType)ai).isExtends()) {
                            targetSubstitutor = targetSubstitutor.put(parameter2, (PsiType)PsiWildcardType.createExtends((PsiManager)manager, (PsiType)((PsiType)((PsiWildcardType)ai).getExtendsBound().accept((PsiTypeVisitor)this))));
                        }
                        if (!((PsiWildcardType)ai).isSuper()) continue;
                        targetSubstitutor = targetSubstitutor.put(parameter2, (PsiType)UpwardProjectionTypeVisitor.createDownwardProjection(manager, ((PsiWildcardType)ai).getSuperBound()));
                        continue;
                    }
                    PsiType U = (PsiType)RecursionManager.doPreventingRecursion((Object)ai, (boolean)true, () -> (PsiType)ai.accept((PsiTypeVisitor)this));
                    if (U == null) {
                        targetSubstitutor = targetSubstitutor.put(parameter2, (PsiType)PsiWildcardType.createUnbounded((PsiManager)manager));
                        continue;
                    }
                    if (!U.equalsToText("java.lang.Object") && UpwardProjectionTypeVisitor.tryUpperBound(aClass, parameter2, U)) {
                        targetSubstitutor = targetSubstitutor.put(parameter2, (PsiType)PsiWildcardType.createExtends((PsiManager)manager, (PsiType)U));
                        continue;
                    }
                    targetSubstitutor = targetSubstitutor.put(parameter2, (PsiType)UpwardProjectionTypeVisitor.createDownwardProjection(manager, ai));
                }
                return JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass, targetSubstitutor);
            }
            return classType;
        }

        private static PsiWildcardType createDownwardProjection(PsiManager manager, PsiType bound) {
            PsiType downwardProjection = JavaVarTypeUtil.getDownwardProjection(bound);
            return downwardProjection != PsiType.NULL ? PsiWildcardType.createSuper((PsiManager)manager, (PsiType)downwardProjection) : PsiWildcardType.createUnbounded((PsiManager)manager);
        }

        private static boolean tryUpperBound(PsiClass aClass, PsiTypeParameter parameter2, PsiType U) {
            PsiClassType[] extendsListTypes = parameter2.getExtendsListTypes();
            if (extendsListTypes.length == 0) {
                return true;
            }
            PsiType bi = PsiIntersectionType.createIntersection((PsiType[])extendsListTypes);
            return PsiTypesUtil.mentionsTypeParameters((PsiType)bi, (Set)ContainerUtil.newHashSet((Object[])aClass.getTypeParameters())) || !U.isAssignableFrom(bi);
        }
    }
}

