/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowSearchUtil {
    private static final Logger LOG = Logger.getInstance(ThrowSearchUtil.class);

    private ThrowSearchUtil() {
    }

    private static boolean processExn(@NotNull PsiParameter aCatch, @NotNull Processor<? super UsageInfo> processor2, @NotNull Root root) {
        PsiType type2 = aCatch.getType();
        if (type2.isAssignableFrom(root.myType)) {
            processor2.process((Object)new UsageInfo((PsiElement)aCatch));
            return false;
        }
        if (!root.isExact && root.myType.isAssignableFrom(type2)) {
            processor2.process((Object)new UsageInfo((PsiElement)aCatch));
            return true;
        }
        return true;
    }

    private static boolean scanCatches(@NotNull PsiElement elem, @NotNull Processor<? super UsageInfo> processor2, @NotNull Root root, @NotNull FindUsagesOptions options, @NotNull Set<? super PsiMethod> processed) {
        while (elem != null) {
            PsiTryStatement tryStmt;
            PsiElement parent = elem.getParent();
            if (elem instanceof PsiMethod) {
                PsiMethod method;
                PsiMethod deepestSuperMethod = ((PsiMethod)elem).findDeepestSuperMethod();
                PsiMethod psiMethod = method = deepestSuperMethod != null ? deepestSuperMethod : (PsiMethod)elem;
                if (!processed.contains(method)) {
                    processed.add((PsiMethod)method);
                    PsiReference[] refs = (PsiReference[])MethodReferencesSearch.search((PsiMethod)method, (SearchScope)options.searchScope, (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY);
                    for (int i = 0; i != refs.length; ++i) {
                        if (ThrowSearchUtil.scanCatches(refs[i].getElement(), processor2, root, options, processed)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (elem instanceof PsiTryStatement) {
                PsiTryStatement aTry = (PsiTryStatement)elem;
                PsiParameter[] catches = aTry.getCatchBlockParameters();
                for (int i = 0; i != catches.length; ++i) {
                    if (ThrowSearchUtil.processExn(catches[i], processor2, root)) continue;
                    return false;
                }
            } else if (parent instanceof PsiTryStatement && elem != (tryStmt = (PsiTryStatement)parent).getTryBlock()) {
                elem = parent.getParent();
                continue;
            }
            elem = parent;
        }
        return true;
    }

    public static boolean addThrowUsages(@NotNull Processor<? super UsageInfo> processor2, @NotNull Root root, @NotNull FindUsagesOptions options) {
        HashSet processed = new HashSet();
        return ThrowSearchUtil.scanCatches(root.myElement, processor2, root, options, processed);
    }

    private static boolean isExactExnType(PsiExpression exn) {
        return exn instanceof PsiNewExpression;
    }

    public static Root @Nullable [] getSearchRoots(PsiElement element) {
        PsiElement parent;
        PsiKeyword kwd;
        if (element instanceof PsiThrowStatement) {
            PsiType exType;
            PsiThrowStatement aThrow = (PsiThrowStatement)element;
            PsiExpression exn = aThrow.getException();
            PsiType psiType = exType = exn == null ? null : exn.getType();
            if (exType == null) {
                return null;
            }
            return new Root[]{new Root(aThrow.getParent(), exType, ThrowSearchUtil.isExactExnType(exn))};
        }
        if (element instanceof PsiKeyword && "throws".equals((kwd = (PsiKeyword)element).getText()) && (parent = kwd.getParent()) != null && parent.getParent() instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent.getParent();
            PsiReferenceList throwsList = method.getThrowsList();
            PsiClassType[] exns = throwsList.getReferencedTypes();
            Root[] roots = new Root[exns.length];
            for (int i = 0; i != roots.length; ++i) {
                PsiClassType exn = exns[i];
                roots[i] = new Root((PsiElement)method, (PsiType)exn, false);
            }
            return roots;
        }
        return null;
    }

    public static boolean isSearchable(PsiElement element) {
        return ThrowSearchUtil.getSearchRoots(element) != null;
    }

    public static String getSearchableTypeName(PsiElement e) {
        if (e instanceof PsiThrowStatement) {
            PsiThrowStatement aThrow = (PsiThrowStatement)e;
            PsiType type2 = aThrow.getException().getType();
            return PsiFormatUtil.formatType((PsiType)type2, (int)8192, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        }
        if (e instanceof PsiKeyword && "throws".equals(e.getText())) {
            return e.getParent().getText();
        }
        LOG.error("invalid searchable element");
        return e.getText();
    }

    public static class Root {
        @NotNull
        private final PsiElement myElement;
        @NotNull
        private final PsiType myType;
        private final boolean isExact;

        public Root(@NotNull PsiElement root, @NotNull PsiType type2, boolean exact) {
            this.myElement = root;
            this.myType = type2;
            this.isExact = exact;
        }

        public String toString() {
            return PsiFormatUtil.formatType((PsiType)this.myType, (int)8192, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        }
    }
}

