/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class RelaxedDirectInheritorChecker {
    private final String myBaseClassName;
    private final PsiClass myBaseClass;
    private final VolatileNotNullLazyValue<Pair<PsiClass[], Boolean>> myClasses;
    private final ProjectFileIndex myFileIndex;

    public RelaxedDirectInheritorChecker(@NotNull PsiClass baseClass) {
        this.myBaseClass = baseClass;
        this.myBaseClassName = Objects.requireNonNull(baseClass.getName());
        this.myClasses = VolatileNotNullLazyValue.createValue(() -> RelaxedDirectInheritorChecker.getClassesAndTheirAmbiguities(this.myBaseClass.getProject(), this.myBaseClassName));
        this.myFileIndex = ProjectFileIndex.getInstance((Project)this.myBaseClass.getProject());
    }

    @NotNull
    private static Pair<PsiClass[], Boolean> getClassesAndTheirAmbiguities(@NotNull Project project, @NotNull String classShortName) {
        Map cache = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ConcurrentHashMap map2 = new ConcurrentHashMap();
            return CachedValueProvider.Result.create(map2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        Pair result = (Pair)SoftReference.dereference((Reference)((Reference)cache.get(classShortName)));
        if (result == null) {
            PsiClass[] classes2 = PsiShortNamesCache.getInstance((Project)project).getClassesByName(classShortName, GlobalSearchScope.allScope((Project)project));
            boolean ambiguities = RelaxedDirectInheritorChecker.hasAmbiguities(Arrays.asList(classes2));
            result = Pair.create((Object)classes2, (Object)ambiguities);
            cache.put(classShortName, new SoftReference((Object)result));
        }
        return result;
    }

    private static boolean hasAmbiguities(@NotNull List<? extends PsiClass> classes2) {
        int locals = 0;
        String theFQN = null;
        for (PsiClass psiClass : classes2) {
            String qName = psiClass.getQualifiedName();
            if (qName == null) {
                if (++locals <= 1) continue;
                return true;
            }
            if (theFQN == null) {
                theFQN = qName;
                continue;
            }
            if (theFQN.equals(qName)) continue;
            return true;
        }
        return locals == 1 && theFQN != null;
    }

    public boolean checkInheritance(@NotNull PsiClass inheritorCandidate) {
        if (!inheritorCandidate.isValid() || !this.myBaseClass.isValid()) {
            return false;
        }
        if (this.myFileIndex.isInSourceContent(inheritorCandidate.getContainingFile().getVirtualFile())) {
            GlobalSearchScope scope;
            Pair value2 = (Pair)this.myClasses.getValue();
            boolean hasGlobalAmbiguities = (Boolean)value2.getSecond();
            if (!hasGlobalAmbiguities) {
                return true;
            }
            Object[] classes2 = (PsiClass[])value2.getFirst();
            List accessible = ContainerUtil.findAll((Object[])classes2, arg_0 -> RelaxedDirectInheritorChecker.lambda$checkInheritance$2(scope = inheritorCandidate.getResolveScope(), inheritorCandidate, arg_0));
            if (!RelaxedDirectInheritorChecker.hasAmbiguities(accessible)) {
                return accessible.contains(this.myBaseClass);
            }
        }
        if (inheritorCandidate instanceof PsiCompiledElement && this.isEnumOrAnnotationInheritor(inheritorCandidate)) {
            return true;
        }
        return inheritorCandidate.isInheritor(this.myBaseClass, false);
    }

    private boolean isEnumOrAnnotationInheritor(@NotNull PsiClass inheritorCandidate) {
        if (inheritorCandidate.isEnum() && "java.lang.Enum".equals(this.myBaseClass.getQualifiedName())) {
            return true;
        }
        return inheritorCandidate.isAnnotationType() && "java.lang.annotation.Annotation".equals(this.myBaseClass.getQualifiedName());
    }

    private static boolean isAccessibleLight(@NotNull PsiClass inheritorCandidate, @NotNull PsiClass base) {
        PsiModifierList modifierList = base.getModifierList();
        if (modifierList != null && PsiUtil.getAccessLevel((PsiModifierList)modifierList) == 3) {
            return true;
        }
        return JavaResolveUtil.isAccessible((PsiMember)base, base.getContainingClass(), modifierList, (PsiElement)inheritorCandidate, null, null);
    }

    private static /* synthetic */ boolean lambda$checkInheritance$2(GlobalSearchScope scope, PsiClass inheritorCandidate, PsiClass base) {
        return PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)base) && RelaxedDirectInheritorChecker.isAccessibleLight(inheritorCandidate, base);
    }
}

