/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class JavaSourceFilterScope
extends DelegatingGlobalSearchScope {
    @Nullable
    private final ProjectFileIndex myIndex;
    private final boolean myIncludeVersions;

    public JavaSourceFilterScope(@NotNull GlobalSearchScope delegate) {
        this(delegate, false);
    }

    public JavaSourceFilterScope(@NotNull GlobalSearchScope delegate, boolean includeVersions) {
        super(delegate);
        Project project = this.getProject();
        this.myIndex = project == null ? null : ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.myIncludeVersions = includeVersions;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (!super.contains(file)) {
            return false;
        }
        if (this.myIndex == null) {
            return false;
        }
        if (FileTypeRegistry.getInstance().isFileOfType(file, (FileType)JavaClassFileType.INSTANCE)) {
            return this.myIndex.isInLibraryClasses(file) && (this.myIncludeVersions || !JavaSourceFilterScope.isVersioned(file, this.myIndex));
        }
        return this.myIndex.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.SOURCES) || this.myBaseScope.isForceSearchingInLibrarySources() && this.myIndex.isInLibrarySource(file);
    }

    private static boolean isVersioned(VirtualFile file, ProjectFileIndex index) {
        VirtualFile root = index.getClassRootForFile(file);
        while ((file = file.getParent()) != null && !file.equals(root)) {
            VirtualFile parent;
            if (!Comparing.equal((CharSequence)file.getNameSequence(), (CharSequence)"versions") || (parent = file.getParent()) == null || !Comparing.equal((CharSequence)parent.getNameSequence(), (CharSequence)"META-INF")) continue;
            return true;
        }
        return false;
    }
}

