/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.ClassesWithAnnotatedMembersSearch;
import com.intellij.psi.search.searches.ScopedQueryExecutor;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class ClassesWithAnnotatedMembersSearcher
extends QueryExecutorBase<PsiClass, ClassesWithAnnotatedMembersSearch.Parameters> {
    public void processQuery(@NotNull ClassesWithAnnotatedMembersSearch.Parameters queryParameters, @NotNull Processor<? super PsiClass> consumer) {
        SearchScope scope = queryParameters.getScope();
        for (QueryExecutor executor : ClassesWithAnnotatedMembersSearch.EP_NAME.getExtensionList()) {
            if (!(executor instanceof ScopedQueryExecutor)) continue;
            scope = scope.intersectWith((SearchScope)GlobalSearchScope.notScope((GlobalSearchScope)((ScopedQueryExecutor)executor).getScope((Object)queryParameters)));
        }
        HashSet processed = new HashSet();
        AnnotatedElementsSearch.searchPsiMembers((PsiClass)queryParameters.getAnnotationClass(), (SearchScope)scope).forEach(member -> {
            PsiClass psiClass = (PsiClass)ReadAction.compute(() -> member instanceof PsiClass ? (PsiClass)member : member.getContainingClass());
            if (psiClass != null && processed.add(psiClass)) {
                consumer.process((Object)psiClass);
            }
            return true;
        });
    }
}

