/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightJavaModule
extends LightElement
implements PsiJavaModule {
    private final LightJavaModuleReferenceElement myRefElement;
    private final VirtualFile myRoot;
    private final NotNullLazyValue<List<PsiPackageAccessibilityStatement>> myExports = AtomicNotNullLazyValue.createValue(() -> this.findExports());

    private LightJavaModule(@NotNull PsiManager manager, @NotNull VirtualFile root, @NotNull String name2) {
        super(manager, (Language)JavaLanguage.INSTANCE);
        this.myRoot = root;
        this.myRefElement = new LightJavaModuleReferenceElement(manager, name2);
    }

    @NotNull
    public VirtualFile getRootVirtualFile() {
        return this.myRoot;
    }

    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        return Collections.emptyList();
    }

    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getExports() {
        return (Iterable)this.myExports.getValue();
    }

    private List<PsiPackageAccessibilityStatement> findExports() {
        final ArrayList<PsiPackageAccessibilityStatement> exports = new ArrayList<PsiPackageAccessibilityStatement>();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myRoot, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){
            private final JavaDirectoryService service;
            {
                super(x0);
                this.service = JavaDirectoryService.getInstance();
            }

            public boolean visitFile(@NotNull VirtualFile file) {
                String packageName;
                PsiPackage pkg;
                PsiDirectory directory;
                if (file.isDirectory() && !LightJavaModule.this.myRoot.equals(file) && (directory = LightJavaModule.this.getManager().findDirectory(file)) != null && (pkg = this.service.getPackage(directory)) != null && !(packageName = pkg.getQualifiedName()).isEmpty() && !PsiUtil.isPackageEmpty((PsiDirectory[])new PsiDirectory[]{directory}, (String)packageName)) {
                    exports.add(new LightPackageAccessibilityStatement(LightJavaModule.this.getManager(), packageName));
                }
                return true;
            }
        });
        return exports;
    }

    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getOpens() {
        return Collections.emptyList();
    }

    @NotNull
    public Iterable<PsiUsesStatement> getUses() {
        return Collections.emptyList();
    }

    @NotNull
    public Iterable<PsiProvidesStatement> getProvides() {
        return Collections.emptyList();
    }

    @NotNull
    public PsiJavaModuleReferenceElement getNameIdentifier() {
        return this.myRefElement;
    }

    @NotNull
    public String getName() {
        return this.myRefElement.getReferenceText();
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot modify an automatic module '" + this.getName() + "'");
    }

    public PsiModifierList getModifierList() {
        return null;
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        return false;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return (PsiElement)ObjectUtils.notNull((Object)this.myManager.findDirectory(this.myRoot), (Object)super.getNavigationElement());
    }

    public boolean equals(Object obj) {
        return obj instanceof LightJavaModule && this.myRoot.equals(((LightJavaModule)((Object)obj)).myRoot) && this.getManager() == ((LightJavaModule)((Object)obj)).getManager();
    }

    public int hashCode() {
        return this.getName().hashCode() * 31 + this.getManager().hashCode();
    }

    public String toString() {
        return "PsiJavaModule:" + this.getName();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    @NotNull
    public static LightJavaModule getModule(@NotNull PsiManager manager, @NotNull VirtualFile root) {
        LightJavaModule module = LightJavaModule.findModule(manager, root);
        assert (module != null) : root;
        return module;
    }

    @Nullable
    public static LightJavaModule findModule(@NotNull PsiManager manager, @NotNull VirtualFile root) {
        PsiDirectory directory = manager.findDirectory(root);
        if (directory == null) {
            return null;
        }
        if (root.isInLocalFileSystem()) {
            return (LightJavaModule)((Object)CachedValuesManager.getCachedValue((PsiElement)directory, () -> {
                PsiFile file;
                VirtualFile manifest = root.findFileByRelativePath("META-INF/MANIFEST.MF");
                if (manifest != null && (file = manager.findFile(manifest)) != null) {
                    String name2 = LightJavaModule.claimedModuleName(manifest);
                    LightJavaModule module = name2 != null ? new LightJavaModule(manager, root, name2) : null;
                    return CachedValueProvider.Result.create((Object)((Object)module), (Object[])new Object[]{file});
                }
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }));
        }
        return (LightJavaModule)((Object)CachedValuesManager.getCachedValue((PsiElement)directory, () -> LightJavaModule.lambda$findModule$2(manager, root, (PsiElement)directory)));
    }

    @NotNull
    public static String moduleName(@NotNull VirtualFile jarRoot) {
        String claimed;
        VirtualFile manifest = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifest != null && (claimed = LightJavaModule.claimedModuleName(manifest)) != null) {
            return claimed;
        }
        return LightJavaModule.moduleName(jarRoot.getNameWithoutExtension());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String claimedModuleName(@NotNull VirtualFile manifest) {
        try (InputStream stream = manifest.getInputStream();){
            String string = new Manifest(stream).getMainAttributes().getValue("Automatic-Module-Name");
            return string;
        }
        catch (IOException e) {
            Logger.getInstance(LightJavaModule.class).warn(manifest.getPath(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static String moduleName(@NotNull String name2) {
        Matcher m = Patterns.VERSION.matcher(name2);
        if (m.find()) {
            name2 = name2.substring(0, m.start());
        }
        name2 = Patterns.NON_NAME.matcher(name2).replaceAll(".");
        name2 = Patterns.DOT_SEQUENCE.matcher(name2).replaceAll(".");
        name2 = StringUtil.trimLeading((String)StringUtil.trimTrailing((String)name2, (char)'.'), (char)'.');
        return name2;
    }

    private static /* synthetic */ CachedValueProvider.Result lambda$findModule$2(PsiManager manager, VirtualFile root, PsiElement directory) {
        LightJavaModule module = new LightJavaModule(manager, root, LightJavaModule.moduleName(root));
        return CachedValueProvider.Result.create((Object)((Object)module), (Object[])new Object[]{directory});
    }

    private static class Patterns {
        private static final Pattern VERSION = Pattern.compile("-(\\d+(\\.|$))");
        private static final Pattern NON_NAME = Pattern.compile("[^A-Za-z0-9]");
        private static final Pattern DOT_SEQUENCE = Pattern.compile("\\.{2,}");

        private Patterns() {
        }
    }

    private static class LightPackageAccessibilityStatement
    extends LightElement
    implements PsiPackageAccessibilityStatement {
        private final String myPackageName;

        LightPackageAccessibilityStatement(@NotNull PsiManager manager, @NotNull String packageName) {
            super(manager, (Language)JavaLanguage.INSTANCE);
            this.myPackageName = packageName;
        }

        @NotNull
        public PsiPackageAccessibilityStatement.Role getRole() {
            return PsiPackageAccessibilityStatement.Role.EXPORTS;
        }

        @Nullable
        public PsiJavaCodeReferenceElement getPackageReference() {
            return null;
        }

        @Nullable
        public String getPackageName() {
            return this.myPackageName;
        }

        @NotNull
        public Iterable<PsiJavaModuleReferenceElement> getModuleReferences() {
            return Collections.emptyList();
        }

        @NotNull
        public List<String> getModuleNames() {
            return Collections.emptyList();
        }

        public String toString() {
            return "PsiPackageAccessibilityStatement";
        }
    }

    private static class LightJavaModuleReferenceElement
    extends LightElement
    implements PsiJavaModuleReferenceElement {
        private final String myText;

        private LightJavaModuleReferenceElement(@NotNull PsiManager manager, @NotNull String text2) {
            super(manager, (Language)JavaLanguage.INSTANCE);
            this.myText = text2;
        }

        @NotNull
        public String getReferenceText() {
            return this.myText;
        }

        public PsiJavaModuleReference getReference() {
            return null;
        }

        public String toString() {
            return "PsiJavaModuleReference";
        }
    }
}

