/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.BitUtil;
import org.jetbrains.annotations.NotNull;

public class PsiParameterStubImpl
extends StubBase<PsiParameter>
implements PsiParameterStub {
    private static final byte ELLIPSIS = 1;
    private static final byte GENERATED_NAME = 2;
    private String myName;
    private final TypeInfo myType;
    private byte myFlags;

    private static byte packFlags(boolean isEllipsis, boolean generatedName) {
        byte flags = 0;
        flags = BitUtil.set((byte)flags, (byte)1, (boolean)isEllipsis);
        flags = BitUtil.set((byte)flags, (byte)2, (boolean)generatedName);
        return flags;
    }

    public PsiParameterStubImpl(StubElement parent, @NotNull String name2, @NotNull TypeInfo type2, boolean ellipsis, boolean generatedName) {
        this(parent, name2, type2, PsiParameterStubImpl.packFlags(ellipsis, generatedName));
    }

    public PsiParameterStubImpl(StubElement parent, @NotNull String name2, @NotNull TypeInfo type2, byte flags) {
        super(parent, (IStubElementType)JavaStubElementTypes.PARAMETER);
        this.myName = name2;
        this.myType = type2;
        this.myFlags = flags;
    }

    @Override
    public boolean isParameterTypeEllipsis() {
        return BitUtil.isSet((byte)this.myFlags, (byte)1);
    }

    @Override
    @NotNull
    public TypeInfo getType(boolean doResolve) {
        return doResolve ? this.myType.applyAnnotations(this) : this.myType;
    }

    @Override
    public PsiModifierListStub getModList() {
        for (StubElement child : this.getChildrenStubs()) {
            if (!(child instanceof PsiModifierListStub)) continue;
            return (PsiModifierListStub)child;
        }
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    public void setName(String name2) {
        this.myName = name2;
        this.myFlags = BitUtil.set((byte)this.myFlags, (byte)2, (boolean)false);
    }

    public boolean isAutoGeneratedName() {
        return BitUtil.isSet((byte)this.myFlags, (byte)2);
    }

    public byte getFlags() {
        return this.myFlags;
    }

    public String toString() {
        return "PsiParameterStub[" + this.myName + ':' + this.myType + ']';
    }
}

