/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.PsiJavaDirectoryImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class PsiJavaDirectoryFactory
extends PsiDirectoryFactory {
    private final PsiManagerImpl myManager;

    public PsiJavaDirectoryFactory(@NotNull Project project) {
        this.myManager = (PsiManagerImpl)PsiManager.getInstance((Project)project);
    }

    @NotNull
    public PsiDirectory createDirectory(@NotNull VirtualFile file) {
        return new PsiJavaDirectoryImpl(this.myManager, file);
    }

    @NotNull
    public String getQualifiedName(@NotNull PsiDirectory directory, boolean presentable) {
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (aPackage != null) {
            String qualifiedName = aPackage.getQualifiedName();
            if (!qualifiedName.isEmpty()) {
                return qualifiedName;
            }
            if (presentable) {
                return JavaBundle.message((String)"default.package.presentable.name", (Object[])new Object[0]) + " (" + directory.getVirtualFile().getPresentableUrl() + ")";
            }
            return "";
        }
        return presentable ? StringUtil.notNullize((String)FileUtil.getLocationRelativeToUserHome((String)directory.getVirtualFile().getPresentableUrl())) : "";
    }

    @Nullable
    public PsiDirectoryContainer getDirectoryContainer(@NotNull PsiDirectory directory) {
        return JavaDirectoryService.getInstance().getPackage(directory);
    }

    public boolean isPackage(@NotNull PsiDirectory directory) {
        VirtualFile virtualFile;
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myManager.getProject()).getFileIndex();
        return fileIndex.isUnderSourceRootOfType(virtualFile = directory.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) && fileIndex.getPackageNameByDirectory(virtualFile) != null;
    }

    public boolean isValidPackageName(String name2) {
        return PsiNameHelper.getInstance((Project)this.myManager.getProject()).isQualifiedName(name2);
    }
}

