/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

class ClsIdentifierImpl
extends ClsElementImpl
implements PsiIdentifier,
PsiJavaToken {
    private final PsiElement myParent;
    private final String myText;

    ClsIdentifierImpl(@NotNull PsiElement parent, String text2) {
        this.myParent = parent;
        this.myText = text2;
    }

    public IElementType getTokenType() {
        return JavaTokenType.IDENTIFIER;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    public PsiElement @NotNull [] getChildren() {
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    private boolean isCorrectName(String name2) {
        return name2 != null && ClsParsingUtil.isJavaIdentifier(name2, ((PsiJavaFile)this.getContainingFile()).getLanguageLevel());
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        String original = this.getText();
        if (this.isCorrectName(original)) {
            buffer.append(original);
        } else {
            buffer.append("$$").append(original).append(" /* Real name is '").append(original).append("' */");
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, JavaTokenType.IDENTIFIER);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitIdentifier((PsiIdentifier)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiIdentifier:" + this.getText();
    }
}

