/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.beanProperties;

import com.intellij.icons.AllIcons;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.util.PropertyUtilBase;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanPropertyElement
extends FakePsiElement
implements PsiMetaOwner,
PsiPresentableMetaData {
    private final PsiMethod myMethod;
    private final String myName;

    public BeanPropertyElement(@NotNull PsiMethod method, @NotNull String name2) {
        this.myMethod = method;
        this.myName = name2;
    }

    @Nullable
    public PsiType getPropertyType() {
        return PropertyUtilBase.getPropertyType((PsiMember)this.myMethod);
    }

    @NotNull
    public PsiMethod getMethod() {
        return this.myMethod;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this.myMethod;
    }

    public PsiManager getManager() {
        return this.myMethod.getManager();
    }

    public PsiElement getDeclaration() {
        return this;
    }

    @NonNls
    public String getName(PsiElement context) {
        return this.getName();
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public void init(PsiElement element) {
    }

    @Nullable
    public Icon getIcon(boolean flags) {
        return AllIcons.Nodes.Property;
    }

    public PsiElement getParent() {
        return this.myMethod;
    }

    @Nullable
    public PsiMetaData getMetaData() {
        return this;
    }

    public String getTypeName() {
        return JavaBundle.message((String)"bean.property", (Object[])new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return this.getIcon(0);
    }

    public TextRange getTextRange() {
        return TextRange.from((int)0, (int)0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BeanPropertyElement element = (BeanPropertyElement)((Object)o);
        if (!this.myMethod.equals(element.myMethod)) {
            return false;
        }
        return this.myName.equals(element.myName);
    }

    public int hashCode() {
        int result = this.myMethod.hashCode();
        result = 31 * result + this.myName.hashCode();
        return result;
    }
}

