/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.beanProperties;

import com.intellij.icons.AllIcons;
import com.intellij.ide.presentation.Presentation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(icon="AllIcons.Nodes.Property")
public class BeanProperty {
    private final PsiMethod myMethod;

    protected BeanProperty(@NotNull PsiMethod method) {
        this.myMethod = method;
    }

    public PsiNamedElement getPsiElement() {
        return new BeanPropertyElement(this.myMethod, this.getName()){

            @Override
            public PsiType getPropertyType() {
                return BeanProperty.this.getPropertyType();
            }
        };
    }

    @NotNull
    public String getName() {
        String name2 = PropertyUtilBase.getPropertyName((PsiMethod)this.myMethod);
        return name2 == null ? "" : name2;
    }

    @NotNull
    public PsiType getPropertyType() {
        PsiType type2 = PropertyUtilBase.getPropertyType((PsiMember)this.myMethod);
        assert (type2 != null);
        return type2;
    }

    @NotNull
    public PsiMethod getMethod() {
        return this.myMethod;
    }

    @Nullable
    public PsiMethod getGetter() {
        if (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)this.myMethod)) {
            return this.myMethod;
        }
        return PropertyUtilBase.findPropertyGetter((PsiClass)this.myMethod.getContainingClass(), (String)this.getName(), (boolean)false, (boolean)true);
    }

    @Nullable
    public PsiMethod getSetter() {
        if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)this.myMethod)) {
            return this.myMethod;
        }
        return PropertyUtilBase.findPropertySetter((PsiClass)this.myMethod.getContainingClass(), (String)this.getName(), (boolean)false, (boolean)true);
    }

    public void setName(String newName) throws IncorrectOperationException {
        PsiMethod setter = this.getSetter();
        PsiMethod getter = this.getGetter();
        if (getter != null) {
            String getterName = PropertyUtilBase.suggestGetterName((String)newName, (PsiType)getter.getReturnType());
            getter.setName(getterName);
        }
        if (setter != null) {
            String setterName = PropertyUtilBase.suggestSetterName((String)newName);
            setter.setName(setterName);
        }
    }

    @Nullable
    public Icon getIcon(int flags) {
        return AllIcons.Nodes.Property;
    }

    @Nullable
    public static BeanProperty createBeanProperty(@NotNull PsiMethod method) {
        return PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)method) ? new BeanProperty(method) : null;
    }
}

