/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.ThreadLocalTypes;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.ScopedClassHierarchy;
import com.intellij.psi.impl.TypeCorrector;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassImplUtil {
    private static final Logger LOG = Logger.getInstance(PsiClassImplUtil.class);
    private static final Key<ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass>> MAP_IN_CLASS_KEY = Key.create((String)"MAP_KEY");
    @NonNls
    private static final String ALL = "Intellij-IDEA-ALL";
    private static final Function<ClassIconRequest, Icon> FULL_ICON_EVALUATOR = r -> {
        if (!((ClassIconRequest)r).psiClass.isValid() || ((ClassIconRequest)r).psiClass.getProject().isDisposed()) {
            return null;
        }
        boolean isLocked = BitUtil.isSet((int)((ClassIconRequest)r).flags, (int)2) && !((ClassIconRequest)r).psiClass.isWritable();
        Icon symbolIcon = ((ClassIconRequest)r).symbolIcon != null ? ((ClassIconRequest)r).symbolIcon : ElementPresentationUtil.getClassIconOfKind(((ClassIconRequest)r).psiClass, ElementPresentationUtil.getClassKind(((ClassIconRequest)r).psiClass));
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon((Iconable)((ClassIconRequest)r).psiClass, symbolIcon, ElementPresentationUtil.getFlags((PsiModifierListOwner)((ClassIconRequest)r).psiClass, isLocked));
        Icon result = ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)((ClassIconRequest)r).psiClass, ((ClassIconRequest)r).flags, baseIcon);
        Iconable.LastComputedIcon.put((UserDataHolder)((ClassIconRequest)r).psiClass, (Icon)result, (int)((ClassIconRequest)r).flags);
        return result;
    };

    private PsiClassImplUtil() {
    }

    public static PsiField @NotNull [] getAllFields(@NotNull PsiClass aClass) {
        List<PsiField> map2 = PsiClassImplUtil.getAllByMap(aClass, MemberType.FIELD);
        return map2.toArray(PsiField.EMPTY_ARRAY);
    }

    public static PsiMethod @NotNull [] getAllMethods(@NotNull PsiClass aClass) {
        List<PsiMethod> methods = PsiClassImplUtil.getAllByMap(aClass, MemberType.METHOD);
        return methods.toArray(PsiMethod.EMPTY_ARRAY);
    }

    public static PsiClass @NotNull [] getAllInnerClasses(@NotNull PsiClass aClass) {
        List<PsiClass> classes2 = PsiClassImplUtil.getAllByMap(aClass, MemberType.CLASS);
        return classes2.toArray(PsiClass.EMPTY_ARRAY);
    }

    @Nullable
    public static PsiField findFieldByName(@NotNull PsiClass aClass, String name2, boolean checkBases) {
        List<PsiMember> byMap = PsiClassImplUtil.findByMap(aClass, name2, checkBases, MemberType.FIELD);
        return byMap.isEmpty() ? null : (PsiField)byMap.get(0);
    }

    public static PsiMethod @NotNull [] findMethodsByName(@NotNull PsiClass aClass, String name2, boolean checkBases) {
        List<PsiMember> methods = PsiClassImplUtil.findByMap(aClass, name2, checkBases, MemberType.METHOD);
        return methods.toArray(PsiMethod.EMPTY_ARRAY);
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod patternMethod, boolean checkBases) {
        List<PsiMethod> result = PsiClassImplUtil.findMethodsBySignature(aClass, patternMethod, checkBases, true);
        return result.isEmpty() ? null : result.get(0);
    }

    public static PsiMethod @NotNull [] findMethodsBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod patternMethod, boolean checkBases) {
        List<PsiMethod> methods = PsiClassImplUtil.findMethodsBySignature(aClass, patternMethod, checkBases, false);
        return methods.toArray(PsiMethod.EMPTY_ARRAY);
    }

    @NotNull
    private static List<PsiMethod> findMethodsBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod patternMethod, boolean checkBases, boolean stopOnFirst) {
        PsiMethod[] methodsByName = aClass.findMethodsByName(patternMethod.getName(), checkBases);
        if (methodsByName.length == 0) {
            return Collections.emptyList();
        }
        SmartList methods = new SmartList();
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : methodsByName) {
            PsiClass superClass = method.getContainingClass();
            PsiSubstitutor substitutor = checkBases && !aClass.equals(superClass) && superClass != null ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
            MethodSignature signature = method.getSignature(substitutor);
            if (!signature.equals(patternSignature)) continue;
            methods.add(method);
            if (stopOnFirst) break;
        }
        return methods;
    }

    @Nullable
    public static PsiClass findInnerByName(@NotNull PsiClass aClass, String name2, boolean checkBases) {
        List<PsiMember> byMap = PsiClassImplUtil.findByMap(aClass, name2, checkBases, MemberType.CLASS);
        return byMap.isEmpty() ? null : (PsiClass)byMap.get(0);
    }

    public static boolean processAllMembersWithoutSubstitutors(@NotNull PsiClass psiClass, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state) {
        String name2;
        ElementClassHint classHint2 = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        NameHint nameHint = (NameHint)processor2.getHint(NameHint.KEY);
        String string = name2 = nameHint == null ? null : nameHint.getName(state);
        if ((classHint2 == null || classHint2.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) && !PsiClassImplUtil.processMembers(state, processor2, PsiClassImplUtil.getMap(psiClass, MemberType.METHOD).get(name2 == null ? ALL : name2))) {
            return false;
        }
        if ((classHint2 == null || classHint2.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) && !PsiClassImplUtil.processMembers(state, processor2, PsiClassImplUtil.getMap(psiClass, MemberType.FIELD).get(name2 == null ? ALL : name2))) {
            return false;
        }
        return classHint2 != null && !classHint2.shouldProcess(ElementClassHint.DeclarationKind.CLASS) || PsiClassImplUtil.processMembers(state, processor2, PsiClassImplUtil.getMap(psiClass, MemberType.CLASS).get(name2 == null ? ALL : name2));
    }

    private static boolean processMembers(ResolveState state, PsiScopeProcessor processor2, PsiMember @Nullable [] members) {
        if (members == null) {
            return true;
        }
        for (PsiMember member : members) {
            if (processor2.execute((PsiElement)member, state)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<PsiMember> findByMap(@NotNull PsiClass aClass, String name2, boolean checkBases, @NotNull MemberType type2) {
        if (name2 == null) {
            return Collections.emptyList();
        }
        if (checkBases) {
            PsiMember[] list = PsiClassImplUtil.getMap(aClass, type2).get(name2);
            if (list == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(list);
        }
        PsiMethod[] members = null;
        switch (type2) {
            case METHOD: {
                members = aClass.getMethods();
                break;
            }
            case CLASS: {
                members = aClass.getInnerClasses();
                break;
            }
            case FIELD: {
                members = aClass.getFields();
            }
        }
        ArrayList<PsiMember> list = new ArrayList<PsiMember>();
        for (PsiMethod member : members) {
            if (!name2.equals(member.getName())) continue;
            list.add((PsiMember)member);
        }
        return list;
    }

    @NotNull
    public static <T extends PsiMember> List<Pair<T, PsiSubstitutor>> getAllWithSubstitutorsByMap(@NotNull PsiClass aClass, @NotNull MemberType type2) {
        return PsiClassImplUtil.withSubstitutors(aClass, PsiClassImplUtil.getMap(aClass, type2).get(ALL));
    }

    @NotNull
    private static <T extends PsiMember> List<T> getAllByMap(@NotNull PsiClass aClass, @NotNull MemberType type2) {
        return Arrays.asList(PsiClassImplUtil.getMap(aClass, type2).get(ALL));
    }

    private static Map<String, PsiMember[]> getMap(@NotNull PsiClass aClass, @NotNull MemberType type2) {
        ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> value2 = PsiClassImplUtil.getValues(aClass);
        return ((MembersMap)((Map)value2.getValue((Object)aClass)).get(aClass.getResolveScope())).get(type2);
    }

    @NotNull
    private static ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> getValues(@NotNull PsiClass aClass) {
        ParameterizedCachedValue value2 = (ParameterizedCachedValue)aClass.getUserData(MAP_IN_CLASS_KEY);
        if (value2 == null) {
            value2 = CachedValuesManager.getManager((Project)aClass.getProject()).createParameterizedCachedValue((ParameterizedCachedValueProvider)ByNameCachedValueProvider.INSTANCE, false);
            if (aClass.isPhysical()) {
                value2 = (ParameterizedCachedValue)((UserDataHolderEx)aClass).putUserDataIfAbsent(MAP_IN_CLASS_KEY, (Object)value2);
            }
        }
        return value2;
    }

    public static Icon getClassIcon(int flags, @NotNull PsiClass aClass) {
        return PsiClassImplUtil.getClassIcon(flags, aClass, null);
    }

    public static Icon getClassIcon(int flags, @NotNull PsiClass aClass, @Nullable Icon symbolIcon) {
        Icon base = Iconable.LastComputedIcon.get((UserDataHolder)aClass, (int)flags);
        if (base == null) {
            if (symbolIcon == null) {
                symbolIcon = ElementPresentationUtil.getClassIconOfKind(aClass, ElementPresentationUtil.getBasicClassKind(aClass));
            }
            RowIcon baseIcon = IconManager.getInstance().createLayeredIcon((Iconable)aClass, symbolIcon, 0);
            base = ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)aClass, flags, baseIcon);
        }
        return IconDeferrer.getInstance().defer(base, (Object)new ClassIconRequest(aClass, flags, symbolIcon), FULL_ICON_EVALUATOR);
    }

    @NotNull
    public static SearchScope getClassUseScope(@NotNull PsiClass aClass) {
        PsiDirectory dir;
        if (aClass instanceof PsiAnonymousClass) {
            return new LocalSearchScope((PsiElement)aClass);
        }
        GlobalSearchScope maximalUseScope = ResolveScopeManager.getElementUseScope((PsiElement)aClass);
        PsiFile file = aClass.getContainingFile();
        if (PsiImplUtil.isInServerPage((PsiElement)file)) {
            return maximalUseScope;
        }
        PsiClass containingClass = aClass.getContainingClass();
        if (aClass.hasModifierProperty("public") || aClass.hasModifierProperty("protected")) {
            return containingClass == null ? maximalUseScope : containingClass.getUseScope();
        }
        if (aClass.hasModifierProperty("private") || aClass instanceof PsiTypeParameter) {
            PsiClass topClass = PsiUtil.getTopLevelClass((PsiElement)aClass);
            return new LocalSearchScope((PsiElement)(topClass == null ? aClass.getContainingFile() : topClass));
        }
        PsiPackage aPackage = null;
        if (file instanceof PsiJavaFile) {
            aPackage = JavaPsiFacade.getInstance((Project)aClass.getProject()).findPackage(((PsiJavaFile)file).getPackageName());
        }
        if (aPackage == null && (dir = file.getContainingDirectory()) != null) {
            aPackage = JavaDirectoryService.getInstance().getPackage(dir);
        }
        if (aPackage != null) {
            GlobalSearchScope scope = PackageScope.packageScope(aPackage, (boolean)false);
            scope = scope.intersectWith((SearchScope)maximalUseScope);
            return scope;
        }
        return new LocalSearchScope((PsiElement)file);
    }

    public static boolean isMainOrPremainMethod(@NotNull PsiMethod method) {
        String name2 = method.getName();
        if (!("main".equals(name2) || "premain".equals(name2) || "agentmain".equals(name2))) {
            return false;
        }
        if (!PsiType.VOID.equals((Object)method.getReturnType())) {
            return false;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
        try {
            MethodSignature main = PsiClassImplUtil.createSignatureFromText(factory, "void main(String[] args);");
            if (MethodSignatureUtil.areSignaturesEqual((MethodSignature)signature, (MethodSignature)main)) {
                return true;
            }
            MethodSignature premain = PsiClassImplUtil.createSignatureFromText(factory, "void premain(String args, java.lang.instrument.Instrumentation i);");
            if (MethodSignatureUtil.areSignaturesEqual((MethodSignature)signature, (MethodSignature)premain)) {
                return true;
            }
            MethodSignature agentmain = PsiClassImplUtil.createSignatureFromText(factory, "void agentmain(String args, java.lang.instrument.Instrumentation i);");
            if (MethodSignatureUtil.areSignaturesEqual((MethodSignature)signature, (MethodSignature)agentmain)) {
                return true;
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    @NotNull
    private static MethodSignature createSignatureFromText(@NotNull PsiElementFactory factory, @NotNull String text2) {
        return factory.createMethodFromText(text2, null).getSignature(PsiSubstitutor.EMPTY);
    }

    @NotNull
    private static ConcurrentMap<MemberType, Map<String, PsiMember[]>> createMembersMap(@NotNull PsiClass psiClass, @NotNull GlobalSearchScope scope) {
        return ConcurrentFactoryMap.createMap(key2 -> {
            THashMap map2 = new THashMap();
            ArrayList<PsiClass> allMembers = new ArrayList<PsiClass>();
            map2.put(ALL, allMembers);
            JBTreeTraverser allSupers = (JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(c -> ContainerUtil.mapNotNull((Object[])c.getSupers(), s -> PsiSuperMethodUtil.correctClassByScope((PsiClass)s, (GlobalSearchScope)scope))).unique()).withRoot((Object)psiClass);
            for (PsiClass eachSuper : allSupers) {
                PsiClass[] members;
                for (PsiClass element : members = key2 == MemberType.CLASS ? eachSuper.getInnerClasses() : (key2 == MemberType.METHOD ? eachSuper.getMethods() : eachSuper.getFields())) {
                    if (PsiClassImplUtil.skipInvalid((PsiElement)element)) continue;
                    allMembers.add(element);
                    map2.computeIfAbsent(element.getName(), __ -> new SmartList()).add(element);
                }
            }
            THashMap result = new THashMap();
            for (Map.Entry entry : map2.entrySet()) {
                result.put(entry.getKey(), ((List)entry.getValue()).toArray(PsiMember.EMPTY_ARRAY));
            }
            return result;
        });
    }

    private static boolean skipInvalid(@NotNull PsiElement element) {
        try {
            PsiUtilCore.ensureValid((PsiElement)element);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return true;
        }
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static boolean processDeclarationsInEnum(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @NotNull ClassInnerStuffCache innerStuffCache) {
        return true;
    }

    public static boolean processDeclarationsInClass(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, @NotNull PsiElement place, @NotNull LanguageLevel languageLevel, boolean isRaw) {
        return PsiClassImplUtil.processDeclarationsInClass(aClass, processor2, state, visited, last, place, languageLevel, isRaw, place.getResolveScope());
    }

    private static boolean processDeclarationsInClass(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, @NotNull PsiElement place, @NotNull LanguageLevel languageLevel, boolean isRaw, @NotNull GlobalSearchScope resolveScope) {
        if (last instanceof PsiTypeParameterList || last instanceof PsiModifierList && aClass.getModifierList() == last) {
            return true;
        }
        if (visited != null && visited.contains(aClass)) {
            return true;
        }
        PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
        isRaw = isRaw || PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)aClass, (PsiSubstitutor)substitutor);
        NameHint nameHint = (NameHint)processor2.getHint(NameHint.KEY);
        if (nameHint != null) {
            String name2 = nameHint.getName(state);
            return PsiClassImplUtil.processCachedMembersByName(aClass, processor2, state, visited, last, place, isRaw, substitutor, (MembersMap)((Map)PsiClassImplUtil.getValues(aClass).getValue((Object)aClass)).get(resolveScope), name2, languageLevel, resolveScope);
        }
        return PsiClassImplUtil.processClassMembersWithAllNames(aClass, processor2, state, visited, last, place, isRaw, languageLevel, resolveScope);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean processCachedMembersByName(final @NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @Nullable Set<? super PsiClass> visited, PsiElement last, @NotNull PsiElement place, final boolean isRaw, final @NotNull PsiSubstitutor substitutor, @NotNull MembersMap value2, String name2, final @NotNull LanguageLevel languageLevel, final @NotNull GlobalSearchScope resolveScope) {
        PsiClass containingClass;
        boolean resolved;
        PsiMember[] list;
        Function<PsiMember, PsiSubstitutor> finalSubstitutor = new Function<PsiMember, PsiSubstitutor>(){
            final ScopedClassHierarchy hierarchy;
            final PsiElementFactory factory;
            {
                this.hierarchy = ScopedClassHierarchy.getHierarchy(aClass, resolveScope);
                this.factory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
            }

            public PsiSubstitutor fun(PsiMember member) {
                PsiSubstitutor finalSubstitutor = member.hasModifierProperty("static") ? substitutor : this.obtainSubstitutor(member);
                return member instanceof PsiMethod ? PsiClassImplUtil.checkRaw(isRaw, this.factory, (PsiMethod)member, finalSubstitutor) : finalSubstitutor;
            }

            private PsiSubstitutor obtainSubstitutor(PsiMember member) {
                PsiClass containingClass = Objects.requireNonNull(member.getContainingClass());
                PsiSubstitutor superSubstitutor = (PsiSubstitutor)ObjectUtils.notNull((Object)this.hierarchy.getSuperMembersSubstitutor(containingClass, languageLevel), (Object)PsiSubstitutor.EMPTY);
                return PsiClassImplUtil.obtainFinalSubstitutor(containingClass, superSubstitutor, aClass, substitutor, this.factory, languageLevel);
            }
        };
        ElementClassHint classHint2 = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        if (classHint2 == null || classHint2.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) {
            PsiField fieldByName = aClass.findFieldByName(name2, false);
            if (fieldByName != null) {
                if (!PsiClassImplUtil.skipInvalid((PsiElement)fieldByName)) {
                    processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)aClass);
                    if (!processor2.execute((PsiElement)fieldByName, state)) {
                        return false;
                    }
                }
            } else {
                Map allFieldsMap = value2.get(MemberType.FIELD);
                list = (PsiMember[])allFieldsMap.get(name2);
                if (list != null) {
                    resolved = false;
                    for (PsiMember candidateField : list) {
                        containingClass = candidateField.getContainingClass();
                        if (PsiClassImplUtil.skipInvalid((PsiElement)candidateField)) continue;
                        if (containingClass == null) {
                            PsiElement parent = candidateField.getParent();
                            LOG.error("No class for field " + candidateField.getName() + " of " + candidateField.getClass() + ", parent " + parent + " of " + (parent == null ? null : parent.getClass()));
                            continue;
                        }
                        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)containingClass);
                        if (processor2.execute((PsiElement)candidateField, state.put(PsiSubstitutor.KEY, finalSubstitutor.fun((Object)candidateField)))) continue;
                        resolved = true;
                    }
                    if (resolved) {
                        return false;
                    }
                }
            }
        }
        if (classHint2 == null || classHint2.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            if (last != null && last.getContext() == aClass) {
                if (last instanceof PsiClass && !processor2.execute(last, state)) {
                    return false;
                }
                PsiTypeParameterList list2 = aClass.getTypeParameterList();
                if (list2 != null && !list2.processDeclarations(processor2, state, last, place)) {
                    return false;
                }
            }
            if (!(last instanceof PsiReferenceList)) {
                PsiClass classByName = aClass.findInnerClassByName(name2, false);
                if (classByName != null) {
                    if (!PsiClassImplUtil.skipInvalid((PsiElement)classByName)) {
                        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)aClass);
                        if (!processor2.execute((PsiElement)classByName, state)) {
                            return false;
                        }
                    }
                } else {
                    Map allClassesMap = value2.get(MemberType.CLASS);
                    list = (PsiMember[])allClassesMap.get(name2);
                    if (list != null) {
                        resolved = false;
                        for (PsiMember inner : list) {
                            if (PsiClassImplUtil.skipInvalid((PsiElement)inner) || (containingClass = inner.getContainingClass()) == null) continue;
                            processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)containingClass);
                            if (processor2.execute((PsiElement)inner, state.put(PsiSubstitutor.KEY, finalSubstitutor.fun((Object)inner)))) continue;
                            resolved = true;
                        }
                        if (resolved) {
                            return false;
                        }
                    }
                }
            }
        }
        if (classHint2 == null || classHint2.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            MethodResolverProcessor methodResolverProcessor;
            if (processor2 instanceof MethodResolverProcessor && (methodResolverProcessor = (MethodResolverProcessor)processor2).isConstructor()) {
                PsiMethod[] constructors = aClass.getConstructors();
                methodResolverProcessor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                for (PsiMember psiMember : constructors) {
                    if (PsiClassImplUtil.skipInvalid((PsiElement)psiMember) || methodResolverProcessor.execute((PsiElement)psiMember, state)) continue;
                    return false;
                }
                return true;
            }
            Map allMethodsMap = value2.get(MemberType.METHOD);
            PsiMember[] list3 = (PsiMember[])allMethodsMap.get(name2);
            if (list3 != null) {
                void var19_27;
                boolean resolved2 = false;
                PsiMember[] psiMemberArray = list3;
                int n = psiMemberArray.length;
                boolean bl = false;
                while (var19_27 < n) {
                    PsiMember candidate = psiMemberArray[var19_27];
                    ProgressIndicatorProvider.checkCanceled();
                    PsiMethod candidateMethod = (PsiMethod)candidate;
                    if (!(PsiClassImplUtil.skipInvalid((PsiElement)candidateMethod) || processor2 instanceof MethodResolverProcessor && candidateMethod.isConstructor() != ((MethodResolverProcessor)processor2).isConstructor() || (containingClass = candidateMethod.getContainingClass()) == null || visited != null && visited.contains(containingClass))) {
                        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)containingClass);
                        if (!processor2.execute((PsiElement)candidateMethod, state.put(PsiSubstitutor.KEY, finalSubstitutor.fun((Object)candidateMethod)))) {
                            resolved2 = true;
                        }
                    }
                    ++var19_27;
                }
                if (resolved2) {
                    return false;
                }
                if (visited != null) {
                    void var19_29;
                    psiMemberArray = list3;
                    n = psiMemberArray.length;
                    boolean bl2 = false;
                    while (var19_29 < n) {
                        PsiMember aList = psiMemberArray[var19_29];
                        visited.add((PsiClass)aList.getContainingClass());
                        ++var19_29;
                    }
                }
            }
        }
        return true;
    }

    private static PsiSubstitutor checkRaw(boolean isRaw, @NotNull PsiElementFactory factory, @NotNull PsiMethod candidateMethod, @NotNull PsiSubstitutor substitutor) {
        PsiClass containingClass;
        if (isRaw && !candidateMethod.hasModifierProperty("static") && (containingClass = candidateMethod.getContainingClass()) != null && containingClass.hasTypeParameters()) {
            PsiTypeParameter[] methodTypeParameters = candidateMethod.getTypeParameters();
            substitutor = factory.createRawSubstitutor(substitutor, methodTypeParameters);
        }
        return substitutor;
    }

    public static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass candidateClass, @NotNull PsiSubstitutor candidateSubstitutor, @NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor, @NotNull PsiElementFactory elementFactory, @NotNull LanguageLevel languageLevel) {
        if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)aClass, (PsiSubstitutor)substitutor)) {
            return elementFactory.createRawSubstitutor((PsiTypeParameterListOwner)candidateClass).putAll(substitutor);
        }
        PsiClassType containingType = elementFactory.createType(candidateClass, candidateSubstitutor, languageLevel);
        PsiType type2 = substitutor.substitute((PsiType)containingType);
        if (!(type2 instanceof PsiClassType)) {
            return candidateSubstitutor;
        }
        return ((PsiClassType)type2).resolveGenerics().getSubstitutor();
    }

    private static boolean processClassMembersWithAllNames(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, @NotNull PsiElement place, boolean isRaw, @NotNull LanguageLevel languageLevel, @NotNull GlobalSearchScope resolveScope) {
        ProgressManager.checkCanceled();
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add((PsiClass)aClass)) {
            return true;
        }
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)aClass);
        ElementClassHint classHint2 = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        if ((classHint2 == null || classHint2.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) && !PsiClassImplUtil.processMembers(state, processor2, (PsiMember[])aClass.getFields())) {
            return false;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
        if (classHint2 == null || classHint2.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            PsiSubstitutor baseSubstitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
            for (PsiMethod method : aClass.getMethods()) {
                ResolveState methodState;
                PsiSubstitutor finalSubstitutor = PsiClassImplUtil.checkRaw(isRaw, factory, method, baseSubstitutor);
                ResolveState resolveState = methodState = finalSubstitutor == baseSubstitutor ? state : state.put(PsiSubstitutor.KEY, (Object)finalSubstitutor);
                if (processor2.execute((PsiElement)method, methodState)) continue;
                return false;
            }
        }
        if (classHint2 == null || classHint2.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiTypeParameterList list;
            if (last != null && last.getContext() == aClass && (list = aClass.getTypeParameterList()) != null && !list.processDeclarations(processor2, ResolveState.initial(), last, place)) {
                return false;
            }
            if (!(last instanceof PsiReferenceList || last instanceof PsiModifierList || PsiClassImplUtil.processMembers(state, processor2, (PsiMember[])aClass.getInnerClasses()))) {
                return false;
            }
        }
        if (last instanceof PsiReferenceList) {
            return true;
        }
        THashSet visited1 = visited;
        return PsiClassImplUtil.processSuperTypes(aClass, (PsiSubstitutor)state.get(PsiSubstitutor.KEY), factory, languageLevel, resolveScope, (PairProcessor<? super PsiClass, ? super PsiSubstitutor>)((PairProcessor)(arg_0, arg_1) -> PsiClassImplUtil.lambda$processClassMembersWithAllNames$5(processor2, state, (Set)visited1, last, place, languageLevel, isRaw, resolveScope, arg_0, arg_1)));
    }

    @Nullable
    public static <T extends PsiType> T correctType(@Nullable T originalType, @NotNull GlobalSearchScope resolveScope) {
        if (originalType == null || !Registry.is((String)"java.correct.class.type.by.place.resolve.scope")) {
            return originalType;
        }
        return new TypeCorrector(resolveScope).correctType(originalType);
    }

    public static List<PsiClassType.ClassResolveResult> getScopeCorrectedSuperTypes(PsiClass aClass, GlobalSearchScope resolveScope) {
        if (PsiClassImplUtil.skipInvalid((PsiElement)aClass)) {
            return Collections.emptyList();
        }
        return ScopedClassHierarchy.getHierarchy(aClass, resolveScope).getImmediateSupersWithCapturing();
    }

    static boolean processSuperTypes(@NotNull PsiClass aClass, PsiSubstitutor substitutor, @NotNull PsiElementFactory factory, @NotNull LanguageLevel languageLevel, GlobalSearchScope resolveScope, PairProcessor<? super PsiClass, ? super PsiSubstitutor> processor2) {
        boolean resolved = false;
        for (PsiClassType.ClassResolveResult superTypeResolveResult : PsiClassImplUtil.getScopeCorrectedSuperTypes(aClass, resolveScope)) {
            PsiClass superClass = superTypeResolveResult.getElement();
            assert (superClass != null);
            PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(superClass, superTypeResolveResult.getSubstitutor(), aClass, substitutor, factory, languageLevel);
            if (processor2.process((Object)superClass, (Object)finalSubstitutor)) continue;
            resolved = true;
        }
        return !resolved;
    }

    @Nullable
    public static PsiClass getSuperClass(@NotNull PsiClass psiClass) {
        if (psiClass.isInterface()) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
        }
        if (psiClass.isEnum()) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Enum");
        }
        if (psiClass.isRecord()) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Record");
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass == null || baseClass.isInterface()) {
                return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
            }
            return baseClass;
        }
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return null;
        }
        PsiClassType[] referenceElements = psiClass.getExtendsListTypes();
        if (referenceElements.length == 0) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
        }
        PsiClass psiResolved = referenceElements[0].resolve();
        return psiResolved == null ? PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object") : psiResolved;
    }

    @Nullable
    private static PsiClass findSpecialSuperClass(@NotNull PsiClass psiClass, String className2) {
        return JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(className2, psiClass.getResolveScope());
    }

    public static PsiClass @NotNull [] getSupers(@NotNull PsiClass psiClass) {
        PsiClass[] supers;
        for (PsiClass aSuper : supers = PsiClassImplUtil.getSupersInner(psiClass)) {
            LOG.assertTrue(aSuper != null);
        }
        return supers;
    }

    private static PsiClass @NotNull [] getSupersInner(@NotNull PsiClass psiClass) {
        PsiClassType[] extendsListTypes = psiClass.getExtendsListTypes();
        if (psiClass.isInterface()) {
            return PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass, true);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray;
            PsiAnonymousClass psiAnonymousClass = (PsiAnonymousClass)psiClass;
            PsiClassType baseClassReference = psiAnonymousClass.getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null) {
                if (baseClass.isInterface()) {
                    PsiClass[] psiClassArray2;
                    PsiClass objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
                    if (objectClass != null) {
                        PsiClass[] psiClassArray3 = new PsiClass[2];
                        psiClassArray3[0] = objectClass;
                        psiClassArray2 = psiClassArray3;
                        psiClassArray3[1] = baseClass;
                    } else {
                        PsiClass[] psiClassArray4 = new PsiClass[1];
                        psiClassArray2 = psiClassArray4;
                        psiClassArray4[0] = baseClass;
                    }
                    return psiClassArray2;
                }
                return new PsiClass[]{baseClass};
            }
            PsiClass objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
            if (objectClass != null) {
                PsiClass[] psiClassArray5 = new PsiClass[1];
                psiClassArray = psiClassArray5;
                psiClassArray5[0] = objectClass;
            } else {
                psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            return psiClassArray;
        }
        if (psiClass instanceof PsiTypeParameter) {
            if (extendsListTypes.length == 0) {
                PsiClass[] psiClassArray;
                PsiClass objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
                if (objectClass != null) {
                    PsiClass[] psiClassArray6 = new PsiClass[1];
                    psiClassArray = psiClassArray6;
                    psiClassArray6[0] = objectClass;
                } else {
                    psiClassArray = PsiClass.EMPTY_ARRAY;
                }
                return psiClassArray;
            }
            return PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass, false);
        }
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        PsiClass[] interfaces = PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass, false);
        PsiClass superClass = PsiClassImplUtil.getSuperClass(psiClass);
        if (superClass == null) {
            return interfaces;
        }
        PsiClass[] types = new PsiClass[interfaces.length + 1];
        types[0] = superClass;
        System.arraycopy(interfaces, 0, types, 1, interfaces.length);
        return types;
    }

    public static PsiClassType @NotNull [] getSuperTypes(@NotNull PsiClass psiClass) {
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass == null || !baseClass.isInterface()) {
                return new PsiClassType[]{baseClassType};
            }
            PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)psiClass.getManager(), (GlobalSearchScope)psiClass.getResolveScope());
            return new PsiClassType[]{objectType, baseClassType};
        }
        PsiClassType[] extendsTypes = psiClass.getExtendsListTypes();
        PsiClassType[] implementsTypes = psiClass.getImplementsListTypes();
        boolean hasExtends = extendsTypes.length != 0;
        int extendsListLength = extendsTypes.length + (hasExtends ? 0 : 1);
        PsiClassType[] result = new PsiClassType[extendsListLength + implementsTypes.length];
        System.arraycopy(extendsTypes, 0, result, 0, extendsTypes.length);
        if (!hasExtends) {
            PsiClassType objectType;
            if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
                return PsiClassType.EMPTY_ARRAY;
            }
            PsiManager manager = psiClass.getManager();
            result[0] = objectType = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)psiClass.getResolveScope());
        }
        System.arraycopy(implementsTypes, 0, result, extendsListLength, implementsTypes.length);
        return result;
    }

    @NotNull
    private static PsiClassType getAnnotationSuperType(@NotNull PsiClass psiClass, @NotNull PsiElementFactory factory) {
        return factory.createTypeByFQClassName("java.lang.annotation.Annotation", psiClass.getResolveScope());
    }

    private static PsiClassType getEnumSuperType(@NotNull PsiClass psiClass, @NotNull PsiElementFactory factory) {
        Object superType;
        PsiClass enumClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Enum");
        if (enumClass == null) {
            try {
                superType = (PsiClassType)factory.createTypeFromText("java.lang.Enum", null);
            }
            catch (IncorrectOperationException e) {
                superType = null;
            }
        } else {
            PsiTypeParameter[] typeParameters = enumClass.getTypeParameters();
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (typeParameters.length == 1) {
                substitutor = substitutor.put(typeParameters[0], (PsiType)factory.createType(psiClass));
            }
            superType = new PsiImmediateClassType(enumClass, substitutor);
        }
        return superType;
    }

    public static PsiClass @NotNull [] getInterfaces(@NotNull PsiTypeParameter typeParameter) {
        PsiClassType[] referencedTypes = typeParameter.getExtendsListTypes();
        if (referencedTypes.length == 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(referencedTypes.length);
        for (PsiClassType referencedType : referencedTypes) {
            PsiClass psiClass = referencedType.resolve();
            if (psiClass == null || !psiClass.isInterface()) continue;
            result.add(psiClass);
        }
        return result.toArray(PsiClass.EMPTY_ARRAY);
    }

    public static PsiClass @NotNull [] getInterfaces(@NotNull PsiClass psiClass) {
        if (psiClass.isInterface()) {
            return PsiClassImplUtil.resolveClassReferenceList(psiClass.getExtendsListTypes(), psiClass, false);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray;
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null && baseClass.isInterface()) {
                PsiClass[] psiClassArray2 = new PsiClass[1];
                psiClassArray = psiClassArray2;
                psiClassArray2[0] = baseClass;
            } else {
                psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            return psiClassArray;
        }
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        return PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass, false);
    }

    private static PsiClass @NotNull [] resolveClassReferenceList(PsiClassType @NotNull [] listOfTypes, @NotNull PsiClass psiClass, boolean includeObject) {
        PsiClass objectClass = null;
        if (includeObject && (objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object")) == null) {
            includeObject = false;
        }
        if (listOfTypes.length == 0) {
            if (includeObject) {
                return new PsiClass[]{objectClass};
            }
            return PsiClass.EMPTY_ARRAY;
        }
        int referenceCount = listOfTypes.length;
        if (includeObject) {
            ++referenceCount;
        }
        PsiClass[] resolved = new PsiClass[referenceCount];
        int resolvedCount = 0;
        if (includeObject) {
            resolved[resolvedCount++] = objectClass;
        }
        for (PsiClassType reference : listOfTypes) {
            PsiClass refResolved = reference.resolve();
            if (refResolved == null) continue;
            resolved[resolvedCount++] = refResolved;
        }
        if (resolvedCount < referenceCount) {
            PsiClass[] shorter = new PsiClass[resolvedCount];
            System.arraycopy(resolved, 0, shorter, 0, resolvedCount);
            resolved = shorter;
        }
        return resolved;
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(@NotNull PsiClass psiClass, String name2, boolean checkBases) {
        if (!checkBases) {
            PsiMethod[] methodsByName = psiClass.findMethodsByName(name2, false);
            ArrayList<Pair<PsiMethod, PsiSubstitutor>> ret = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>(methodsByName.length);
            for (PsiMethod method : methodsByName) {
                ret.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)method, (Object)PsiSubstitutor.EMPTY));
            }
            return ret;
        }
        PsiMember[] list = PsiClassImplUtil.getMap(psiClass, MemberType.METHOD).get(name2);
        if (list == null) {
            return Collections.emptyList();
        }
        return PsiClassImplUtil.withSubstitutors(psiClass, list);
    }

    @NotNull
    private static <T extends PsiMember> List<Pair<T, PsiSubstitutor>> withSubstitutors(@NotNull PsiClass psiClass, PsiMember[] members) {
        ScopedClassHierarchy hierarchy = ScopedClassHierarchy.getHierarchy(psiClass, psiClass.getResolveScope());
        LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)psiClass);
        return ContainerUtil.map((Object[])members, member -> {
            PsiClass containingClass = member.getContainingClass();
            PsiSubstitutor substitutor = containingClass == null ? null : hierarchy.getSuperMembersSubstitutor(containingClass, level);
            return Pair.create((Object)member, (Object)(substitutor == null ? PsiSubstitutor.EMPTY : substitutor));
        });
    }

    public static PsiClassType @NotNull [] getExtendsListTypes(@NotNull PsiClass psiClass) {
        PsiType upperBound;
        if (psiClass.isEnum()) {
            PsiClassType[] psiClassTypeArray;
            PsiClassType enumSuperType = PsiClassImplUtil.getEnumSuperType(psiClass, JavaPsiFacade.getElementFactory((Project)psiClass.getProject()));
            if (enumSuperType == null) {
                psiClassTypeArray = PsiClassType.EMPTY_ARRAY;
            } else {
                PsiClassType[] psiClassTypeArray2 = new PsiClassType[1];
                psiClassTypeArray = psiClassTypeArray2;
                psiClassTypeArray2[0] = enumSuperType;
            }
            return psiClassTypeArray;
        }
        if (psiClass.isRecord()) {
            PsiClass recordClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Record");
            if (recordClass != null) {
                return new PsiClassType[]{new PsiImmediateClassType(recordClass, PsiSubstitutor.EMPTY)};
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
            return new PsiClassType[]{factory.createTypeByFQClassName("java.lang.Record", psiClass.getResolveScope())};
        }
        if (psiClass.isAnnotationType()) {
            return new PsiClassType[]{PsiClassImplUtil.getAnnotationSuperType(psiClass, JavaPsiFacade.getElementFactory((Project)psiClass.getProject()))};
        }
        PsiType psiType = upperBound = psiClass instanceof PsiTypeParameter ? TypeConversionUtil.getInferredUpperBoundForSynthetic((PsiTypeParameter)((PsiTypeParameter)psiClass)) : null;
        if (upperBound == null && psiClass instanceof PsiTypeParameter) {
            upperBound = ThreadLocalTypes.getElementType((PsiElement)psiClass);
        }
        if (upperBound instanceof PsiIntersectionType) {
            PsiType[] conjuncts = ((PsiIntersectionType)upperBound).getConjuncts();
            ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
            for (PsiType conjunct : conjuncts) {
                if (!(conjunct instanceof PsiClassType)) continue;
                result.add((PsiClassType)conjunct);
            }
            return result.toArray(PsiClassType.EMPTY_ARRAY);
        }
        if (upperBound instanceof PsiClassType) {
            return new PsiClassType[]{(PsiClassType)upperBound};
        }
        PsiReferenceList extendsList = psiClass.getExtendsList();
        if (extendsList != null) {
            return extendsList.getReferencedTypes();
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    public static PsiClassType @NotNull [] getImplementsListTypes(@NotNull PsiClass psiClass) {
        PsiReferenceList extendsList = psiClass.getImplementsList();
        if (extendsList != null) {
            return extendsList.getReferencedTypes();
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    static boolean isInExtendsList(@NotNull PsiClass psiClass, @NotNull PsiClass baseClass, @Nullable String baseName, @NotNull PsiManager manager) {
        PsiType upperBound;
        if (psiClass.isEnum()) {
            return "java.lang.Enum".equals(baseClass.getQualifiedName());
        }
        if (psiClass.isAnnotationType()) {
            return "java.lang.annotation.Annotation".equals(baseClass.getQualifiedName());
        }
        PsiType psiType = upperBound = psiClass instanceof PsiTypeParameter ? TypeConversionUtil.getInferredUpperBoundForSynthetic((PsiTypeParameter)((PsiTypeParameter)psiClass)) : null;
        if (upperBound == null && psiClass instanceof PsiTypeParameter) {
            upperBound = ThreadLocalTypes.getElementType((PsiElement)psiClass);
        }
        if (upperBound instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)upperBound).getConjuncts()) {
                if (!(conjunct instanceof PsiClassType) || !((PsiClassType)conjunct).getClassName().equals(baseName) || !baseClass.equals(((PsiClassType)conjunct).resolve())) continue;
                return true;
            }
            return false;
        }
        if (upperBound instanceof PsiClassType) {
            return ((PsiClassType)upperBound).getClassName().equals(baseName) && baseClass.equals(((PsiClassType)upperBound).resolve());
        }
        return PsiClassImplUtil.isInReferenceList(psiClass.getExtendsList(), baseClass, baseName, manager);
    }

    /*
     * WARNING - void declaration
     */
    static boolean isInReferenceList(@Nullable PsiReferenceList list, @NotNull PsiClass baseClass, @Nullable String baseName, @NotNull PsiManager manager) {
        if (list == null) {
            return false;
        }
        if (list instanceof StubBasedPsiElement) {
            StubElement stub = ((StubBasedPsiElement)list).getStub();
            if (stub instanceof PsiClassReferenceListStub && baseName != null) {
                void var7_14;
                PsiClassReferenceListStub classStub = (PsiClassReferenceListStub)stub;
                String[] names2 = classStub.getReferencedNames();
                boolean bl = false;
                while (var7_14 < names2.length) {
                    String name2 = PsiNameHelper.getShortClassName((String)names2[var7_14]);
                    if (name2.endsWith(baseName)) {
                        PsiClass resolved;
                        PsiClassType[] referencedTypes = classStub.getReferencedTypes();
                        PsiClassType type2 = var7_14 >= referencedTypes.length ? null : referencedTypes[var7_14];
                        PsiClass psiClass = resolved = type2 == null ? null : type2.resolve();
                        if (manager.areElementsEquivalent((PsiElement)baseClass, (PsiElement)resolved)) {
                            return true;
                        }
                    }
                    ++var7_14;
                }
                return false;
            }
            if (stub != null) {
                void var7_16;
                PsiClassType[] psiClassTypeArray = list.getReferencedTypes();
                int n = psiClassTypeArray.length;
                boolean bl = false;
                while (var7_16 < n) {
                    PsiClassType type3 = psiClassTypeArray[var7_16];
                    if (Objects.equals(type3.getClassName(), baseName) && manager.areElementsEquivalent((PsiElement)baseClass, (PsiElement)type3.resolve())) {
                        return true;
                    }
                    ++var7_16;
                }
                return false;
            }
        }
        if (list.getLanguage() == JavaLanguage.INSTANCE) {
            for (PsiJavaCodeReferenceElement psiJavaCodeReferenceElement : list.getReferenceElements()) {
                if (!Comparing.strEqual((String)baseName, (String)psiJavaCodeReferenceElement.getReferenceName()) || !manager.areElementsEquivalent((PsiElement)baseClass, psiJavaCodeReferenceElement.resolve())) continue;
                return true;
            }
            return false;
        }
        for (PsiJavaCodeReferenceElement psiJavaCodeReferenceElement : list.getReferencedTypes()) {
            if (!Objects.equals(psiJavaCodeReferenceElement.getClassName(), baseName) || !manager.areElementsEquivalent((PsiElement)baseClass, (PsiElement)psiJavaCodeReferenceElement.resolve())) continue;
            return true;
        }
        return false;
    }

    public static boolean isClassEquivalentTo(@NotNull PsiClass aClass, PsiElement another) {
        PsiFile original2;
        if (aClass == another) {
            return true;
        }
        if (!(another instanceof PsiClass)) {
            return false;
        }
        String name1 = aClass.getName();
        if (name1 == null) {
            return false;
        }
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiClass)another).getName();
        if (name2 == null) {
            return false;
        }
        if (name1.hashCode() != name2.hashCode()) {
            return false;
        }
        if (!name1.equals(name2)) {
            return false;
        }
        String qName1 = aClass.getQualifiedName();
        String qName2 = ((PsiClass)another).getQualifiedName();
        if (qName1 == null || qName2 == null) {
            if (qName1 != qName2) {
                return false;
            }
            if (aClass instanceof PsiTypeParameter && another instanceof PsiTypeParameter) {
                PsiTypeParameter p1 = (PsiTypeParameter)aClass;
                PsiTypeParameter p2 = (PsiTypeParameter)another;
                if (p1.getIndex() != p2.getIndex()) {
                    return false;
                }
                if (TypeConversionUtil.areSameFreshVariables((PsiTypeParameter)p1, (PsiTypeParameter)p2)) {
                    return true;
                }
                return !Boolean.FALSE.equals(RecursionManager.doPreventingRecursion((Object)Pair.create((Object)p1, (Object)p2), (boolean)true, () -> aClass.getManager().areElementsEquivalent((PsiElement)p1.getOwner(), (PsiElement)p2.getOwner())));
            }
            return false;
        }
        if (qName1.hashCode() != qName2.hashCode() || !qName1.equals(qName2)) {
            return false;
        }
        if (aClass.getOriginalElement().equals(another.getOriginalElement())) {
            return true;
        }
        PsiFile file1 = PsiClassImplUtil.getOriginalFile(aClass);
        PsiFile file2 = PsiClassImplUtil.getOriginalFile((PsiClass)another);
        PsiFile original1 = (PsiFile)file1.getUserData(PsiFileFactory.ORIGINAL_FILE);
        if (original1 == (original2 = (PsiFile)file2.getUserData(PsiFileFactory.ORIGINAL_FILE)) && original1 != null || original1 == file2 || original2 == file1 || file1 == file2) {
            return true;
        }
        FileIndexFacade fileIndex = (FileIndexFacade)ServiceManager.getService((Project)file1.getProject(), FileIndexFacade.class);
        FileIndexFacade fileIndex2 = (FileIndexFacade)ServiceManager.getService((Project)file2.getProject(), FileIndexFacade.class);
        VirtualFile vfile1 = file1.getViewProvider().getVirtualFile();
        VirtualFile vfile2 = file2.getViewProvider().getVirtualFile();
        boolean lib1 = fileIndex.isInLibraryClasses(vfile1);
        boolean lib2 = fileIndex2.isInLibraryClasses(vfile2);
        return !(!fileIndex.isInSource(vfile1) && !lib1 || !fileIndex2.isInSource(vfile2) && !lib2);
    }

    @NotNull
    private static PsiFile getOriginalFile(@NotNull PsiClass aClass) {
        PsiFile file = aClass.getContainingFile();
        if (file == null) {
            PsiUtilCore.ensureValid((PsiElement)aClass);
            throw new IllegalStateException("No containing file for " + aClass.getLanguage() + " " + aClass.getClass());
        }
        return file.getOriginalFile();
    }

    public static boolean isFieldEquivalentTo(@NotNull PsiField field, PsiElement another) {
        if (!(another instanceof PsiField)) {
            return false;
        }
        String name1 = field.getName();
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiField)another).getName();
        if (!name1.equals(name2)) {
            return false;
        }
        PsiClass aClass1 = field.getContainingClass();
        PsiClass aClass2 = ((PsiField)another).getContainingClass();
        return aClass1 != null && aClass2 != null && field.getManager().areElementsEquivalent((PsiElement)aClass1, (PsiElement)aClass2);
    }

    public static boolean isMethodEquivalentTo(@NotNull PsiMethod method1, PsiElement another) {
        PsiParameter[] parameters2;
        if (method1 == another) {
            return true;
        }
        if (!(another instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)another;
        if (!another.isValid()) {
            return false;
        }
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        PsiClass aClass1 = method1.getContainingClass();
        PsiClass aClass2 = method2.getContainingClass();
        PsiManager manager = method1.getManager();
        if (aClass1 == null || aClass2 == null || !manager.areElementsEquivalent((PsiElement)aClass1, (PsiElement)aClass2)) {
            return false;
        }
        PsiParameter[] parameters1 = method1.getParameterList().getParameters();
        if (parameters1.length != (parameters2 = method2.getParameterList().getParameters()).length) {
            return false;
        }
        for (int i = 0; i < parameters1.length; ++i) {
            PsiType type2;
            PsiParameter parameter1 = parameters1[i];
            PsiParameter parameter2 = parameters2[i];
            PsiType type1 = parameter1.getType();
            if (PsiClassImplUtil.compareParamTypes(manager, type1, type2 = parameter2.getType(), new HashSet())) continue;
            return false;
        }
        return true;
    }

    private static boolean compareParamTypes(@NotNull PsiManager manager, @NotNull PsiType type1, @NotNull PsiType type2, Set<? super String> visited) {
        if (type1 instanceof PsiArrayType) {
            PsiType componentType2;
            PsiType componentType1;
            return type2 instanceof PsiArrayType && PsiClassImplUtil.compareParamTypes(manager, componentType1 = ((PsiArrayType)type1).getComponentType(), componentType2 = ((PsiArrayType)type2).getComponentType(), visited);
        }
        if (!(type1 instanceof PsiClassType) || !(type2 instanceof PsiClassType)) {
            return type1.equals(type2);
        }
        PsiClass class1 = ((PsiClassType)type1).resolve();
        PsiClass class2 = ((PsiClassType)type2).resolve();
        visited.add(type1.getCanonicalText());
        visited.add(type2.getCanonicalText());
        if (class1 instanceof PsiTypeParameter && class2 instanceof PsiTypeParameter) {
            PsiClassType[] eTypes2;
            if (!Objects.equals(class1.getName(), class2.getName()) || ((PsiTypeParameter)class1).getIndex() != ((PsiTypeParameter)class2).getIndex()) {
                return false;
            }
            PsiClassType[] eTypes1 = class1.getExtendsListTypes();
            if (eTypes1.length != (eTypes2 = class2.getExtendsListTypes()).length) {
                return false;
            }
            for (int i = 0; i < eTypes1.length; ++i) {
                PsiClassType eType1 = eTypes1[i];
                PsiClassType eType2 = eTypes2[i];
                if (visited.contains(eType1.getCanonicalText()) || visited.contains(eType2.getCanonicalText())) {
                    return false;
                }
                if (PsiClassImplUtil.compareParamTypes(manager, (PsiType)eType1, (PsiType)eType2, visited)) continue;
                return false;
            }
            return true;
        }
        return manager.areElementsEquivalent((PsiElement)class1, (PsiElement)class2);
    }

    private static /* synthetic */ boolean lambda$processClassMembersWithAllNames$5(PsiScopeProcessor processor2, ResolveState state, Set visited1, PsiElement last, PsiElement place, LanguageLevel languageLevel, boolean isRaw, GlobalSearchScope resolveScope, PsiClass superClass, PsiSubstitutor finalSubstitutor) {
        return PsiClassImplUtil.processDeclarationsInClass(superClass, processor2, state.put(PsiSubstitutor.KEY, (Object)finalSubstitutor), visited1, last, place, languageLevel, isRaw, resolveScope);
    }

    private static class ByNameCachedValueProvider
    implements ParameterizedCachedValueProvider<Map<GlobalSearchScope, MembersMap>, PsiClass> {
        private static final ByNameCachedValueProvider INSTANCE = new ByNameCachedValueProvider();

        private ByNameCachedValueProvider() {
        }

        public CachedValueProvider.Result<Map<GlobalSearchScope, MembersMap>> compute(@NotNull PsiClass myClass) {
            ConcurrentMap map2 = ConcurrentFactoryMap.createMap(scope -> new MembersMap(myClass, (GlobalSearchScope)scope));
            return CachedValueProvider.Result.create((Object)map2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    }

    private static class MembersMap {
        final ConcurrentMap<MemberType, Map<String, PsiMember[]>> myMap;

        MembersMap(@NotNull PsiClass psiClass, @NotNull GlobalSearchScope scope) {
            this.myMap = PsiClassImplUtil.createMembersMap(psiClass, scope);
        }

        private Map<String, PsiMember[]> get(MemberType type2) {
            return (Map)this.myMap.get((Object)type2);
        }
    }

    private static class ClassIconRequest {
        @NotNull
        private final PsiClass psiClass;
        private final int flags;
        private final Icon symbolIcon;

        private ClassIconRequest(@NotNull PsiClass psiClass, int flags, Icon symbolIcon) {
            this.psiClass = psiClass;
            this.flags = flags;
            this.symbolIcon = symbolIcon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassIconRequest)) {
                return false;
            }
            ClassIconRequest that = (ClassIconRequest)o;
            return this.flags == that.flags && this.psiClass.equals(that.psiClass);
        }

        public int hashCode() {
            int result = this.psiClass.hashCode();
            result = 31 * result + this.flags;
            return result;
        }
    }

    public static enum MemberType {
        CLASS,
        FIELD,
        METHOD;

    }
}

