/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.CommentInstruction;
import com.intellij.psi.controlFlow.ConditionalBranchingInstruction;
import com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import com.intellij.psi.controlFlow.EmptyInstruction;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.InstructionClientVisitor;
import com.intellij.psi.controlFlow.ReadVariableInstruction;
import com.intellij.psi.controlFlow.ReturnInstruction;
import com.intellij.psi.controlFlow.SimpleInstruction;
import com.intellij.psi.controlFlow.ThrowToInstruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import org.jetbrains.annotations.NotNull;

class CompositeInstructionClientVisitor
extends InstructionClientVisitor<Object[]> {
    private final InstructionClientVisitor[] myVisitors;

    CompositeInstructionClientVisitor(InstructionClientVisitor[] visitors) {
        this.myVisitors = visitors;
    }

    @Override
    public Object @NotNull [] getResult() {
        Object[] result = new Object[this.myVisitors.length];
        for (int i = 0; i < this.myVisitors.length; ++i) {
            InstructionClientVisitor visitor2 = this.myVisitors[i];
            result[i] = visitor2.getResult();
        }
        return result;
    }

    @Override
    public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor2 : this.myVisitors) {
            visitor2.visitInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitEmptyInstruction(EmptyInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor2 : this.myVisitors) {
            visitor2.visitEmptyInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitCommentInstruction(CommentInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor2 : this.myVisitors) {
            visitor2.visitCommentInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitReadVariableInstruction(ReadVariableInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor2 : this.myVisitors) {
            visitor2.visitReadVariableInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor2 : this.myVisitors) {
            visitor2.visitWriteVariableInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitSimpleInstruction(SimpleInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor2 : this.myVisitors) {
            visitor2.visitSimpleInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitBranchingInstruction(BranchingInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor2 : this.myVisitors) {
            visitor2.visitBranchingInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitConditionalBranchingInstruction(ConditionalBranchingInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor2 : this.myVisitors) {
            visitor2.visitConditionalBranchingInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitConditionalGoToInstruction(ConditionalGoToInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor2 : this.myVisitors) {
            visitor2.visitConditionalGoToInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor2 : this.myVisitors) {
            visitor2.visitConditionalThrowToInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor2 : this.myVisitors) {
            visitor2.visitThrowToInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor2 : this.myVisitors) {
            visitor2.visitGoToInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor2 : this.myVisitors) {
            visitor2.visitCallInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitReturnInstruction(ReturnInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor2 : this.myVisitors) {
            visitor2.visitReturnInstruction(instruction, offset, nextOffset);
        }
    }
}

