/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElementBase;
import com.intellij.packaging.impl.elements.TestModuleOutputElementType;
import com.intellij.packaging.impl.ui.DelegatedPackagingElementPresentation;
import com.intellij.packaging.impl.ui.ModuleElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class TestModuleOutputPackagingElement
extends ModuleOutputPackagingElementBase {
    public TestModuleOutputPackagingElement(Project project) {
        super(TestModuleOutputElementType.ELEMENT_TYPE, project);
    }

    public TestModuleOutputPackagingElement(Project project, ModulePointer modulePointer) {
        super(TestModuleOutputElementType.ELEMENT_TYPE, project, modulePointer);
    }

    public String toString() {
        return "module-tests:" + this.getModuleName();
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getSourceRoots(PackagingElementResolvingContext context) {
        Module module = this.findModule(context);
        if (module == null) {
            return Collections.emptyList();
        }
        return context.getModulesProvider().getRootModel(module).getSourceRoots(JavaModuleSourceRootTypes.TESTS);
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        return new DelegatedPackagingElementPresentation(new ModuleElementPresentation(this.myModulePointer, context, TestModuleOutputElementType.ELEMENT_TYPE));
    }
}

