/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.elements.CompositeElementWithManifest;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.ArchiveElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ArchivePackagingElement
extends CompositeElementWithManifest<ArchivePackagingElement> {
    @NonNls
    public static final String NAME_ATTRIBUTE = "name";
    private String myArchiveFileName;

    public ArchivePackagingElement() {
        super(PackagingElementFactoryImpl.ARCHIVE_ELEMENT_TYPE);
    }

    public ArchivePackagingElement(@NotNull String archiveFileName) {
        super(PackagingElementFactoryImpl.ARCHIVE_ELEMENT_TYPE);
        this.myArchiveFileName = archiveFileName;
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        return new ArchiveElementPresentation(this);
    }

    @Attribute(value="name")
    public String getArchiveFileName() {
        return this.myArchiveFileName;
    }

    @NonNls
    public String toString() {
        return "archive:" + this.myArchiveFileName;
    }

    public ArchivePackagingElement getState() {
        return this;
    }

    public void setArchiveFileName(String archiveFileName) {
        this.myArchiveFileName = archiveFileName;
    }

    public String getName() {
        return this.myArchiveFileName;
    }

    public void rename(@NotNull String newName) {
        this.myArchiveFileName = newName;
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        return element instanceof ArchivePackagingElement && ((ArchivePackagingElement)element).getArchiveFileName().equals(this.myArchiveFileName);
    }

    public void loadState(@NotNull ArchivePackagingElement state) {
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }
}

