/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="ArtifactsWorkspaceSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ArtifactsWorkspaceSettings
implements PersistentStateComponent<ArtifactsWorkspaceSettingsState> {
    private ArtifactsWorkspaceSettingsState myState = new ArtifactsWorkspaceSettingsState();
    private final Project myProject;

    public ArtifactsWorkspaceSettings(Project project) {
        this.myProject = project;
    }

    public static ArtifactsWorkspaceSettings getInstance(@NotNull Project project) {
        return (ArtifactsWorkspaceSettings)ServiceManager.getService((Project)project, ArtifactsWorkspaceSettings.class);
    }

    public List<Artifact> getArtifactsToBuild() {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.myProject);
        for (String name2 : this.myState.myArtifactsToBuild) {
            ContainerUtil.addIfNotNull(result, (Object)artifactManager.findArtifact(name2));
        }
        return result;
    }

    public void setArtifactsToBuild(@NotNull Collection<? extends Artifact> artifacts) {
        this.myState.myArtifactsToBuild.clear();
        for (Artifact artifact : artifacts) {
            this.myState.myArtifactsToBuild.add(artifact.getName());
        }
        Collections.sort(this.myState.myArtifactsToBuild);
    }

    public ArtifactsWorkspaceSettingsState getState() {
        return this.myState;
    }

    public void loadState(@NotNull ArtifactsWorkspaceSettingsState state) {
        this.myState = state;
    }

    public static class ArtifactsWorkspaceSettingsState {
        @XCollection(propertyElementName="artifacts-to-build", elementName="artifact", valueAttributeName="name")
        public List<String> myArtifactsToBuild = new ArrayList<String>();
    }
}

