/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.compiler.impl.CompileScopeUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineRemoteProto;

public class ArtifactBuildTargetScopeProvider
extends BuildTargetScopeProvider {
    @Override
    @NotNull
    public List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> getBuildTargetScopes(@NotNull CompileScope baseScope, @NotNull Project project, boolean forceBuild) {
        ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
        ReadAction.run(() -> {
            Set<Artifact> artifacts = ArtifactCompileScope.getArtifactsToBuild(project, baseScope, false);
            if (ArtifactCompileScope.getArtifacts(baseScope) == null) {
                Set<Module> modules = ArtifactUtil.getModulesIncludedInArtifacts(artifacts, project);
                CompileScopeUtil.addScopesForModules(modules, Collections.emptyList(), scopes, forceBuild);
            }
            if (!artifacts.isEmpty()) {
                boolean forceBuildForArtifacts = forceBuild || ArtifactCompileScope.isArtifactRebuildForced(baseScope);
                scopes.add(CompileScopeUtil.createScopeForArtifacts(artifacts, forceBuildForArtifacts));
            }
        });
        return scopes;
    }
}

