/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.ui.SdkEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkConfigurable
extends ProjectStructureElementConfigurable<Sdk>
implements Place.Navigator {
    private final ProjectJdkImpl myProjectJdk;
    private final SdkEditor mySdkEditor;
    private final SdkProjectStructureElement myProjectStructureElement;

    public JdkConfigurable(@NotNull ProjectJdkImpl projectJdk, @NotNull ProjectSdksModel sdksModel, @NotNull Runnable updateTree, @NotNull History history, @NotNull Project project) {
        super(true, updateTree);
        this.myProjectJdk = projectJdk;
        this.mySdkEditor = this.createSdkEditor(project, sdksModel, history, this.myProjectJdk);
        StructureConfigurableContext context = ModuleStructureConfigurable.getInstance(project).getContext();
        this.myProjectStructureElement = new SdkProjectStructureElement(context, (Sdk)this.myProjectJdk);
    }

    @NotNull
    protected SdkEditor createSdkEditor(@NotNull Project project, @NotNull ProjectSdksModel sdksModel, @NotNull History history, @NotNull ProjectJdkImpl projectJdk) {
        return new SdkEditor(project, (SdkModel)sdksModel, history, projectJdk);
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.myProjectStructureElement;
    }

    public void setDisplayName(String name2) {
        this.myProjectJdk.setName(name2);
    }

    public Sdk getEditableObject() {
        return this.myProjectJdk;
    }

    public String getBannerSlogan() {
        return JavaUiBundle.message("project.roots.jdk.banner.text", this.myProjectJdk.getName());
    }

    public String getDisplayName() {
        return this.myProjectJdk.getName();
    }

    public Icon getIcon(boolean open) {
        return ((SdkType)this.myProjectJdk.getSdkType()).getIcon();
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return ((SdkType)this.myProjectJdk.getSdkType()).getHelpTopic();
    }

    public JComponent createOptionsPanel() {
        return this.mySdkEditor.createComponent();
    }

    public boolean isModified() {
        return this.mySdkEditor.isModified();
    }

    public void apply() throws ConfigurationException {
        this.mySdkEditor.apply();
    }

    public void reset() {
        this.mySdkEditor.reset();
    }

    public void disposeUIResources() {
        this.mySdkEditor.disposeUIResources();
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        return this.mySdkEditor.navigateTo(place, requestFocus);
    }

    public void queryPlace(@NotNull Place place) {
        this.mySdkEditor.queryPlace(place);
    }
}

