/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import org.jetbrains.annotations.NotNull;

public class AddLibraryToModuleDependenciesAction
extends DumbAwareAction {
    @NotNull
    private final Project myProject;
    @NotNull
    private final BaseLibrariesConfigurable myConfigurable;

    public AddLibraryToModuleDependenciesAction(@NotNull Project project, @NotNull BaseLibrariesConfigurable configurable) {
        super(JavaUiBundle.message("action.text.add.to.modules", new Object[0]), JavaUiBundle.message("action.description.add.the.library.to.the.dependencies.list.of.chosen.modules", new Object[0]), null);
        this.myProject = project;
        this.myConfigurable = configurable;
    }

    public void update(@NotNull AnActionEvent e) {
        ProjectStructureElement element = this.myConfigurable.getSelectedElement();
        boolean visible = false;
        if (element instanceof LibraryProjectStructureElement) {
            LibraryEx library = (LibraryEx)((LibraryProjectStructureElement)element).getLibrary();
            visible = !LibraryEditingUtil.getSuitableModules(ModuleStructureConfigurable.getInstance(this.myProject), (LibraryKind)library.getKind(), (Library)library).isEmpty();
        }
        e.getPresentation().setVisible(visible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        LibraryProjectStructureElement element = (LibraryProjectStructureElement)this.myConfigurable.getSelectedElement();
        if (element == null) {
            return;
        }
        Library library = element.getLibrary();
        LibraryEditingUtil.showDialogAndAddLibraryToDependencies(library, this.myProject, false);
    }
}

