/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.roots.ui.configuration.libraryEditor.ItemElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class LibraryRootsTreeSpeedSearch
extends TreeSpeedSearch {
    LibraryRootsTreeSpeedSearch(Tree tree) {
        super((JTree)tree);
    }

    public boolean isMatchingElement(Object element, String pattern) {
        Object userObject = ((DefaultMutableTreeNode)((TreePath)element).getLastPathComponent()).getUserObject();
        if (userObject instanceof ItemElement) {
            String str = this.getElementText(element);
            if (str == null) {
                return false;
            }
            if (!LibraryRootsTreeSpeedSearch.hasCapitals(pattern)) {
                str = StringUtil.toLowerCase((String)str);
            }
            if (pattern.contains(File.separator)) {
                return this.compare(str, pattern);
            }
            StringTokenizer tokenizer = new StringTokenizer(str, File.separator);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!this.compare(token, pattern)) continue;
                return true;
            }
            return false;
        }
        return super.isMatchingElement(element, pattern);
    }

    private static boolean hasCapitals(String str) {
        for (int idx = 0; idx < str.length(); ++idx) {
            if (!Character.isUpperCase(str.charAt(idx))) continue;
            return true;
        }
        return false;
    }
}

