/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.PutIntoDefaultLocationActionBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.ui.PackagingSourceItem;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PutSourceItemIntoDefaultLocationAction
extends PutIntoDefaultLocationActionBase {
    public PutSourceItemIntoDefaultLocationAction(SourceItemsTree sourceItemsTree, ArtifactEditorEx artifactEditor) {
        super(sourceItemsTree, artifactEditor);
    }

    public void update(@NotNull AnActionEvent e) {
        List<PackagingSourceItem> items = this.mySourceItemsTree.getSelectedItems();
        boolean enabled = false;
        Presentation presentation = e.getPresentation();
        if (!items.isEmpty()) {
            enabled = true;
            HashSet<String> paths = new HashSet<String>();
            for (PackagingSourceItem item : items) {
                String path = this.getDefaultPath(item);
                if (path == null) {
                    enabled = false;
                    break;
                }
                paths.add(StringUtil.trimStart((String)StringUtil.trimEnd((String)path, (String)"/"), (String)"/"));
            }
            presentation.setText(JavaUiBundle.message("action.text.put.source.item.into.0", PutSourceItemIntoDefaultLocationAction.getTargetLocationText(paths)));
        }
        presentation.setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.myArtifactEditor.getLayoutTreeComponent().putIntoDefaultLocations(this.mySourceItemsTree.getSelectedItems());
    }
}

