/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.PutIntoDefaultLocationActionBase;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExtractIntoDefaultLocationAction
extends PutIntoDefaultLocationActionBase {
    public ExtractIntoDefaultLocationAction(SourceItemsTree sourceItemsTree, ArtifactEditorEx artifactEditor) {
        super(sourceItemsTree, artifactEditor);
    }

    public void update(@NotNull AnActionEvent e) {
        String pathForClasses = this.myArtifactEditor.getArtifact().getArtifactType().getDefaultPathFor(PackagingElementOutputKind.DIRECTORIES_WITH_CLASSES);
        Presentation presentation = e.getPresentation();
        if (this.onlyJarsSelected() && pathForClasses != null) {
            presentation.setText(JavaUiBundle.message("action.text.extract.source.item.into.0", ExtractIntoDefaultLocationAction.getTargetLocationText(Collections.singleton(pathForClasses))));
            presentation.setVisible(true);
        } else {
            presentation.setVisible(false);
        }
    }

    private boolean onlyJarsSelected() {
        for (PackagingSourceItem item : this.mySourceItemsTree.getSelectedItems()) {
            if (!item.isProvideElements() || item.getKindOfProducedElements().containsJarFiles() && !item.getKindOfProducedElements().containsDirectoriesWithClasses()) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String pathForClasses = this.myArtifactEditor.getArtifact().getArtifactType().getDefaultPathFor(PackagingElementOutputKind.DIRECTORIES_WITH_CLASSES);
        if (pathForClasses != null) {
            final ArrayList extracted = new ArrayList();
            for (PackagingSourceItem item : this.mySourceItemsTree.getSelectedItems()) {
                ArtifactEditorContext context = this.myArtifactEditor.getContext();
                List elements = item.createElements(context);
                ArtifactUtil.processElementsWithSubstitutions(elements, (PackagingElementResolvingContext)context, context.getArtifactType(), PackagingElementPath.EMPTY, new PackagingElementProcessor<PackagingElement<?>>(){

                    @Override
                    public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                        VirtualFile jarRoot;
                        VirtualFile file;
                        if (element instanceof FileCopyPackagingElement && (file = ((FileCopyPackagingElement)element).findFile()) != null && (jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(file)) != null) {
                            extracted.add(PackagingElementFactory.getInstance().createExtractedDirectory(jarRoot));
                        }
                        return true;
                    }
                });
            }
            this.myArtifactEditor.getLayoutTreeComponent().putElements(pathForClasses, extracted);
        }
    }
}

