/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectConfigurable;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildElementsEditor
extends ModuleElementsEditor {
    private JRadioButton myInheritCompilerOutput;
    private JRadioButton myPerModuleCompilerOutput;
    private CommitableFieldPanel myOutputPathPanel;
    private CommitableFieldPanel myTestsOutputPathPanel;
    private JCheckBox myCbExcludeOutput;
    private JLabel myOutputLabel;
    private JLabel myTestOutputLabel;

    protected BuildElementsEditor(ModuleConfigurationState state) {
        super(state);
    }

    public JComponent createComponentImpl() {
        this.myInheritCompilerOutput = new JRadioButton(JavaUiBundle.message("project.inherit.compile.output.path", new Object[0]));
        this.myPerModuleCompilerOutput = new JRadioButton(JavaUiBundle.message("project.module.compile.output.path", new Object[0]));
        ButtonGroup group = new ButtonGroup();
        group.add(this.myInheritCompilerOutput);
        group.add(this.myPerModuleCompilerOutput);
        this.myOutputPathPanel = this.createOutputPathPanel(JavaUiBundle.message("module.paths.output.title", new Object[0]), new CommitPathRunnable(){

            @Override
            public void saveUrl(String url) {
                if (BuildElementsEditor.this.myInheritCompilerOutput.isSelected()) {
                    return;
                }
                BuildElementsEditor.this.getCompilerExtension().setCompilerOutputPath(url);
                BuildElementsEditor.this.fireModuleConfigurationChanged();
            }
        });
        this.myTestsOutputPathPanel = this.createOutputPathPanel(JavaUiBundle.message("module.paths.test.output.title", new Object[0]), new CommitPathRunnable(){

            @Override
            public void saveUrl(String url) {
                if (BuildElementsEditor.this.myInheritCompilerOutput.isSelected()) {
                    return;
                }
                BuildElementsEditor.this.getCompilerExtension().setCompilerOutputPathForTests(url);
                BuildElementsEditor.this.fireModuleConfigurationChanged();
            }
        });
        this.myCbExcludeOutput = new JCheckBox(JavaUiBundle.message("module.paths.exclude.output.checkbox", new Object[0]), this.getCompilerExtension().isExcludeOutput());
        this.myCbExcludeOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuildElementsEditor.this.getCompilerExtension().setExcludeOutput(BuildElementsEditor.this.myCbExcludeOutput.isSelected());
                BuildElementsEditor.this.fireModuleConfigurationChanged();
            }
        });
        JPanel outputPathsPanel = new JPanel(new GridBagLayout());
        outputPathsPanel.add((Component)this.myInheritCompilerOutput, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insets((int)6, (int)0, (int)0, (int)4), 0, 0));
        outputPathsPanel.add((Component)this.myPerModuleCompilerOutput, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insets((int)6, (int)0, (int)0, (int)4), 0, 0));
        this.myOutputLabel = new JLabel(JavaUiBundle.message("module.paths.output.label", new Object[0]));
        outputPathsPanel.add((Component)this.myOutputLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insets((int)6, (int)12, (int)0, (int)4), 0, 0));
        this.myOutputLabel.setLabelFor(this.myOutputPathPanel.getTextField());
        outputPathsPanel.add((Component)((Object)this.myOutputPathPanel), new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)6, (int)4, (int)0, (int)0), 0, 0));
        this.myTestOutputLabel = new JLabel(JavaUiBundle.message("module.paths.test.output.label", new Object[0]));
        outputPathsPanel.add((Component)this.myTestOutputLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insets((int)6, (int)16, (int)0, (int)4), 0, 0));
        this.myTestOutputLabel.setLabelFor(this.myTestsOutputPathPanel.getTextField());
        outputPathsPanel.add((Component)((Object)this.myTestsOutputPathPanel), new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)6, (int)4, (int)0, (int)0), 0, 0));
        outputPathsPanel.add((Component)this.myCbExcludeOutput, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insets((int)6, (int)16, (int)0, (int)0), 0, 0));
        boolean outputPathInherited = this.getCompilerExtension().isCompilerOutputPathInherited();
        this.myInheritCompilerOutput.setSelected(outputPathInherited);
        this.myPerModuleCompilerOutput.setSelected(!outputPathInherited);
        this.updateOutputPathPresentation();
        this.enableCompilerSettings(!outputPathInherited);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuildElementsEditor.this.enableCompilerSettings(!BuildElementsEditor.this.myInheritCompilerOutput.isSelected());
            }
        };
        this.myInheritCompilerOutput.addActionListener(listener);
        this.myPerModuleCompilerOutput.addActionListener(listener);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(IdeBorderFactory.createTitledBorder((String)JavaUiBundle.message("project.roots.output.compiler.title", new Object[0])));
        panel2.add((Component)outputPathsPanel, "North");
        return panel2;
    }

    private void fireModuleConfigurationChanged() {
        this.fireConfigurationChanged();
    }

    private void updateOutputPathPresentation() {
        if (this.getCompilerExtension().isCompilerOutputPathInherited()) {
            ProjectConfigurable projectConfig = ProjectStructureConfigurable.getInstance(this.myProject).getProjectConfig();
            if (projectConfig == null) {
                return;
            }
            String baseUrl = projectConfig.getCompilerOutputUrl();
            this.moduleCompileOutputChanged(baseUrl, this.getModel().getModule().getName());
        } else {
            VirtualFile compilerOutputPath = this.getCompilerExtension().getCompilerOutputPath();
            if (compilerOutputPath != null) {
                this.myOutputPathPanel.setText(FileUtil.toSystemDependentName((String)compilerOutputPath.getPath()));
            } else {
                String compilerOutputUrl = this.getCompilerExtension().getCompilerOutputUrl();
                if (compilerOutputUrl != null) {
                    this.myOutputPathPanel.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)compilerOutputUrl)));
                }
            }
            VirtualFile testsOutputPath = this.getCompilerExtension().getCompilerOutputPathForTests();
            if (testsOutputPath != null) {
                this.myTestsOutputPathPanel.setText(FileUtil.toSystemDependentName((String)testsOutputPath.getPath()));
            } else {
                String testsOutputUrl = this.getCompilerExtension().getCompilerOutputUrlForTests();
                if (testsOutputUrl != null) {
                    this.myTestsOutputPathPanel.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)testsOutputUrl)));
                }
            }
        }
    }

    private void enableCompilerSettings(boolean enabled) {
        UIUtil.setEnabled((Component)((Object)this.myOutputPathPanel), (boolean)enabled, (boolean)true);
        UIUtil.setEnabled((Component)this.myOutputLabel, (boolean)enabled, (boolean)true);
        UIUtil.setEnabled((Component)((Object)this.myTestsOutputPathPanel), (boolean)enabled, (boolean)true);
        UIUtil.setEnabled((Component)this.myTestOutputLabel, (boolean)enabled, (boolean)true);
        this.myCbExcludeOutput.setEnabled(enabled);
        this.getCompilerExtension().inheritCompilerOutputPath(!enabled);
        this.updateOutputPathPresentation();
        this.fireModuleConfigurationChanged();
    }

    private CommitableFieldPanel createOutputPathPanel(String title, CommitPathRunnable commitPathRunnable) {
        ExtendableTextField textField = new ExtendableTextField();
        FileChooserDescriptor outputPathsChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        outputPathsChooserDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)this.getModel().getModule());
        outputPathsChooserDescriptor.setHideIgnored(false);
        InsertPathAction.addTo((JTextComponent)textField, (FileChooserDescriptor)outputPathsChooserDescriptor);
        FileChooserFactory.getInstance().installFileCompletion((JTextField)textField, outputPathsChooserDescriptor, true, null);
        final Runnable commitRunnable = () -> this.lambda$createOutputPathPanel$0((JTextField)textField, commitPathRunnable);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                commitRunnable.run();
            }
        };
        this.myPerModuleCompilerOutput.addActionListener(listener);
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                commitRunnable.run();
            }
        });
        return new CommitableFieldPanel((JTextField)textField, null, null, (ActionListener)new BrowseFilesListener((JTextField)textField, title, "", outputPathsChooserDescriptor){

            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                commitRunnable.run();
            }
        }, null, commitRunnable);
    }

    public void saveData() {
        this.myOutputPathPanel.commit();
        this.myTestsOutputPathPanel.commit();
    }

    public String getDisplayName() {
        return JavaUiBundle.message("output.tab.title", new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "project.structureModulesPage.outputJavadoc";
    }

    public void moduleStateChanged() {
        this.myCbExcludeOutput.setSelected(this.getCompilerExtension().isExcludeOutput());
    }

    public void moduleCompileOutputChanged(String baseUrl, String moduleName) {
        if (this.getCompilerExtension().isCompilerOutputPathInherited()) {
            if (baseUrl != null) {
                this.myOutputPathPanel.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)(baseUrl + "/" + "production" + "/" + moduleName))));
                this.myTestsOutputPathPanel.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)(baseUrl + "/" + "test" + "/" + moduleName))));
            } else {
                this.myOutputPathPanel.setText(null);
                this.myTestsOutputPathPanel.setText(null);
            }
        }
    }

    public CompilerModuleExtension getCompilerExtension() {
        return (CompilerModuleExtension)this.getModel().getModuleExtension(CompilerModuleExtension.class);
    }

    private /* synthetic */ void lambda$createOutputPathPanel$0(JTextField textField, CommitPathRunnable commitPathRunnable) {
        if (!this.getModel().isWritable()) {
            return;
        }
        String path = textField.getText().trim();
        if (path.length() == 0) {
            commitPathRunnable.saveUrl(null);
        } else {
            String canonicalPath;
            try {
                canonicalPath = FileUtil.resolveShortWindowsName((String)path);
            }
            catch (IOException e) {
                canonicalPath = path;
            }
            commitPathRunnable.saveUrl(VfsUtilCore.pathToUrl((String)canonicalPath));
        }
    }

    private static class CommitableFieldPanel
    extends FieldPanel {
        private final Runnable myCommitRunnable;

        CommitableFieldPanel(JTextField textField, String labelText, String viewerDialogTitle, ActionListener browseButtonActionListener, Runnable documentListener, Runnable commitPathRunnable) {
            super(textField, labelText, viewerDialogTitle, browseButtonActionListener, documentListener);
            this.myCommitRunnable = commitPathRunnable;
        }

        public void commit() {
            this.myCommitRunnable.run();
        }
    }

    private static interface CommitPathRunnable {
        public void saveUrl(String var1);
    }
}

