/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.SdkAppearanceService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.roots.ui.util.SimpleTextCellAppearance;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import java.awt.Color;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrderEntryAppearanceServiceImpl
extends OrderEntryAppearanceService {
    @NotNull
    public CellAppearanceEx forOrderEntry(Project project, @NotNull OrderEntry orderEntry, boolean selected) {
        if (orderEntry instanceof JdkOrderEntry) {
            JdkOrderEntry jdkLibraryEntry = (JdkOrderEntry)orderEntry;
            Sdk jdk = jdkLibraryEntry.getJdk();
            if (!orderEntry.isValid()) {
                String oldJdkName = jdkLibraryEntry.getJdkName();
                return FileAppearanceService.getInstance().forInvalidUrl(oldJdkName != null ? oldJdkName : JavaUiBundle.message("jdk.missing.item", new Object[0]));
            }
            return this.forJdk(jdk, false, selected, true);
        }
        if (!orderEntry.isValid()) {
            return FileAppearanceService.getInstance().forInvalidUrl(orderEntry.getPresentableName());
        }
        if (orderEntry instanceof LibraryOrderEntry) {
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
            if (!libraryOrderEntry.isValid()) {
                return FileAppearanceService.getInstance().forInvalidUrl(orderEntry.getPresentableName());
            }
            Library library = libraryOrderEntry.getLibrary();
            assert (library != null) : libraryOrderEntry;
            return this.forLibrary(project, library, !((LibraryEx)library).getInvalidRootUrls(OrderRootType.CLASSES).isEmpty());
        }
        if (orderEntry.isSynthetic()) {
            String presentableName = orderEntry.getPresentableName();
            Icon icon = orderEntry instanceof ModuleSourceOrderEntry ? OrderEntryAppearanceServiceImpl.sourceFolderIcon(false) : null;
            return new SimpleTextCellAppearance(presentableName, icon, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
        }
        if (orderEntry instanceof ModuleOrderEntry) {
            Icon icon = ModuleType.get((Module)((ModuleOrderEntry)orderEntry).getModule()).getIcon();
            return SimpleTextCellAppearance.regular((String)orderEntry.getPresentableName(), (Icon)icon);
        }
        return CompositeAppearance.single((String)orderEntry.getPresentableName());
    }

    @NotNull
    public CellAppearanceEx forLibrary(Project project, @NotNull Library library, boolean hasInvalidRoots) {
        StructureConfigurableContext context = ProjectStructureConfigurable.getInstance(project).getContext();
        Icon icon = LibraryPresentationManager.getInstance().getCustomIcon(library, context);
        String name2 = library.getName();
        if (name2 != null) {
            return OrderEntryAppearanceServiceImpl.normalOrRedWaved(name2, icon != null ? icon : PlatformIcons.LIBRARY_ICON, hasInvalidRoots);
        }
        String[] files = library.getUrls(OrderRootType.CLASSES);
        if (files.length == 0) {
            return SimpleTextCellAppearance.invalid((String)ProjectModelBundle.message((String)"library.empty.library.item", (Object[])new Object[0]), (Icon)PlatformIcons.LIBRARY_ICON);
        }
        if (files.length == 1) {
            return OrderEntryAppearanceServiceImpl.forVirtualFilePointer(new LightFilePointer(files[0]));
        }
        String url = StringUtil.trimEnd((String)files[0], (String)"!/");
        String text2 = JavaUiBundle.message("library.unnamed.text", PathUtil.getFileName((String)url), files.length - 1);
        return SimpleTextCellAppearance.regular((String)text2, (Icon)PlatformIcons.LIBRARY_ICON);
    }

    @NotNull
    public CellAppearanceEx forJdk(@Nullable Sdk jdk, boolean isInComboBox, boolean selected, boolean showVersion) {
        return SdkAppearanceService.getInstance().forSdk(jdk, isInComboBox, selected, showVersion);
    }

    @NotNull
    public CellAppearanceEx forContentFolder(@NotNull ContentFolder folder) {
        if (folder instanceof SourceFolder) {
            return OrderEntryAppearanceServiceImpl.formatRelativePath(folder, PlatformIcons.FOLDER_ICON);
        }
        if (folder instanceof ExcludeFolder) {
            return OrderEntryAppearanceServiceImpl.formatRelativePath(folder, IconLoader.getDisabledIcon((Icon)PlatformIcons.FOLDER_ICON));
        }
        throw new RuntimeException(folder.getClass().getName());
    }

    @NotNull
    public CellAppearanceEx forModule(@NotNull Module module) {
        return SimpleTextCellAppearance.regular((String)module.getName(), (Icon)ModuleType.get((Module)module).getIcon());
    }

    @NotNull
    private static Icon sourceFolderIcon(boolean testSource) {
        return testSource ? PlatformIcons.TEST_SOURCE_FOLDER : PlatformIcons.SOURCE_FOLDERS_ICON;
    }

    @NotNull
    private static CellAppearanceEx normalOrRedWaved(@NotNull String text2, @Nullable Icon icon, boolean waved) {
        return waved ? new SimpleTextCellAppearance(text2, icon, new SimpleTextAttributes(8, null, (Color)JBColor.RED)) : SimpleTextCellAppearance.regular((String)text2, (Icon)icon);
    }

    @NotNull
    private static CellAppearanceEx forVirtualFilePointer(@NotNull LightFilePointer filePointer) {
        VirtualFile file = filePointer.getFile();
        return file != null ? FileAppearanceService.getInstance().forVirtualFile(file) : FileAppearanceService.getInstance().forInvalidUrl(filePointer.getPresentableUrl());
    }

    @NotNull
    private static CellAppearanceEx formatRelativePath(@NotNull ContentFolder folder, @NotNull Icon icon) {
        SimpleTextAttributes textAttributes;
        String relativePath;
        LightFilePointer folderFile = new LightFilePointer(folder.getUrl());
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(folder.getContentEntry().getUrl());
        if (file == null) {
            return FileAppearanceService.getInstance().forInvalidUrl(folderFile.getPresentableUrl());
        }
        String contentPath = file.getPath();
        VirtualFile folderFileFile = folderFile.getFile();
        if (folderFileFile == null) {
            String absolutePath = folderFile.getPresentableUrl();
            relativePath = absolutePath.startsWith(contentPath) ? absolutePath.substring(contentPath.length()) : absolutePath;
            textAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
        } else {
            relativePath = VfsUtilCore.getRelativePath((VirtualFile)folderFileFile, (VirtualFile)file, (char)File.separatorChar);
            textAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
        relativePath = StringUtil.isEmpty((String)relativePath) ? "." + File.separatorChar : relativePath;
        return new SimpleTextCellAppearance(relativePath, icon, textAttributes);
    }
}

