/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.codeInsight.daemon.impl.quickfix.LocateLibraryDialog;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.ide.JavaUiBundle;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryAttachDialog;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public class IdeaProjectModelModifier
extends JavaProjectModelModifier {
    private static final Logger LOG = Logger.getInstance(IdeaProjectModelModifier.class);
    private final Project myProject;

    public IdeaProjectModelModifier(Project project) {
        this.myProject = project;
    }

    @Override
    public Promise<Void> addModuleDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope, boolean exported) {
        ModuleRootModificationUtil.addDependency((Module)from, (Module)to, (DependencyScope)scope, (boolean)exported);
        return Promises.resolvedPromise(null);
    }

    @Override
    public Promise<Void> addLibraryDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope, boolean exported) {
        WriteAction.run(() -> OrderEntryUtil.addLibraryToRoots((Module)from, (Library)library, (DependencyScope)scope, (boolean)exported));
        return Promises.resolvedPromise(null);
    }

    @Override
    public Promise<Void> addExternalLibraryDependency(@NotNull Collection<? extends Module> modules, @NotNull ExternalLibraryDescriptor descriptor, @NotNull DependencyScope scope) {
        List<String> classesRoots;
        List<String> defaultRoots = descriptor.getLibraryClassesRoots();
        Module firstModule = (Module)ContainerUtil.getFirstItem(modules);
        if (!defaultRoots.isEmpty()) {
            LOG.assertTrue(firstModule != null);
            classesRoots = new LocateLibraryDialog(firstModule, defaultRoots, descriptor.getPresentableName()).showAndGetResult();
        } else {
            String version = descriptor.getPreferredVersion();
            String mavenCoordinates = descriptor.getLibraryGroupId() + ":" + descriptor.getLibraryArtifactId() + ":" + (version != null ? version : "RELEASE");
            RepositoryAttachDialog dialog = new RepositoryAttachDialog(this.myProject, mavenCoordinates, RepositoryAttachDialog.Mode.DOWNLOAD);
            if (!dialog.showAndGet()) {
                return Promises.rejectedPromise();
            }
            RepositoryLibraryProperties libraryProperties = new RepositoryLibraryProperties(dialog.getSelectedLibraryDescriptor());
            Collection<OrderRoot> roots = JarRepositoryManager.loadDependenciesModal(this.myProject, libraryProperties, dialog.getAttachSources(), dialog.getAttachJavaDoc(), dialog.getDirectoryPath(), null);
            if (roots.isEmpty()) {
                Messages.showErrorDialog((Project)this.myProject, (String)JavaUiBundle.message("dialog.mesage.0.was.not.loaded", descriptor.getPresentableName()), (String)JavaUiBundle.message("dialog.title.failed.to.download.library", new Object[0]));
                return Promises.rejectedPromise();
            }
            classesRoots = roots.stream().filter(root -> root.getType() == OrderRootType.CLASSES).map(root -> PathUtil.getLocalPath((VirtualFile)root.getFile())).collect(Collectors.toList());
        }
        if (!classesRoots.isEmpty()) {
            String libraryName = classesRoots.size() > 1 ? descriptor.getPresentableName() : null;
            List<String> urls = OrderEntryFix.refreshAndConvertToUrls(classesRoots);
            if (modules.size() == 1) {
                ModuleRootModificationUtil.addModuleLibrary((Module)firstModule, (String)libraryName, urls, Collections.emptyList(), (DependencyScope)scope);
            } else {
                WriteAction.run(() -> {
                    Library library = LibraryUtil.createLibrary((LibraryTable)LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject), (String)descriptor.getPresentableName());
                    Library.ModifiableModel model = library.getModifiableModel();
                    for (String url : urls) {
                        model.addRoot(url, OrderRootType.CLASSES);
                    }
                    model.commit();
                    for (Module module : modules) {
                        ModuleRootModificationUtil.addDependency((Module)module, (Library)library, (DependencyScope)scope, (boolean)false);
                    }
                });
            }
        }
        return Promises.resolvedPromise(null);
    }

    @Override
    public Promise<Void> changeLanguageLevel(@NotNull Module module, @NotNull LanguageLevel level) {
        LanguageLevel moduleLevel = LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
        if (moduleLevel != null && JavaSdkUtil.isLanguageLevelAcceptable(this.myProject, module, level)) {
            ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            ((LanguageLevelModuleExtension)rootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(level);
            rootModel.commit();
        } else {
            LanguageLevelProjectExtension.getInstance((Project)this.myProject).setLanguageLevel(level);
            ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.INSTANCE, false, true);
        }
        return Promises.resolvedPromise(null);
    }
}

