/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lang.java.parser.ReferenceParser;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class DeclarationParser {
    private static final TokenSet AFTER_END_DECLARATION_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.FIELD, JavaElementType.METHOD});
    private static final TokenSet BEFORE_LBRACE_ELEMENTS_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.IDENTIFIER, JavaTokenType.COMMA, JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.IMPLEMENTS_KEYWORD, JavaTokenType.LPARENTH});
    private static final TokenSet APPEND_TO_METHOD_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.IDENTIFIER, JavaTokenType.COMMA, JavaTokenType.THROWS_KEYWORD});
    private static final TokenSet PARAM_LIST_STOPPERS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.RPARENTH, JavaTokenType.LBRACE, JavaTokenType.ARROW});
    private static final TokenSet TYPE_START = TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.PRIMITIVE_TYPE_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.IDENTIFIER, JavaTokenType.AT, JavaTokenType.VAR_KEYWORD})});
    private static final TokenSet RESOURCE_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.REFERENCE_EXPRESSION, JavaElementType.THIS_EXPRESSION, JavaElementType.METHOD_CALL_EXPRESSION, JavaElementType.NEW_EXPRESSION});
    private static final String WHITESPACES = "\n\r \t";
    private static final String LINE_ENDS = "\n\r";
    private final JavaParser myParser;

    public DeclarationParser(@NotNull JavaParser javaParser) {
        this.myParser = javaParser;
    }

    public void parseClassBodyWithBraces(PsiBuilder builder, boolean isAnnotation, boolean isEnum) {
        assert (builder.getTokenType() == JavaTokenType.LBRACE) : builder.getTokenType();
        builder.advanceLexer();
        PsiBuilder builderWrapper = JavaParserUtil.braceMatchingBuilder(builder);
        if (isEnum) {
            this.parseEnumConstants(builderWrapper);
        }
        this.parseClassBodyDeclarations(builderWrapper, isAnnotation);
        JavaParserUtil.expectOrError(builder, JavaTokenType.RBRACE, "expected.rbrace");
    }

    @Nullable
    private PsiBuilder.Marker parseClassFromKeyword(PsiBuilder builder, PsiBuilder.Marker declaration2, boolean isAnnotation, Context context) {
        boolean isEnum;
        IElementType keywordTokenType = builder.getTokenType();
        boolean isRecord = DeclarationParser.isRecordToken(builder, keywordTokenType);
        if (isRecord) {
            if (builder.lookAhead(1) != JavaTokenType.IDENTIFIER) {
                declaration2.drop();
                return null;
            }
            IElementType afterIdent = builder.lookAhead(2);
            if (context == Context.CODE_BLOCK && afterIdent != JavaTokenType.LPARENTH && afterIdent != JavaTokenType.LT) {
                builder.advanceLexer();
                builder.advanceLexer();
                JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.lt.or.lparen", (Object[])new Object[0]));
                declaration2.drop();
                return null;
            }
            builder.remapCurrentToken(JavaTokenType.RECORD_KEYWORD);
            keywordTokenType = JavaTokenType.RECORD_KEYWORD;
        }
        assert (ElementType.CLASS_KEYWORD_BIT_SET.contains(keywordTokenType)) : keywordTokenType;
        builder.advanceLexer();
        boolean bl = isEnum = keywordTokenType == JavaTokenType.ENUM_KEYWORD;
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.identifier", (Object[])new Object[0]));
            declaration2.drop();
            return null;
        }
        ReferenceParser refParser = this.myParser.getReferenceParser();
        refParser.parseTypeParameters(builder);
        if (builder.getTokenType() == JavaTokenType.LPARENTH) {
            this.parseElementList(builder, ListType.RECORD_COMPONENTS);
        }
        refParser.parseReferenceList(builder, JavaTokenType.EXTENDS_KEYWORD, JavaElementType.EXTENDS_LIST, JavaTokenType.COMMA);
        refParser.parseReferenceList(builder, JavaTokenType.IMPLEMENTS_KEYWORD, JavaElementType.IMPLEMENTS_LIST, JavaTokenType.COMMA);
        if (JavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_15_PREVIEW)) {
            if (builder.getTokenType() == JavaTokenType.IDENTIFIER && "permits".equals(builder.getTokenText())) {
                builder.remapCurrentToken(JavaTokenType.PERMITS_KEYWORD);
            }
            refParser.parseReferenceList(builder, JavaTokenType.PERMITS_KEYWORD, JavaElementType.PERMITS_LIST, JavaTokenType.COMMA);
        }
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            PsiBuilder.Marker error = builder.mark();
            while (BEFORE_LBRACE_ELEMENTS_SET.contains(builder.getTokenType())) {
                builder.advanceLexer();
            }
            error.error(JavaPsiBundle.message((String)"expected.lbrace", (Object[])new Object[0]));
        }
        if (builder.getTokenType() == JavaTokenType.LBRACE) {
            this.parseClassBodyWithBraces(builder, isAnnotation, isEnum);
        }
        if (context == Context.FILE) {
            boolean declarationsAfterEnd = false;
            while (builder.getTokenType() != null && builder.getTokenType() != JavaTokenType.RBRACE) {
                PsiBuilder.Marker position = builder.mark();
                PsiBuilder.Marker extra = this.parse(builder, Context.CLASS);
                if (extra != null && AFTER_END_DECLARATION_SET.contains(JavaParserUtil.exprType(extra))) {
                    if (!declarationsAfterEnd) {
                        JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.class.or.interface", (Object[])new Object[0]), extra);
                    }
                    declarationsAfterEnd = true;
                    position.drop();
                    continue;
                }
                position.rollbackTo();
                break;
            }
            if (declarationsAfterEnd) {
                JavaParserUtil.expectOrError(builder, JavaTokenType.RBRACE, "expected.rbrace");
            }
        }
        JavaParserUtil.done(declaration2, JavaElementType.CLASS);
        return declaration2;
    }

    private void parseEnumConstants(PsiBuilder builder) {
        boolean first = true;
        while (builder.getTokenType() != null) {
            IElementType next;
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.SEMICOLON)) {
                return;
            }
            if (builder.getTokenType() == JavaTokenType.PRIVATE_KEYWORD || builder.getTokenType() == JavaTokenType.PROTECTED_KEYWORD) {
                JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.semicolon", (Object[])new Object[0]));
                return;
            }
            PsiBuilder.Marker enumConstant = this.parseEnumConstant(builder);
            if (enumConstant == null && builder.getTokenType() == JavaTokenType.COMMA && first && (next = builder.lookAhead(1)) != JavaTokenType.SEMICOLON && next != JavaTokenType.RBRACE) {
                JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.identifier", (Object[])new Object[0]));
            }
            first = false;
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.COMMA) || builder.getTokenType() == null || builder.getTokenType() == JavaTokenType.SEMICOLON) continue;
            JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.comma.or.semicolon", (Object[])new Object[0]));
            return;
        }
    }

    @Nullable
    public PsiBuilder.Marker parseEnumConstant(PsiBuilder builder) {
        PsiBuilder.Marker constant = builder.mark();
        this.parseModifierList(builder);
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            if (builder.getTokenType() == JavaTokenType.LPARENTH) {
                this.myParser.getExpressionParser().parseArgumentList(builder);
            } else {
                JavaParserUtil.emptyElement(builder, JavaElementType.EXPRESSION_LIST);
            }
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                PsiBuilder.Marker constantInit = builder.mark();
                this.parseClassBodyWithBraces(builder, false, false);
                JavaParserUtil.done(constantInit, JavaElementType.ENUM_CONSTANT_INITIALIZER);
            }
            JavaParserUtil.done(constant, JavaElementType.ENUM_CONSTANT);
            return constant;
        }
        constant.rollbackTo();
        return null;
    }

    public void parseClassBodyDeclarations(PsiBuilder builder, boolean isAnnotation) {
        IElementType tokenType;
        Context context = isAnnotation ? Context.ANNOTATION_INTERFACE : Context.CLASS;
        PsiBuilder.Marker invalidElements = null;
        while ((tokenType = builder.getTokenType()) != null && tokenType != JavaTokenType.RBRACE) {
            PsiBuilder.Marker ref;
            if (tokenType == JavaTokenType.SEMICOLON) {
                if (invalidElements != null) {
                    invalidElements.error(JavaPsiBundle.message((String)"unexpected.token", (Object[])new Object[0]));
                    invalidElements = null;
                }
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker declaration2 = this.parse(builder, context);
            if (declaration2 != null) {
                if (invalidElements == null) continue;
                invalidElements.errorBefore(JavaPsiBundle.message((String)"unexpected.token", (Object[])new Object[0]), declaration2);
                invalidElements = null;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, true, false, false)) != null) continue;
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(JavaPsiBundle.message((String)"unexpected.token", (Object[])new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parse(PsiBuilder builder, Context context) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == null) {
            return null;
        }
        if (tokenType == JavaTokenType.LBRACE) {
            if (context == Context.FILE || context == Context.CODE_BLOCK) {
                return null;
            }
        } else if (!(DeclarationParser.isRecordToken(builder, tokenType) || DeclarationParser.isSealedToken(builder, tokenType) || DeclarationParser.isNonSealedToken(builder, tokenType))) {
            if (TYPE_START.contains(tokenType) && tokenType != JavaTokenType.AT) {
                if (context == Context.FILE) {
                    return null;
                }
            } else {
                if (tokenType instanceof ILazyParseableElementType) {
                    builder.advanceLexer();
                    return null;
                }
                if (!(ElementType.MODIFIER_BIT_SET.contains(tokenType) || ElementType.CLASS_KEYWORD_BIT_SET.contains(tokenType) || tokenType == JavaTokenType.AT || context != Context.CODE_BLOCK && tokenType == JavaTokenType.LT)) {
                    return null;
                }
            }
        }
        PsiBuilder.Marker declaration2 = builder.mark();
        int declarationStart = builder.getCurrentOffset();
        Pair<PsiBuilder.Marker, Boolean> modListInfo = this.parseModifierList(builder);
        PsiBuilder.Marker modList = (PsiBuilder.Marker)modListInfo.first;
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.AT)) {
            if (builder.getTokenType() == JavaTokenType.INTERFACE_KEYWORD) {
                PsiBuilder.Marker result = this.parseClassFromKeyword(builder, declaration2, true, context);
                return result != null ? result : modList;
            }
            declaration2.rollbackTo();
            return null;
        }
        if (ElementType.CLASS_KEYWORD_BIT_SET.contains(builder.getTokenType()) || DeclarationParser.isRecordToken(builder, builder.getTokenType())) {
            PsiBuilder.Marker result = this.parseClassFromKeyword(builder, declaration2, false, context);
            return result != null ? result : modList;
        }
        PsiBuilder.Marker typeParams = null;
        if (builder.getTokenType() == JavaTokenType.LT && context != Context.CODE_BLOCK) {
            typeParams = this.myParser.getReferenceParser().parseTypeParameters(builder);
        }
        if (context == Context.FILE) {
            JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.class.or.interface", (Object[])new Object[0]), typeParams);
            declaration2.drop();
            return modList;
        }
        if (builder.getTokenType() == JavaTokenType.LBRACE) {
            if (context == Context.CODE_BLOCK) {
                JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.identifier.or.type", (Object[])new Object[0]), null);
                declaration2.drop();
                return modList;
            }
            PsiBuilder.Marker codeBlock = this.myParser.getStatementParser().parseCodeBlock(builder);
            assert (codeBlock != null) : builder.getOriginalText();
            if (typeParams != null) {
                PsiBuilder.Marker error = typeParams.precede();
                error.errorBefore(JavaPsiBundle.message((String)"unexpected.token", (Object[])new Object[0]), codeBlock);
            }
            JavaParserUtil.done(declaration2, JavaElementType.CLASS_INITIALIZER);
            return declaration2;
        }
        ReferenceParser.TypeInfo type2 = null;
        if (TYPE_START.contains(builder.getTokenType())) {
            PsiBuilder.Marker pos = builder.mark();
            int flags = 5;
            if (context == Context.CODE_BLOCK) {
                flags |= 0x80;
            }
            if ((type2 = this.myParser.getReferenceParser().parseTypeInfo(builder, flags)) == null) {
                pos.rollbackTo();
            } else {
                if (builder.getTokenType() == JavaTokenType.LPARENTH || builder.getTokenType() == JavaTokenType.LBRACE) {
                    if (context == Context.CODE_BLOCK) {
                        declaration2.rollbackTo();
                        return null;
                    }
                    pos.rollbackTo();
                    if (typeParams == null) {
                        JavaParserUtil.emptyElement(builder, JavaElementType.TYPE_PARAMETER_LIST);
                    }
                    this.parseAnnotations(builder);
                    if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
                        PsiBuilder.Marker primitive = builder.mark();
                        builder.advanceLexer();
                        primitive.error(JavaPsiBundle.message((String)"expected.identifier", (Object[])new Object[0]));
                    }
                    if (builder.getTokenType() == JavaTokenType.LPARENTH) {
                        return this.parseMethodFromLeftParenth(builder, declaration2, false, true);
                    }
                    if (builder.getTokenType() == JavaTokenType.LBRACE) {
                        JavaParserUtil.emptyElement(builder, JavaElementType.THROWS_LIST);
                        return this.parseMethodBody(builder, declaration2, false);
                    }
                    declaration2.rollbackTo();
                    return null;
                }
                pos.drop();
            }
        }
        if (type2 == null) {
            PsiBuilder.Marker error = typeParams != null ? typeParams.precede() : builder.mark();
            error.error(JavaPsiBundle.message((String)"expected.identifier.or.type", (Object[])new Object[0]));
            declaration2.drop();
            return modList;
        }
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            if (context != Context.CODE_BLOCK || Boolean.FALSE.equals(modListInfo.second) || type2.isPrimitive && builder.getTokenType() != JavaTokenType.DOT) {
                if (typeParams != null) {
                    typeParams.precede().errorBefore(JavaPsiBundle.message((String)"unexpected.token", (Object[])new Object[0]), type2.marker);
                }
                builder.error(JavaPsiBundle.message((String)"expected.identifier", (Object[])new Object[0]));
                declaration2.drop();
                return modList;
            }
            declaration2.rollbackTo();
            return null;
        }
        if (builder.getTokenType() == JavaTokenType.LPARENTH && (context == Context.CLASS || context == Context.ANNOTATION_INTERFACE)) {
            if (typeParams == null) {
                JavaParserUtil.emptyElement(type2.marker, JavaElementType.TYPE_PARAMETER_LIST);
            }
            return this.parseMethodFromLeftParenth(builder, declaration2, context == Context.ANNOTATION_INTERFACE, false);
        }
        if (typeParams != null) {
            typeParams.precede().errorBefore(JavaPsiBundle.message((String)"unexpected.token", (Object[])new Object[0]), type2.marker);
        }
        return this.parseFieldOrLocalVariable(builder, declaration2, declarationStart, context);
    }

    static boolean isRecordToken(PsiBuilder builder, IElementType tokenType) {
        if (tokenType == JavaTokenType.IDENTIFIER && "record".equals(builder.getTokenText()) && builder.lookAhead(1) == JavaTokenType.IDENTIFIER) {
            LanguageLevel level = JavaParserUtil.getLanguageLevel(builder);
            return level.isAtLeast(LanguageLevel.JDK_14_PREVIEW) && (level == LanguageLevel.JDK_X || level.isPreview());
        }
        return false;
    }

    private static boolean isSealedToken(PsiBuilder builder, IElementType tokenType) {
        return JavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_15_PREVIEW) && tokenType == JavaTokenType.IDENTIFIER && "sealed".equals(builder.getTokenText());
    }

    private static boolean isNonSealedToken(PsiBuilder builder, IElementType tokenType) {
        if (!JavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_15_PREVIEW) || tokenType != JavaTokenType.IDENTIFIER || !"non".equals(builder.getTokenText()) || builder.lookAhead(1) != JavaTokenType.MINUS || builder.lookAhead(2) != JavaTokenType.IDENTIFIER) {
            return false;
        }
        PsiBuilder.Marker maybeNonSealed = builder.mark();
        builder.advanceLexer();
        builder.advanceLexer();
        boolean isNonSealed = "sealed".equals(builder.getTokenText());
        maybeNonSealed.rollbackTo();
        return isNonSealed;
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseModifierList(PsiBuilder builder) {
        return this.parseModifierList(builder, ElementType.MODIFIER_BIT_SET);
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseModifierList(PsiBuilder builder, TokenSet modifiers) {
        IElementType tokenType;
        PsiBuilder.Marker modList = builder.mark();
        boolean isEmpty = true;
        while ((tokenType = builder.getTokenType()) != null) {
            if (DeclarationParser.isSealedToken(builder, tokenType)) {
                builder.remapCurrentToken(JavaTokenType.SEALED_KEYWORD);
                tokenType = JavaTokenType.SEALED_KEYWORD;
            }
            if (DeclarationParser.isNonSealedToken(builder, tokenType)) {
                PsiBuilder.Marker nonSealed = builder.mark();
                builder.advanceLexer();
                builder.advanceLexer();
                builder.advanceLexer();
                nonSealed.collapse(JavaTokenType.NON_SEALED_KEYWORD);
                isEmpty = false;
                continue;
            }
            if (modifiers.contains(tokenType)) {
                builder.advanceLexer();
                isEmpty = false;
                continue;
            }
            if (tokenType != JavaTokenType.AT || ElementType.KEYWORD_BIT_SET.contains(builder.lookAhead(1))) break;
            this.parseAnnotation(builder);
            isEmpty = false;
        }
        JavaParserUtil.done(modList, JavaElementType.MODIFIER_LIST);
        return Pair.create((Object)modList, (Object)isEmpty);
    }

    private PsiBuilder.Marker parseMethodFromLeftParenth(PsiBuilder builder, PsiBuilder.Marker declaration2, boolean anno, boolean constructor) {
        this.parseParameterList(builder);
        this.eatBrackets(builder, constructor ? "expected.semicolon" : null);
        this.myParser.getReferenceParser().parseReferenceList(builder, JavaTokenType.THROWS_KEYWORD, JavaElementType.THROWS_LIST, JavaTokenType.COMMA);
        if (anno && PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.DEFAULT_KEYWORD)) {
            this.parseAnnotationValue(builder);
        }
        return this.parseMethodBody(builder, declaration2, anno);
    }

    @NotNull
    private PsiBuilder.Marker parseMethodBody(PsiBuilder builder, PsiBuilder.Marker declaration2, boolean anno) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType != JavaTokenType.SEMICOLON && tokenType != JavaTokenType.LBRACE) {
            PsiBuilder.Marker error = builder.mark();
            CharSequence text2 = builder.getOriginalText();
            block0: do {
                for (int i = builder.getCurrentOffset() - 1; i >= 0; --i) {
                    char ch = text2.charAt(i);
                    if (ch == '\n') break block0;
                    if (ch != ' ' && ch != '\t') continue block0;
                }
            } while (PsiBuilderUtil.expect((PsiBuilder)builder, (TokenSet)APPEND_TO_METHOD_SET));
            error.error(JavaPsiBundle.message((String)"expected.lbrace.or.semicolon", (Object[])new Object[0]));
        }
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.SEMICOLON) && builder.getTokenType() == JavaTokenType.LBRACE) {
            this.myParser.getStatementParser().parseCodeBlock(builder);
        }
        JavaParserUtil.done(declaration2, anno ? JavaElementType.ANNOTATION_METHOD : JavaElementType.METHOD);
        return declaration2;
    }

    public void parseParameterList(PsiBuilder builder) {
        this.parseElementList(builder, ListType.METHOD);
    }

    public void parseResourceList(PsiBuilder builder) {
        this.parseElementList(builder, ListType.RESOURCE);
    }

    public void parseLambdaParameterList(PsiBuilder builder, boolean typed) {
        this.parseElementList(builder, typed ? ListType.LAMBDA_TYPED : ListType.LAMBDA_UNTYPED);
    }

    private void parseElementList(PsiBuilder builder, ListType type2) {
        boolean lambda2 = type2 == ListType.LAMBDA_TYPED || type2 == ListType.LAMBDA_UNTYPED;
        boolean resources = type2 == ListType.RESOURCE;
        PsiBuilder.Marker elementList = builder.mark();
        boolean leftParenth = PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LPARENTH);
        assert (lambda2 || leftParenth) : builder.getTokenType();
        IElementType delimiter = resources ? JavaTokenType.SEMICOLON : JavaTokenType.COMMA;
        String noDelimiterMsg = resources ? "expected.semicolon" : "expected.comma";
        String noElementMsg = resources ? "expected.resource" : "expected.parameter";
        PsiBuilder.Marker invalidElements = null;
        String errorMessage = null;
        boolean delimiterExpected = false;
        boolean noElements = true;
        while (true) {
            PsiBuilder.Marker ref;
            IElementType tokenType;
            if ((tokenType = builder.getTokenType()) == null || PARAM_LIST_STOPPERS.contains(tokenType)) {
                boolean noLastElement;
                boolean bl = noLastElement = !delimiterExpected && (!noElements && !resources || noElements && resources);
                if (noLastElement) {
                    String key2 = lambda2 ? "expected.parameter" : "expected.identifier.or.type";
                    JavaParserUtil.error(builder, JavaPsiBundle.message((String)key2, (Object[])new Object[0]));
                }
                if (tokenType == JavaTokenType.RPARENTH) {
                    if (invalidElements != null) {
                        invalidElements.error(errorMessage);
                        invalidElements = null;
                    }
                    builder.advanceLexer();
                    break;
                }
                if (noLastElement && !resources) break;
                if (invalidElements != null) {
                    invalidElements.error(errorMessage);
                }
                invalidElements = null;
                if (!leftParenth) break;
                JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.rparen", (Object[])new Object[0]));
                break;
            }
            if (delimiterExpected) {
                if (builder.getTokenType() == delimiter) {
                    delimiterExpected = false;
                    if (invalidElements != null) {
                        invalidElements.error(errorMessage);
                        invalidElements = null;
                    }
                    builder.advanceLexer();
                    continue;
                }
            } else {
                PsiBuilder.Marker listElement;
                PsiBuilder.Marker marker = type2 == ListType.RECORD_COMPONENTS ? this.parseParameterOrRecordComponent(builder, true, false, false, false) : (resources ? this.parseResource(builder) : (lambda2 ? this.parseLambdaParameter(builder, type2 == ListType.LAMBDA_TYPED) : (listElement = this.parseParameter(builder, true, false, false))));
                if (listElement != null) {
                    delimiterExpected = true;
                    if (invalidElements != null) {
                        invalidElements.errorBefore(errorMessage, listElement);
                        invalidElements = null;
                    }
                    noElements = false;
                    continue;
                }
            }
            if (invalidElements == null) {
                if (builder.getTokenType() == delimiter) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message((String)noElementMsg, (Object[])new Object[0]));
                    builder.advanceLexer();
                    if (!noElements || !resources) continue;
                    noElements = false;
                    continue;
                }
                invalidElements = builder.mark();
                errorMessage = JavaPsiBundle.message((String)(delimiterExpected ? noDelimiterMsg : noElementMsg), (Object[])new Object[0]);
            }
            if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, true, false, false)) != null || builder.getTokenType() == null) continue;
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(errorMessage);
        }
        JavaParserUtil.done(elementList, type2.getNodeType());
    }

    @Nullable
    public PsiBuilder.Marker parseParameter(PsiBuilder builder, boolean ellipsis, boolean disjunctiveType, boolean varType) {
        return this.parseParameterOrRecordComponent(builder, ellipsis, disjunctiveType, varType, true);
    }

    @Nullable
    public PsiBuilder.Marker parseParameterOrRecordComponent(PsiBuilder builder, boolean ellipsis, boolean disjunctiveType, boolean varType, boolean isParameter) {
        int typeFlags = 0;
        if (ellipsis) {
            typeFlags |= 2;
        }
        if (disjunctiveType) {
            typeFlags |= 0x10;
        }
        if (varType) {
            typeFlags |= 0x80;
        }
        return this.parseListElement(builder, true, typeFlags, isParameter ? JavaElementType.PARAMETER : JavaElementType.RECORD_COMPONENT);
    }

    @Nullable
    public PsiBuilder.Marker parseResource(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        PsiBuilder.Marker expr2 = this.myParser.getExpressionParser().parse(builder);
        if (expr2 != null && RESOURCE_EXPRESSIONS.contains(JavaParserUtil.exprType(expr2)) && builder.getTokenType() != JavaTokenType.IDENTIFIER) {
            marker.done(JavaElementType.RESOURCE_EXPRESSION);
            return marker;
        }
        marker.rollbackTo();
        return this.parseListElement(builder, true, 128, JavaElementType.RESOURCE_VARIABLE);
    }

    @Nullable
    public PsiBuilder.Marker parseLambdaParameter(PsiBuilder builder, boolean typed) {
        int flags = 2;
        if (JavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_11)) {
            flags |= 0x80;
        }
        return this.parseListElement(builder, typed, flags, JavaElementType.PARAMETER);
    }

    @Nullable
    private PsiBuilder.Marker parseListElement(PsiBuilder builder, boolean typed, int typeFlags, IElementType type2) {
        IElementType tokenType;
        PsiBuilder.Marker param = builder.mark();
        Pair<PsiBuilder.Marker, Boolean> modListInfo = this.parseModifierList(builder);
        ReferenceParser.TypeInfo typeInfo = null;
        if (typed) {
            int flags = 5 | typeFlags;
            typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, flags);
            if (typeInfo == null) {
                if (Boolean.TRUE.equals(modListInfo.second)) {
                    param.rollbackTo();
                    return null;
                }
                JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.type", (Object[])new Object[0]));
                JavaParserUtil.emptyElement(builder, JavaElementType.TYPE);
            }
        }
        if (typed && ((tokenType = builder.getTokenType()) == JavaTokenType.THIS_KEYWORD || tokenType == JavaTokenType.IDENTIFIER && builder.lookAhead(1) == JavaTokenType.DOT)) {
            PsiBuilder.Marker mark = builder.mark();
            PsiBuilder.Marker expr2 = this.myParser.getExpressionParser().parse(builder);
            if (expr2 != null && JavaParserUtil.exprType(expr2) == JavaElementType.THIS_EXPRESSION) {
                mark.drop();
                JavaParserUtil.done(param, JavaElementType.RECEIVER_PARAMETER);
                return param;
            }
            mark.rollbackTo();
        }
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            if (type2 == JavaElementType.PARAMETER || type2 == JavaElementType.RECORD_COMPONENT) {
                this.eatBrackets(builder, typeInfo != null && typeInfo.isVarArg ? "expected.rparen" : null);
                JavaParserUtil.done(param, type2);
                return param;
            }
        } else {
            JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.identifier", (Object[])new Object[0]));
            param.drop();
            return (PsiBuilder.Marker)modListInfo.first;
        }
        if (JavaParserUtil.expectOrError(builder, JavaTokenType.EQ, "expected.eq") && this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.expression", (Object[])new Object[0]));
        }
        JavaParserUtil.done(param, JavaElementType.RESOURCE_VARIABLE);
        return param;
    }

    @Nullable
    private PsiBuilder.Marker parseFieldOrLocalVariable(PsiBuilder builder, PsiBuilder.Marker declaration2, int declarationStart, Context context) {
        boolean shouldRollback;
        IElementType varType;
        if (context == Context.CLASS || context == Context.ANNOTATION_INTERFACE) {
            varType = JavaElementType.FIELD;
        } else if (context == Context.CODE_BLOCK) {
            varType = JavaElementType.LOCAL_VARIABLE;
        } else {
            declaration2.drop();
            assert (false) : "Unexpected context: " + (Object)((Object)context);
            return null;
        }
        PsiBuilder.Marker variable = declaration2;
        boolean unclosed = false;
        boolean eatSemicolon = true;
        boolean openMarker = true;
        while (true) {
            shouldRollback = true;
            if (!this.eatBrackets(builder, null)) {
                unclosed = true;
            }
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.EQ)) {
                PsiBuilder.Marker expr2 = this.myParser.getExpressionParser().parse(builder);
                if (expr2 != null) {
                    shouldRollback = false;
                } else {
                    JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.expression", (Object[])new Object[0]));
                    unclosed = true;
                    break;
                }
            }
            if (builder.getTokenType() != JavaTokenType.COMMA) break;
            JavaParserUtil.done(variable, varType);
            builder.advanceLexer();
            if (builder.getTokenType() != JavaTokenType.IDENTIFIER) {
                JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.identifier", (Object[])new Object[0]));
                unclosed = true;
                eatSemicolon = false;
                openMarker = false;
                break;
            }
            variable = builder.mark();
            builder.advanceLexer();
        }
        if (builder.getTokenType() == JavaTokenType.SEMICOLON && eatSemicolon) {
            builder.advanceLexer();
        } else {
            if (!builder.eof() && shouldRollback) {
                CharSequence text2 = builder.getOriginalText();
                int spaceEnd = builder.getCurrentOffset();
                int spaceStart = CharArrayUtil.shiftBackward((CharSequence)text2, (int)(spaceEnd - 1), (String)WHITESPACES);
                int lineStart = CharArrayUtil.shiftBackwardUntil((CharSequence)text2, (int)spaceEnd, (String)LINE_ENDS);
                if (declarationStart < lineStart && lineStart < spaceStart) {
                    int newBufferEnd = CharArrayUtil.shiftForward((CharSequence)text2, (int)lineStart, (String)WHITESPACES);
                    declaration2.rollbackTo();
                    return this.parse(JavaParserUtil.stoppingBuilder(builder, newBufferEnd), context);
                }
            }
            if (!unclosed) {
                JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.semicolon", (Object[])new Object[0]));
            }
        }
        if (openMarker) {
            JavaParserUtil.done(variable, varType);
        }
        return declaration2;
    }

    private boolean eatBrackets(PsiBuilder builder, @Nullable @PropertyKey(resourceBundle="messages.JavaPsiBundle") String errorKey) {
        boolean paired;
        IElementType tokenType = builder.getTokenType();
        if (tokenType != JavaTokenType.LBRACKET && tokenType != JavaTokenType.AT) {
            return true;
        }
        PsiBuilder.Marker marker = builder.mark();
        int count = 0;
        while (true) {
            this.parseAnnotations(builder);
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LBRACKET)) break;
            ++count;
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RBRACKET)) break;
            ++count;
        }
        if (count == 0) {
            marker.rollbackTo();
            return true;
        }
        if (errorKey != null) {
            marker.error(JavaPsiBundle.message((String)errorKey, (Object[])new Object[0]));
        } else {
            marker.drop();
        }
        boolean bl = paired = count % 2 == 0;
        if (!paired) {
            JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.rbracket", (Object[])new Object[0]));
        }
        return paired;
    }

    @Nullable
    public PsiBuilder.Marker parseAnnotations(PsiBuilder builder) {
        PsiBuilder.Marker firstAnno = null;
        while (builder.getTokenType() == JavaTokenType.AT) {
            PsiBuilder.Marker anno = this.parseAnnotation(builder);
            if (firstAnno != null) continue;
            firstAnno = anno;
        }
        return firstAnno;
    }

    @NotNull
    public PsiBuilder.Marker parseAnnotation(PsiBuilder builder) {
        assert (builder.getTokenType() == JavaTokenType.AT) : builder.getTokenType();
        PsiBuilder.Marker anno = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker classRef = null;
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER) {
            classRef = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, false, false, false);
        }
        if (classRef == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.class.reference", (Object[])new Object[0]));
        }
        this.parseAnnotationParameterList(builder);
        JavaParserUtil.done(anno, JavaElementType.ANNOTATION);
        return anno;
    }

    private void parseAnnotationParameterList(PsiBuilder builder) {
        PsiBuilder.Marker list = builder.mark();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LPARENTH)) {
            JavaParserUtil.done(list, JavaElementType.ANNOTATION_PARAMETER_LIST);
            return;
        }
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
            JavaParserUtil.done(list, JavaElementType.ANNOTATION_PARAMETER_LIST);
            return;
        }
        boolean isFirstParamNamed = this.parseAnnotationParameter(builder, true);
        boolean isFirstParamWarned = false;
        boolean afterBad = false;
        while (true) {
            IElementType tokenType;
            if ((tokenType = builder.getTokenType()) == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.parameter", (Object[])new Object[0]));
                break;
            }
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) break;
            if (tokenType == JavaTokenType.COMMA) {
                PsiBuilder.Marker errorStart = builder.mark();
                PsiBuilder.Marker errorEnd = builder.mark();
                builder.advanceLexer();
                boolean hasParamName = this.parseAnnotationParameter(builder, false);
                if (!isFirstParamNamed && hasParamName && !isFirstParamWarned) {
                    errorStart.errorBefore(JavaPsiBundle.message((String)"annotation.name.is.missing", (Object[])new Object[0]), errorEnd);
                    isFirstParamWarned = true;
                } else {
                    errorStart.drop();
                }
                errorEnd.drop();
                continue;
            }
            if (!afterBad) {
                JavaParserUtil.error(builder, JavaPsiBundle.message((String)"expected.comma.or.rparen", (Object[])new Object[0]));
                builder.advanceLexer();
                afterBad = true;
                continue;
            }
            afterBad = false;
            this.parseAnnotationParameter(builder, false);
        }
        JavaParserUtil.done(list, JavaElementType.ANNOTATION_PARAMETER_LIST);
    }

    private boolean parseAnnotationParameter(PsiBuilder builder, boolean mayBeSimple) {
        PsiBuilder.Marker pair2 = builder.mark();
        if (mayBeSimple) {
            this.parseAnnotationValue(builder);
            if (builder.getTokenType() != JavaTokenType.EQ) {
                JavaParserUtil.done(pair2, JavaElementType.NAME_VALUE_PAIR);
                return false;
            }
            pair2.rollbackTo();
            pair2 = builder.mark();
        }
        boolean hasName = JavaParserUtil.expectOrError(builder, JavaTokenType.IDENTIFIER, "expected.identifier");
        JavaParserUtil.expectOrError(builder, JavaTokenType.EQ, "expected.eq");
        this.parseAnnotationValue(builder);
        JavaParserUtil.done(pair2, JavaElementType.NAME_VALUE_PAIR);
        return hasName;
    }

    public void parseAnnotationValue(PsiBuilder builder) {
        PsiBuilder.Marker result = this.doParseAnnotationValue(builder);
        if (result == null) {
            result = builder.mark();
            result.error(JavaPsiBundle.message((String)"expected.value", (Object[])new Object[0]));
        }
    }

    @Nullable
    private PsiBuilder.Marker doParseAnnotationValue(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        PsiBuilder.Marker result = tokenType == JavaTokenType.AT ? this.parseAnnotation(builder) : (tokenType == JavaTokenType.LBRACE ? this.myParser.getExpressionParser().parseArrayInitializer(builder, JavaElementType.ANNOTATION_ARRAY_INITIALIZER, this::doParseAnnotationValue, "expected.value") : this.myParser.getExpressionParser().parseConditional(builder));
        return result;
    }

    private static enum ListType {
        METHOD,
        RESOURCE,
        LAMBDA_TYPED,
        LAMBDA_UNTYPED,
        RECORD_COMPONENTS;


        IElementType getNodeType() {
            if (this == RESOURCE) {
                return JavaElementType.RESOURCE_LIST;
            }
            if (this == RECORD_COMPONENTS) {
                return JavaElementType.RECORD_HEADER;
            }
            return JavaElementType.PARAMETER_LIST;
        }
    }

    public static enum Context {
        FILE,
        CLASS,
        CODE_BLOCK,
        ANNOTATION_INTERFACE;

    }
}

