/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lang.java.parser.JShellParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.JShellFileImpl;
import com.intellij.psi.impl.source.tree.IJShellElementType;
import com.intellij.psi.impl.source.tree.JShellElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import org.jetbrains.annotations.NotNull;

public class JShellParserDefinition
extends JavaParserDefinition {
    private static final PsiParser PARSER = new PsiParser(){

        @NotNull
        public ASTNode parse(@NotNull IElementType rootElement, @NotNull PsiBuilder builder) {
            JavaParserUtil.setLanguageLevel(builder, LanguageLevel.HIGHEST);
            PsiBuilder.Marker r = builder.mark();
            JShellParser.INSTANCE.getFileParser().parse(builder);
            r.done(rootElement);
            return builder.getTreeBuilt();
        }
    };

    @Override
    public PsiFile createFile(FileViewProvider viewProvider) {
        return new JShellFileImpl(viewProvider);
    }

    @Override
    public IFileElementType getFileNodeType() {
        return JShellElementType.FILE;
    }

    @Override
    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type2 = node.getElementType();
        if (type2 instanceof IJShellElementType) {
            return ((IJShellElementType)type2).createPsi(node);
        }
        return super.createElement(node);
    }

    @Override
    @NotNull
    public PsiParser createParser(Project project) {
        return PARSER;
    }
}

