/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.services;

import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MavenRepositoryService {
    @NotNull
    public abstract String getDisplayName();

    @NotNull
    public abstract List<RemoteRepositoryDescription> getRepositories(@NotNull String var1) throws IOException;

    @NotNull
    public abstract List<RepositoryArtifactDescription> findArtifacts(@NotNull String var1, @NotNull RepositoryArtifactDescription var2) throws IOException;

    public final String toString() {
        return this.getDisplayName();
    }

    @NotNull
    protected String mapToParamString(@NotNull Map<String, String> params) {
        return StringUtil.join(params.entrySet(), entry -> {
            if (entry.getValue() == null) {
                return null;
            }
            try {
                return (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException ignore) {
                return null;
            }
        }, (String)"&");
    }

    protected Url toUrl(@NotNull String base, @NotNull String path) throws MalformedURLException {
        return this.toUrl(base, path, null);
    }

    protected Url toUrl(@NotNull String base, @NotNull String path, @Nullable String parameters2) throws MalformedURLException {
        Url baseUrl = Urls.parse((String)base, (boolean)false);
        if (baseUrl == null || baseUrl.getScheme() == null || baseUrl.getAuthority() == null) {
            throw new MalformedURLException("cannot parse " + base);
        }
        String newPath = baseUrl.getPath().endsWith("/") ? baseUrl.getPath() + path : baseUrl.getPath() + "/" + path;
        return Urls.newUrl((String)baseUrl.getScheme(), (String)baseUrl.getAuthority(), (String)newPath, parameters2 == null ? null : "?" + parameters2);
    }
}

