/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.impl.java.JavaLambdaTreeElement;
import com.intellij.ide.structureView.impl.java.JavaStructureViewBundle;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.PropertyOwner;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.SyntaxTraverser;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaLambdaNodeProvider
implements FileStructureNodeProvider<JavaLambdaTreeElement>,
PropertyOwner,
DumbAware {
    @NonNls
    public static final String ID = "SHOW_LAMBDA";
    @NonNls
    public static final String JAVA_LAMBDA_PROPERTY_NAME = "java.lambda.provider";

    @NotNull
    public List<JavaLambdaTreeElement> provideNodes(@NotNull TreeElement node) {
        if (!(node instanceof PsiTreeElementBase)) {
            return Collections.emptyList();
        }
        PsiElement element = ((PsiTreeElementBase)node).getElement();
        return ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)element).expand(o -> o == element || !(o instanceof PsiMember) && !(o instanceof PsiLambdaExpression))).filter(PsiLambdaExpression.class).filter(o -> o != element).map(o -> new JavaLambdaTreeElement((PsiLambdaExpression)o)).toList();
    }

    @NotNull
    public String getCheckBoxText() {
        return JavaStructureViewBundle.message("file.structure.toggle.show.collapse.show.lambdas", new Object[0]);
    }

    public Shortcut @NotNull [] getShortcut() {
        return new Shortcut[]{KeyboardShortcut.fromString((String)(SystemInfo.isMac ? "meta L" : "control L"))};
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(this.getCheckBoxText(), null, AllIcons.Nodes.Lambda);
    }

    @NotNull
    public String getName() {
        return ID;
    }

    @NotNull
    public String getPropertyName() {
        return JAVA_LAMBDA_PROPERTY_NAME;
    }
}

