/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.java.ClassInitializerTreeElement;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElementBase;
import com.intellij.ide.structureView.impl.java.PsiFieldTreeElement;
import com.intellij.ide.structureView.impl.java.PsiMethodTreeElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaClassTreeElement
extends JavaClassTreeElementBase<PsiClass> {
    public JavaClassTreeElement(PsiClass cls, boolean inherited) {
        super(inherited, cls);
    }

    @Deprecated
    public JavaClassTreeElement(PsiClass cls, boolean inherited, Set<PsiClass> parents) {
        this(cls, inherited);
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        return JavaClassTreeElement.getClassChildren((PsiClass)this.getElement());
    }

    static Collection<StructureViewTreeElement> getClassChildren(PsiClass aClass) {
        if (aClass == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<PsiElement> members = JavaClassTreeElement.getOwnChildren(aClass);
        ArrayList<StructureViewTreeElement> children = new ArrayList<StructureViewTreeElement>(members.size());
        for (PsiElement child : members) {
            if (!child.isValid()) continue;
            if (child instanceof PsiClass) {
                children.add((StructureViewTreeElement)new JavaClassTreeElement((PsiClass)child, false));
                continue;
            }
            if (child instanceof PsiField) {
                children.add((StructureViewTreeElement)new PsiFieldTreeElement((PsiField)child, false));
                continue;
            }
            if (child instanceof PsiMethod) {
                children.add((StructureViewTreeElement)new PsiMethodTreeElement((PsiMethod)child, false));
                continue;
            }
            if (!(child instanceof PsiClassInitializer)) continue;
            children.add((StructureViewTreeElement)new ClassInitializerTreeElement((PsiClassInitializer)child));
        }
        return children;
    }

    static LinkedHashSet<PsiElement> getOwnChildren(@NotNull PsiClass aClass) {
        LinkedHashSet<PsiElement> members = new LinkedHashSet<PsiElement>();
        JavaClassTreeElement.addPhysicalElements((PsiMember[])aClass.getFields(), members, aClass);
        JavaClassTreeElement.addPhysicalElements((PsiMember[])aClass.getMethods(), members, aClass);
        JavaClassTreeElement.addPhysicalElements((PsiMember[])aClass.getInnerClasses(), members, aClass);
        JavaClassTreeElement.addPhysicalElements((PsiMember[])aClass.getInitializers(), members, aClass);
        return members;
    }

    private static void addPhysicalElements(PsiMember @NotNull [] elements, @NotNull Collection<? super PsiElement> to, @NotNull PsiClass aClass) {
        for (PsiMember element : elements) {
            PsiElement mirror = PsiImplUtil.handleMirror((PsiElement)element);
            if (mirror instanceof LightElement || !(mirror instanceof PsiMember) || !aClass.equals(((PsiMember)mirror).getContainingClass())) continue;
            to.add((PsiElement)mirror);
        }
    }

    public String getPresentableText() {
        PsiClass o = (PsiClass)this.getElement();
        return o == null ? "" : o.getName();
    }

    @Override
    public boolean isPublic() {
        PsiClass o = (PsiClass)this.getElement();
        return o != null && o.getParent() instanceof PsiFile || super.isPublic();
    }
}

