/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.TypeHierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class SupertypesHierarchyTreeStructure
extends HierarchyTreeStructure {
    public SupertypesHierarchyTreeStructure(Project project, PsiClass aClass) {
        super(project, (HierarchyNodeDescriptor)new TypeHierarchyNodeDescriptor(project, null, (PsiElement)aClass, true));
    }

    protected final Object @NotNull [] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        PsiClass functionalInterfaceClass;
        PsiElement element = ((TypeHierarchyNodeDescriptor)descriptor).getPsiClass();
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            PsiClass[] supers = SupertypesHierarchyTreeStructure.getSupers(psiClass);
            ArrayList<TypeHierarchyNodeDescriptor> descriptors = new ArrayList<TypeHierarchyNodeDescriptor>();
            PsiClass objectClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass("java.lang.Object", psiClass.getResolveScope());
            for (PsiClass aSuper : supers) {
                if (psiClass.isInterface() && aSuper.equals(objectClass)) continue;
                descriptors.add(new TypeHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)aSuper, false));
            }
            return descriptors.toArray(new HierarchyNodeDescriptor[0]);
        }
        if (element instanceof PsiFunctionalExpression && (functionalInterfaceClass = LambdaUtil.resolveFunctionalInterfaceClass((PsiFunctionalExpression)((PsiFunctionalExpression)element))) != null) {
            return new HierarchyNodeDescriptor[]{new TypeHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)functionalInterfaceClass, false)};
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    private static PsiClass @NotNull [] getSupers(@NotNull PsiClass psiClass) {
        if (psiClass.isAnnotationType()) {
            return SupertypesHierarchyTreeStructure.getMetaAnnotations(psiClass);
        }
        return psiClass.getSupers();
    }

    private static PsiClass @NotNull [] getMetaAnnotations(@NotNull PsiClass psiClass) {
        HashSet<PsiClass> supers = new HashSet<PsiClass>();
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList != null) {
            for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                PsiAnnotation.TargetType target;
                PsiClass aClass;
                if (SupertypesHierarchyTreeStructure.isJavaLangAnnotation(annotation) || (aClass = annotation.resolveAnnotationType()) == null || (target = AnnotationTargetUtil.findAnnotationTarget((PsiClass)aClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.ANNOTATION_TYPE})) == null || target == PsiAnnotation.TargetType.UNKNOWN) continue;
                supers.add(aClass);
            }
        }
        return supers.toArray(PsiClass.EMPTY_ARRAY);
    }

    private static boolean isJavaLangAnnotation(@NotNull PsiAnnotation annotation) {
        String qualifiedName = annotation.getQualifiedName();
        return qualifiedName != null && qualifiedName.startsWith("java.lang.annotation");
    }
}

