/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.library.impl;

import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.frameworks.beans.RequiredFrameworkVersion;
import com.intellij.framework.FrameworkAvailabilityCondition;
import com.intellij.framework.library.DownloadableLibraryDescription;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.framework.library.impl.DownloadableLibraryPropertiesEditor;
import com.intellij.framework.library.impl.LibraryVersionsFetcher;
import com.intellij.ide.util.frameworkSupport.CustomLibraryDescriptionImpl;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class DownloadableLibraryServiceImpl
extends DownloadableLibraryService {
    private static final Logger LOG = Logger.getInstance(DownloadableLibraryServiceImpl.class);

    @Override
    @NotNull
    public DownloadableLibraryDescription createLibraryDescription(@NotNull String groupId, URL ... localUrls) {
        return new LibraryVersionsFetcher(groupId, localUrls){

            @NotNull
            protected FrameworkAvailabilityCondition createAvailabilityCondition(Artifact version) {
                RequiredFrameworkVersion groupVersion = version.getRequiredFrameworkVersion();
                if (groupVersion != null) {
                    return new FrameworkLibraryAvailabilityCondition(groupVersion.myGroupId, groupVersion.myVersion);
                }
                return FrameworkAvailabilityCondition.ALWAYS_TRUE;
            }
        };
    }

    @Override
    @NotNull
    public CustomLibraryDescription createDescriptionForType(Class<? extends DownloadableLibraryType> typeClass) {
        DownloadableLibraryType libraryType = (DownloadableLibraryType)((Object)LibraryType.EP_NAME.findExtension(typeClass));
        LOG.assertTrue(libraryType != null, typeClass);
        return new CustomLibraryDescriptionImpl(libraryType);
    }

    @Override
    @NotNull
    public LibraryPropertiesEditor createDownloadableLibraryEditor(@NotNull DownloadableLibraryDescription description, @NotNull LibraryEditorComponent<LibraryVersionProperties> editorComponent, @NotNull DownloadableLibraryType libraryType) {
        return new DownloadableLibraryPropertiesEditor(description, editorComponent, libraryType);
    }

    private static class FrameworkLibraryAvailabilityCondition
    extends FrameworkAvailabilityCondition {
        private final String myGroupId;
        private final String myVersionId;

        FrameworkLibraryAvailabilityCondition(String groupId, String versionId) {
            this.myGroupId = groupId;
            this.myVersionId = versionId;
        }

        public boolean isAvailableFor(@NotNull FrameworkSupportModel model) {
            Object selectedVersion = ((FrameworkSupportModelBase)model).getSelectedVersion(this.myGroupId);
            return selectedVersion != null && this.myVersionId.equals(selectedVersion.getId());
        }
    }
}

