/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.find.findUsages.PersistentFindUsagesOptions;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.SearchScope;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class JavaFindUsagesOptions
extends PersistentFindUsagesOptions {
    public boolean isSkipImportStatements;

    public JavaFindUsagesOptions(@NotNull Project project) {
        super(project);
        this.isUsages = true;
    }

    public JavaFindUsagesOptions(@NotNull SearchScope searchScope) {
        super(searchScope);
        this.isUsages = true;
    }

    public final void setDefaults(@NotNull Project project) {
        this.setDefaults(PropertiesComponent.getInstance((Project)project), this.findPrefix());
    }

    protected void setDefaults(@NotNull PropertiesComponent properties, @NotNull String prefix) {
        this.isSearchForTextOccurrences = properties.getBoolean(prefix + "isSearchForTextOccurrences", true);
        this.isUsages = properties.getBoolean(prefix + "isUsages", true);
    }

    public final void storeDefaults(@NotNull Project project) {
        this.storeDefaults(PropertiesComponent.getInstance((Project)project), this.findPrefix());
    }

    protected void storeDefaults(@NotNull PropertiesComponent properties, @NotNull String prefix) {
        properties.setValue(prefix + "isUsages", this.isUsages, true);
        properties.setValue(prefix + "isSearchForTextOccurrences", this.isSearchForTextOccurrences, true);
    }

    @NotNull
    private String findPrefix() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ".";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return this.isSkipImportStatements == ((JavaFindUsagesOptions)((Object)o)).isSkipImportStatements;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isSkipImportStatements ? 1 : 0);
        return result;
    }

    protected void addUsageTypes(@NotNull Set<? super String> to) {
        if (this.isUsages) {
            to.add(AnalysisBundle.message((String)"find.usages.panel.title.usages", (Object[])new Object[0]));
        }
    }

    @NotNull
    public final String generateUsagesString() {
        String separator = " " + AnalysisBundle.message((String)"find.usages.panel.title.separator", (Object[])new Object[0]) + " ";
        LinkedHashSet<String> strings = new LinkedHashSet<String>();
        this.addUsageTypes(strings);
        if (strings.isEmpty()) {
            strings.add(AnalysisBundle.message((String)"find.usages.panel.title.usages", (Object[])new Object[0]));
        }
        return StringUtil.join(strings, (String)separator);
    }
}

