/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.info;

import com.intellij.execution.Location;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class LocationUtil {
    public static boolean isJarAttached(@NotNull Location location, @NotNull PsiPackage aPackage, String ... fqn) {
        return LocationUtil.isJarAttached(location, aPackage.getDirectories(), fqn);
    }

    public static boolean isJarAttached(@NotNull Location location, PsiDirectory[] directories, String ... fqns) {
        String arg2;
        Project project = location.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        Module locationModule = location.getModule();
        VirtualFile locationVirtualFile = location.getVirtualFile();
        String string = arg2 = locationVirtualFile != null ? locationVirtualFile.getPath() : null;
        if (locationModule != null && !Objects.equals(project.getBasePath(), arg2)) {
            for (String fqn : fqns) {
                if (facade.findClass(fqn, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)locationModule, (boolean)true)) == null) continue;
                return true;
            }
        } else {
            for (PsiDirectory directory : directories) {
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)project);
                if (module == null) continue;
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)true);
                for (String fqn : fqns) {
                    if (facade.findClass(fqn, scope) == null) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

