/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.diagnostic.logging.LogsFragment;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.ClassEditorField;
import com.intellij.execution.configuration.RunConfigurationExtensionsManager;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.ui.BeforeRunComponent;
import com.intellij.execution.ui.BeforeRunFragment;
import com.intellij.execution.ui.CommandLinePanel;
import com.intellij.execution.ui.CommonJavaFragments;
import com.intellij.execution.ui.CommonParameterFragments;
import com.intellij.execution.ui.CommonTags;
import com.intellij.execution.ui.FragmentedSettingsUtil;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.execution.ui.ModuleClasspathCombo;
import com.intellij.execution.ui.RunConfigurationFragmentedEditor;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.execution.ui.ShortenCommandLineModeCombo;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JComponent;

public final class JavaApplicationSettingsEditor
extends RunConfigurationFragmentedEditor<ApplicationConfiguration> {
    private final Project myProject;

    public JavaApplicationSettingsEditor(ApplicationConfiguration configuration) {
        super((RunConfigurationBase)configuration, (RunConfigurationExtensionsManager)JavaRunConfigurationExtensionManager.getInstance());
        this.myProject = configuration.getProject();
    }

    protected List<SettingsEditorFragment<ApplicationConfiguration, ?>> createRunFragments() {
        ArrayList fragments = new ArrayList();
        BeforeRunComponent beforeRunComponent = new BeforeRunComponent((Disposable)this);
        fragments.add((SettingsEditorFragment<ApplicationConfiguration, ?>)BeforeRunFragment.createBeforeRun((BeforeRunComponent)beforeRunComponent, CompileStepBeforeRun.ID));
        fragments.addAll(BeforeRunFragment.createGroup());
        ModuleClasspathCombo.Item item = new ModuleClasspathCombo.Item(ExecutionBundle.message((String)"application.configuration.include.provided.scope", (Object[])new Object[0]));
        SettingsEditorFragment<ApplicationConfiguration, ModuleClasspathCombo> moduleClasspath = CommonJavaFragments.moduleClasspath(item, configuration -> configuration.isProvidedScopeIncluded(), (configuration, value2) -> configuration.setIncludeProvidedScope((boolean)value2));
        ModuleClasspathCombo classpathCombo = (ModuleClasspathCombo)moduleClasspath.component();
        Computable hasModule = () -> classpathCombo.getSelectedModule() != null;
        fragments.add(CommonTags.parallelRun());
        CommonParameterFragments commonParameterFragments = new CommonParameterFragments(this.myProject, hasModule);
        fragments.add(commonParameterFragments.createRedirectFragment(hasModule));
        fragments.addAll(commonParameterFragments.getFragments());
        fragments.add(CommonJavaFragments.createBuildBeforeRun(beforeRunComponent));
        SettingsEditorFragment<ApplicationConfiguration, JrePathEditor> jrePath = CommonJavaFragments.createJrePath(this.myProject);
        fragments.add(jrePath);
        String group = ExecutionBundle.message((String)"group.java.options", (Object[])new Object[0]);
        RawCommandLineEditor vmOptions = new RawCommandLineEditor();
        CommandLinePanel.setMinimumWidth((Component)vmOptions, (int)400);
        String message2 = ExecutionBundle.message((String)"run.configuration.java.vm.parameters.empty.text", (Object[])new Object[0]);
        vmOptions.getEditorField().getAccessibleContext().setAccessibleName(message2);
        vmOptions.getEditorField().getEmptyText().setText(message2);
        MacrosDialog.addMacroSupport((ExtendableTextField)vmOptions.getEditorField(), (Predicate)MacrosDialog.Filters.ALL, (Computable)hasModule);
        FragmentedSettingsUtil.setupPlaceholderVisibility((JBTextField)vmOptions.getEditorField());
        SettingsEditorFragment vmParameters = new SettingsEditorFragment("vmParameters", ExecutionBundle.message((String)"run.configuration.java.vm.parameters.name", (Object[])new Object[0]), group, (JComponent)vmOptions, 15, (configuration, c) -> c.setText(configuration.getVMParameters()), (configuration, c) -> configuration.setVMParameters(c.isVisible() ? c.getText() : null), configuration -> StringUtil.isNotEmpty((String)configuration.getVMParameters()));
        vmParameters.setHint(ExecutionBundle.message((String)"run.configuration.java.vm.parameters.hint", (Object[])new Object[0]));
        vmParameters.setEditorGetter(editor -> editor.getEditorField());
        fragments.add(vmParameters);
        ClassEditorField mainClass = ClassEditorField.createClassField(this.myProject, (Computable<? extends Module>)((Computable)() -> classpathCombo.getSelectedModule()));
        mainClass.setShowPlaceholderWhenFocused(true);
        UIUtil.setMonospaced((Component)((Object)mainClass));
        String placeholder = ExecutionBundle.message((String)"application.configuration.main.class.placeholder", (Object[])new Object[0]);
        mainClass.setPlaceholder(placeholder);
        mainClass.getAccessibleContext().setAccessibleName(placeholder);
        CommandLinePanel.setMinimumWidth((Component)((Object)mainClass), (int)300);
        SettingsEditorFragment mainClassFragment = new SettingsEditorFragment("mainClass", null, null, (JComponent)((Object)mainClass), 20, (configuration, component) -> component.setText(configuration.getMainClassName()), (configuration, component) -> configuration.setMainClassName(component.getText()), configuration -> true);
        mainClassFragment.setHint(ExecutionBundle.message((String)"application.configuration.main.class.hint", (Object[])new Object[0]));
        fragments.add(mainClassFragment);
        fragments.add(moduleClasspath);
        ShortenCommandLineModeCombo combo = new ShortenCommandLineModeCombo(this.myProject, (JrePathEditor)((Object)jrePath.component()), (Computable<? extends Module>)((Computable)() -> classpathCombo.getSelectedModule()), (Consumer<? super ActionListener>)((Consumer)listener -> classpathCombo.addActionListener((ActionListener)listener)));
        fragments.add(new SettingsEditorFragment("shorten.command.line", ExecutionBundle.message((String)"application.configuration.shorten.command.line", (Object[])new Object[0]), group, (JComponent)LabeledComponent.create((JComponent)((Object)combo), (String)ExecutionBundle.message((String)"application.configuration.shorten.command.line.label", (Object[])new Object[0]), (String)"West"), (configuration, c) -> ((ShortenCommandLineModeCombo)((Object)((Object)c.getComponent()))).setItem(configuration.getShortenCommandLine()), (configuration, c) -> configuration.setShortenCommandLine(c.isVisible() ? ((ShortenCommandLineModeCombo)((Object)((Object)c.getComponent()))).getSelectedItem() : null), configuration -> configuration.getShortenCommandLine() != null));
        fragments.add(SettingsEditorFragment.createTag((String)"formSnapshots", (String)ExecutionBundle.message((String)"show.swing.inspector.name", (Object[])new Object[0]), (String)group, configuration -> configuration.isSwingInspectorEnabled(), (configuration, enabled) -> configuration.setSwingInspectorEnabled((boolean)enabled)));
        fragments.add((SettingsEditorFragment<ApplicationConfiguration, ?>)new LogsFragment());
        return fragments;
    }
}

