/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.DynamicBundle;
import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.execution.ui.ShortenCommandLineModeCombo;
import com.intellij.execution.util.JreVersionDetector;
import com.intellij.ide.DataManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationConfigurable
extends SettingsEditor<ApplicationConfiguration>
implements PanelWithAnchor {
    private final Project myProject;
    private final ConfigurationModuleSelector myModuleSelector;
    private final JreVersionDetector myVersionDetector;
    private JPanel myWholePanel;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myMainClass;
    private CommonJavaParametersPanel myCommonProgramParameters;
    private LabeledComponent<ModuleDescriptionsComboBox> myModule;
    private LabeledComponent<JBCheckBox> myIncludeProvidedDeps;
    private JrePathEditor myJrePathEditor;
    private LabeledComponent<ShortenCommandLineModeCombo> myShortenClasspathModeCombo;
    private JCheckBox myShowSwingInspectorCheckbox;
    private JComponent myAnchor;

    public ApplicationConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myModuleSelector = new ConfigurationModuleSelector(project, (ModuleDescriptionsComboBox)this.myModule.getComponent());
        this.myVersionDetector = new JreVersionDetector();
        this.myJrePathEditor.setDefaultJreSelector(DefaultJreSelector.fromSourceRootsDependencies((ModuleDescriptionsComboBox)this.myModule.getComponent(), this.getMainClassField()));
        this.myCommonProgramParameters.setModuleContext(this.myModuleSelector.getModule());
        ((ModuleDescriptionsComboBox)this.myModule.getComponent()).addActionListener(e -> this.myCommonProgramParameters.setModuleContext(this.myModuleSelector.getModule()));
        new ClassBrowser.AppClassBrowser(project, this.myModuleSelector).setField(this.getMainClassField());
        this.myShortenClasspathModeCombo.setComponent((JComponent)((Object)new ShortenCommandLineModeCombo(this.myProject, this.myJrePathEditor, (ModuleDescriptionsComboBox)this.myModule.getComponent())));
        this.myIncludeProvidedDeps.setComponent((JComponent)new JBCheckBox(ExecutionBundle.message((String)"application.configuration.include.provided.scope", (Object[])new Object[0])));
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myMainClass, this.myCommonProgramParameters, this.myJrePathEditor, this.myModule, this.myShortenClasspathModeCombo, this.myIncludeProvidedDeps});
    }

    public void applyEditorTo(@NotNull ApplicationConfiguration configuration) throws ConfigurationException {
        this.myCommonProgramParameters.applyTo(configuration);
        this.myModuleSelector.applyTo(configuration);
        String className2 = this.getMainClassField().getText();
        PsiClass aClass = this.myModuleSelector.findClass(className2);
        configuration.setMainClassName(aClass != null ? JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass) : className2);
        configuration.setAlternativeJrePath(this.myJrePathEditor.getJrePathOrName());
        configuration.setAlternativeJrePathEnabled(this.myJrePathEditor.isAlternativeJreSelected());
        configuration.setSwingInspectorEnabled(this.isJre50Configured(configuration) && this.myShowSwingInspectorCheckbox.isSelected());
        configuration.setShortenCommandLine(((ShortenCommandLineModeCombo)((Object)this.myShortenClasspathModeCombo.getComponent())).getSelectedItem());
        configuration.setIncludeProvidedScope(((JBCheckBox)this.myIncludeProvidedDeps.getComponent()).isSelected());
        this.hideUnsupportedFieldsIfNeeded();
        this.updateShowSwingInspector(configuration);
    }

    public void hideUnsupportedFieldsIfNeeded() {
        boolean localTarget = DataManager.getInstance().getDataContext((Component)this.myWholePanel).getData(SingleConfigurationConfigurable.RUN_ON_TARGET_NAME_KEY) == null;
        this.myJrePathEditor.setVisible(localTarget);
        this.myShowSwingInspectorCheckbox.setVisible(localTarget);
    }

    public void resetEditorFrom(@NotNull ApplicationConfiguration configuration) {
        this.myCommonProgramParameters.reset(configuration);
        this.myModuleSelector.reset(configuration);
        this.getMainClassField().setText(configuration.getMainClassName() != null ? configuration.getMainClassName().replaceAll("\\$", "\\.") : "");
        this.myJrePathEditor.setPathOrName(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled());
        ((ShortenCommandLineModeCombo)((Object)this.myShortenClasspathModeCombo.getComponent())).setSelectedItem(configuration.getShortenCommandLine());
        ((JBCheckBox)this.myIncludeProvidedDeps.getComponent()).setSelected(configuration.isProvidedScopeIncluded());
        this.hideUnsupportedFieldsIfNeeded();
        this.updateShowSwingInspector(configuration);
    }

    private boolean isJre50Configured(ApplicationConfiguration configuration) {
        return this.myVersionDetector.isJre50Configured(configuration) || this.myVersionDetector.isModuleJre50Configured(configuration);
    }

    private void updateShowSwingInspector(ApplicationConfiguration configuration) {
        if (this.isJre50Configured(configuration)) {
            this.myShowSwingInspectorCheckbox.setEnabled(true);
            this.myShowSwingInspectorCheckbox.setSelected(configuration.isSwingInspectorEnabled());
            this.myShowSwingInspectorCheckbox.setText(ExecutionBundle.message((String)"show.swing.inspector", (Object[])new Object[0]));
        } else {
            this.myShowSwingInspectorCheckbox.setEnabled(false);
            this.myShowSwingInspectorCheckbox.setSelected(false);
            this.myShowSwingInspectorCheckbox.setText(ExecutionBundle.message((String)"show.swing.inspector.disabled", (Object[])new Object[0]));
        }
    }

    public EditorTextFieldWithBrowseButton getMainClassField() {
        return (EditorTextFieldWithBrowseButton)((Object)this.myMainClass.getComponent());
    }

    public CommonJavaParametersPanel getCommonProgramParameters() {
        return this.myCommonProgramParameters;
    }

    @NotNull
    public JComponent createEditor() {
        return this.myWholePanel;
    }

    private void createUIComponents() {
        this.myMainClass = new LabeledComponent();
        this.myMainClass.setComponent((JComponent)((Object)new EditorTextFieldWithBrowseButton(this.myProject, true, (declaration2, place) -> {
            PsiClass aClass;
            if (declaration2 instanceof PsiClass && (ConfigurationUtil.MAIN_CLASS.value((Object)(aClass = (PsiClass)declaration2)) && PsiMethodUtil.findMainMethod((PsiClass)aClass) != null || place.getParent() != null && this.myModuleSelector.findClass(((PsiClass)declaration2).getQualifiedName()) != null)) {
                return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
            }
            return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
        })));
        this.myShortenClasspathModeCombo = new LabeledComponent();
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myMainClass.setAnchor(anchor);
        this.myCommonProgramParameters.setAnchor(anchor);
        this.myJrePathEditor.setAnchor(anchor);
        this.myModule.setAnchor(anchor);
        this.myShortenClasspathModeCombo.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledComponent labeledComponent;
        JCheckBox jCheckBox;
        JrePathEditor jrePathEditor;
        LabeledComponent labeledComponent2;
        CommonJavaParametersPanel commonJavaParametersPanel;
        JPanel jPanel;
        this.createUIComponents();
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCommonProgramParameters = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel.add((Component)((Object)commonJavaParametersPanel), new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        LabeledComponent<EditorTextFieldWithBrowseButton> labeledComponent3 = this.myMainClass;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/ExecutionBundle", ApplicationConfigurable.class).getString("application.configuration.main.class.label"));
        jPanel.add((Component)labeledComponent3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, new Dimension(-1, 20), null));
        this.myModule = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("com.intellij.application.options.ModuleDescriptionsComboBox");
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/ExecutionBundle", ApplicationConfigurable.class).getString("application.configuration.use.classpath.and.jdk.of.module.label"));
        jPanel.add((Component)labeledComponent2, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myJrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel.add((Component)((Object)jrePathEditor), new GridConstraints(4, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myShowSwingInspectorCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/ExecutionBundle", ApplicationConfigurable.class).getString("show.swing.inspector"));
        jPanel.add((Component)jCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        LabeledComponent<ShortenCommandLineModeCombo> labeledComponent4 = this.myShortenClasspathModeCombo;
        labeledComponent4.setLabelLocation("West");
        labeledComponent4.setText(DynamicBundle.getBundle((String)"messages/ExecutionBundle", ApplicationConfigurable.class).getString("application.configuration.shorten.command.line.label"));
        jPanel.add((Component)labeledComponent4, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myIncludeProvidedDeps = labeledComponent = new LabeledComponent();
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("");
        jPanel.add((Component)labeledComponent, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

