/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationExtension;
import com.intellij.openapi.options.SettingsEditorGroup;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class ExternalSystemRunConfigurationJavaExtension
implements ExternalSystemRunConfigurationExtension {
    private static final Logger LOG = Logger.getInstance(ExternalSystemRunConfigurationJavaExtension.class);

    public void readExternal(@NotNull ExternalSystemRunConfiguration configuration, @NotNull Element element) {
        JavaRunConfigurationExtensionManager javaRunConfigurationExtensionManager = JavaRunConfigurationExtensionManager.getInstanceOrNull();
        if (javaRunConfigurationExtensionManager != null) {
            javaRunConfigurationExtensionManager.readExternal((RunConfigurationBase)configuration, element);
        }
    }

    public void writeExternal(@NotNull ExternalSystemRunConfiguration configuration, @NotNull Element element) {
        JavaRunConfigurationExtensionManager javaRunConfigurationExtensionManager = JavaRunConfigurationExtensionManager.getInstanceOrNull();
        if (javaRunConfigurationExtensionManager != null) {
            javaRunConfigurationExtensionManager.writeExternal((RunConfigurationBase)configuration, element);
        }
    }

    public void appendEditors(@NotNull ExternalSystemRunConfiguration configuration, @NotNull SettingsEditorGroup<ExternalSystemRunConfiguration> group) {
        JavaRunConfigurationExtensionManager javaRunConfigurationExtensionManager = JavaRunConfigurationExtensionManager.getInstanceOrNull();
        if (javaRunConfigurationExtensionManager != null) {
            javaRunConfigurationExtensionManager.appendEditors((RunConfigurationBase)configuration, group);
        }
    }

    public void attachToProcess(@NotNull ExternalSystemRunConfiguration configuration, @NotNull ExternalSystemProcessHandler processHandler, @Nullable RunnerSettings settings) {
        JavaRunConfigurationExtensionManager javaRunConfigurationExtensionManager = JavaRunConfigurationExtensionManager.getInstanceOrNull();
        if (javaRunConfigurationExtensionManager != null) {
            javaRunConfigurationExtensionManager.attachExtensionsToProcess((RunConfigurationBase)configuration, (ProcessHandler)processHandler, settings);
        }
    }

    public void updateVMParameters(@NotNull ExternalSystemRunConfiguration configuration, @NotNull SimpleJavaParameters javaParameters, @Nullable RunnerSettings settings, @NotNull Executor executor) throws ExecutionException {
        JavaParameters extensionsJP = new JavaParameters();
        JavaRunConfigurationExtensionManager javaRunConfigurationExtensionManager = JavaRunConfigurationExtensionManager.getInstanceOrNull();
        if (javaRunConfigurationExtensionManager != null) {
            javaRunConfigurationExtensionManager.updateJavaParameters(configuration, extensionsJP, settings, executor);
        }
        extensionsJP.getVMParametersList().copyTo(javaParameters.getVMParametersList());
    }
}

