/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.nodes.NodeComparator;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.DefaultNodeDescriptor;
import com.intellij.debugger.ui.impl.watch.DescriptorTree;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorFactoryImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.openapi.project.Project;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeManagerImpl
extends NodeDescriptorFactoryImpl
implements NodeManager {
    private static final Comparator<DebuggerTreeNode> ourNodeComparator = new NodeComparator();
    private final DebuggerTree myDebuggerTree;
    private String myHistoryKey = null;
    private final Map<String, DescriptorTree> myHistories = new HashMap<String, DescriptorTree>();

    public NodeManagerImpl(Project project, DebuggerTree tree) {
        super(project);
        this.myDebuggerTree = tree;
    }

    public static Comparator<DebuggerTreeNode> getNodeComparator() {
        return ourNodeComparator;
    }

    @Override
    @NotNull
    public DebuggerTreeNodeImpl createNode(NodeDescriptor descriptor, EvaluationContext evaluationContext) {
        ((NodeDescriptorImpl)descriptor).setContext((EvaluationContextImpl)evaluationContext);
        return DebuggerTreeNodeImpl.createNode(this.getTree(), (NodeDescriptorImpl)descriptor, (EvaluationContextImpl)evaluationContext);
    }

    public DebuggerTreeNodeImpl getDefaultNode() {
        return DebuggerTreeNodeImpl.createNodeNoUpdate(this.getTree(), new DefaultNodeDescriptor());
    }

    public DebuggerTreeNodeImpl createMessageNode(MessageDescriptor descriptor) {
        return DebuggerTreeNodeImpl.createNodeNoUpdate(this.getTree(), descriptor);
    }

    @Override
    @NotNull
    public DebuggerTreeNodeImpl createMessageNode(String message2) {
        return DebuggerTreeNodeImpl.createNodeNoUpdate(this.getTree(), new MessageDescriptor(message2));
    }

    public void setHistoryByContext(DebuggerContextImpl context) {
        this.setHistoryByContext(context.getFrameProxy());
    }

    public void setHistoryByContext(StackFrameProxyImpl frameProxy) {
        DescriptorTree historyTree;
        String historyKey;
        if (this.myHistoryKey != null) {
            this.myHistories.put(this.myHistoryKey, this.getCurrentHistoryTree());
        }
        DescriptorTree descriptorTree = (historyKey = this.getContextKey(frameProxy)) != null ? ((historyTree = this.myHistories.get(historyKey)) != null ? historyTree : new DescriptorTree(true)) : new DescriptorTree(true);
        this.deriveHistoryTree(descriptorTree, frameProxy);
        this.myHistoryKey = historyKey;
    }

    @Nullable
    public String getContextKey(StackFrameProxyImpl frame) {
        return NodeManagerImpl.getContextKeyForFrame(frame);
    }

    @Nullable
    public static String getContextKeyForFrame(StackFrameProxyImpl frame) {
        block5: {
            if (frame == null) {
                return null;
            }
            try {
                Location location = frame.location();
                Method method = DebuggerUtilsEx.getMethod(location);
                if (method == null) {
                    return null;
                }
                return location.declaringType().signature() + "#" + method.name() + method.signature();
            }
            catch (EvaluateException location) {
            }
            catch (InternalException ie) {
                if (ie.errorCode() == 23) break block5;
                throw ie;
            }
        }
        return null;
    }

    @Override
    public void dispose() {
        this.myHistories.clear();
        super.dispose();
    }

    private DebuggerTree getTree() {
        return this.myDebuggerTree;
    }
}

