/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.LocalVariableDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalVariableDescriptorImpl
extends ValueDescriptorImpl
implements LocalVariableDescriptor {
    private final StackFrameProxyImpl myFrameProxy;
    private final LocalVariableProxyImpl myLocalVariable;
    private String myTypeName = JavaDebuggerBundle.message((String)"label.unknown.value", (Object[])new Object[0]);
    private boolean myIsPrimitive;
    private boolean myIsParameter;
    private boolean myIsNewLocal = true;

    public LocalVariableDescriptorImpl(Project project, @NotNull LocalVariableProxyImpl local) {
        super(project);
        this.setLvalue(true);
        this.myFrameProxy = local.getFrame();
        this.myLocalVariable = local;
    }

    @Override
    public LocalVariableProxyImpl getLocalVariable() {
        return this.myLocalVariable;
    }

    public boolean isNewLocal() {
        return this.myIsNewLocal;
    }

    @Override
    public boolean isPrimitive() {
        return this.myIsPrimitive;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        LocalVariableProxyImpl variable = this.getLocalVariable();
        boolean isVisible = this.myFrameProxy.isLocalVariableVisible(variable);
        if (isVisible) {
            String typeName;
            this.myTypeName = typeName = variable.typeName();
            this.myIsPrimitive = DebuggerUtils.isPrimitiveType((String)typeName);
            this.myIsParameter = variable.getVariable().isArgument();
            return this.myFrameProxy.getValue(variable);
        }
        return null;
    }

    public void setNewLocal(boolean aNew) {
        this.myIsNewLocal = aNew;
    }

    @Override
    public void displayAs(NodeDescriptor descriptor) {
        super.displayAs(descriptor);
        if (descriptor instanceof LocalVariableDescriptorImpl) {
            this.myIsNewLocal = ((LocalVariableDescriptorImpl)descriptor).myIsNewLocal;
        }
    }

    @Override
    public String getName() {
        return this.myLocalVariable.name();
    }

    @Override
    @Nullable
    public String getDeclaredType() {
        return this.myTypeName;
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        try {
            return elementFactory.createExpressionFromText(this.getName(), PositionUtil.getContextElement((StackFrameContext)context));
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(JavaDebuggerBundle.message((String)"error.invalid.local.variable.name", (Object[])new Object[]{this.getName()}), (Throwable)e);
        }
    }

    @Override
    public XValueModifier getModifier(JavaValue value2) {
        return new JavaValueModifier(value2){

            @Override
            protected void setValueImpl(@NotNull XExpression expression2, @NotNull XValueModifier.XModificationCallback callback) {
                final LocalVariableProxyImpl local = LocalVariableDescriptorImpl.this.getLocalVariable();
                if (local != null) {
                    final DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(LocalVariableDescriptorImpl.this.getProject()).getContext();
                    this.set(expression2, callback, debuggerContext, new JavaValueModifier.SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            debuggerContext.getFrameProxy().setValue(local, 1.preprocessValue(evaluationContext, newValue, this.getLType()));
                            1.update(debuggerContext);
                        }

                        @Override
                        @NotNull
                        public Type getLType() throws EvaluateException, ClassNotLoadedException {
                            return local.getType();
                        }
                    });
                }
            }
        };
    }

    public boolean isParameter() {
        return this.myIsParameter;
    }
}

