/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.tree.TreeBuilder;
import com.intellij.debugger.ui.impl.tree.TreeBuilderNode;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.ui.SimpleColoredText;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerTreeNodeImpl
extends TreeBuilderNode
implements DebuggerTreeNode,
NodeDescriptorProvider,
MutableTreeNode {
    private Icon myIcon;
    private SimpleColoredText myText;
    private String myMarkupTooltipText;
    private final DebuggerTree myTree;
    private final Map myProperties = new HashMap();

    public DebuggerTreeNodeImpl(DebuggerTree tree, NodeDescriptor descriptor) {
        super(descriptor);
        this.myTree = tree;
    }

    @Override
    public DebuggerTreeNodeImpl getParent() {
        return (DebuggerTreeNodeImpl)super.getParent();
    }

    @Override
    protected TreeBuilder getTreeBuilder() {
        return this.myTree.getMutableModel();
    }

    public DebuggerTree getTree() {
        return this.myTree;
    }

    @Override
    public String toString() {
        return this.myText != null ? this.myText.toString() : "";
    }

    @Override
    public NodeDescriptorImpl getDescriptor() {
        return (NodeDescriptorImpl)this.getUserObject();
    }

    @Override
    public Project getProject() {
        return this.getTree().getProject();
    }

    @Override
    public void setRenderer(NodeRenderer renderer) {
        ((ValueDescriptorImpl)this.getDescriptor()).setRenderer(renderer);
        this.calcRepresentation();
    }

    private void updateCaches() {
        ValueMarkup markup;
        NodeDescriptorImpl descriptor = this.getDescriptor();
        this.myIcon = DebuggerTreeRenderer.getDescriptorIcon(descriptor);
        DebuggerContextImpl context = this.getTree().getDebuggerContext();
        this.myText = DebuggerTreeRenderer.getDescriptorText(context, descriptor, DebuggerUIUtil.getColorScheme((JComponent)((Object)this.myTree)), false);
        this.myMarkupTooltipText = descriptor instanceof ValueDescriptor ? ((markup = ((ValueDescriptor)((Object)descriptor)).getMarkup(context.getDebugProcess())) != null ? markup.getToolTipText() : null) : null;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public SimpleColoredText getText() {
        return this.myText;
    }

    @Nullable
    public String getMarkupTooltipText() {
        return this.myMarkupTooltipText;
    }

    @Override
    public void clear() {
        this.removeAllChildren();
        this.myIcon = null;
        this.myText = null;
        super.clear();
    }

    private void update(DebuggerContextImpl context, final Runnable runnable, boolean labelOnly) {
        if (!labelOnly) {
            this.clear();
        }
        if (context != null && context.getDebugProcess() != null) {
            this.getTree().saveState(this);
            this.myIcon = DebuggerTreeRenderer.getDescriptorIcon(MessageDescriptor.EVALUATING);
            this.myText = DebuggerTreeRenderer.getDescriptorText(context, MessageDescriptor.EVALUATING, false);
            context.getDebugProcess().getManagerThread().invoke(new DebuggerContextCommandImpl(context){

                @Override
                public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                    runnable.run();
                }

                @Override
                protected void commandCancelled() {
                    DebuggerTreeNodeImpl.this.clear();
                    DebuggerTreeNodeImpl.this.getDescriptor().clear();
                    DebuggerTreeNodeImpl.this.updateCaches();
                    DebuggerTreeNodeImpl.this.labelChanged();
                    DebuggerTreeNodeImpl.this.childrenChanged(true);
                }

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.NORMAL;
                }
            });
        }
        this.labelChanged();
        if (!labelOnly) {
            this.childrenChanged(true);
        }
    }

    public void calcLabel() {
        DebuggerContextImpl context = this.getTree().getDebuggerContext();
        this.update(context, () -> this.getDescriptor().updateRepresentation(context.createEvaluationContext(), new DescriptorLabelListener(){

            @Override
            public void labelChanged() {
                DebuggerTreeNodeImpl.this.updateCaches();
                DebuggerTreeNodeImpl.this.labelChanged();
            }
        }), true);
    }

    public void calcRepresentation() {
        DebuggerContextImpl context = this.getTree().getDebuggerContext();
        this.update(context, () -> this.getDescriptor().updateRepresentation(context.createEvaluationContext(), new DescriptorLabelListener(){

            @Override
            public void labelChanged() {
                DebuggerTreeNodeImpl.this.updateCaches();
                DebuggerTreeNodeImpl.this.labelChanged();
            }
        }), false);
    }

    public void calcValue() {
        DebuggerContextImpl context = this.getTree().getDebuggerContext();
        this.update(context, () -> {
            EvaluationContextImpl evaluationContext = context.createEvaluationContext();
            this.getDescriptor().setContext(evaluationContext);
            this.getDescriptor().updateRepresentation(evaluationContext, new DescriptorLabelListener(){

                @Override
                public void labelChanged() {
                    DebuggerTreeNodeImpl.this.updateCaches();
                    DebuggerTreeNodeImpl.this.labelChanged();
                }
            });
            this.childrenChanged(true);
        }, false);
    }

    private static void invoke(Runnable r) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public void labelChanged() {
        DebuggerTreeNodeImpl.invoke(() -> {
            this.updateCaches();
            this.getTree().getMutableModel().nodeChanged(this);
        });
    }

    public void childrenChanged(boolean scrollToVisible) {
        DebuggerTreeNodeImpl.invoke(() -> {
            this.getTree().getMutableModel().nodeStructureChanged(this);
            this.getTree().restoreState(this);
        });
    }

    public DebuggerTreeNodeImpl add(MessageDescriptor message2) {
        DebuggerTreeNodeImpl node = this.getNodeFactory().createMessageNode(message2);
        this.add(node);
        return node;
    }

    public NodeManagerImpl getNodeFactory() {
        return this.myTree.getNodeFactory();
    }

    public Object getProperty(Key key2) {
        return this.myProperties.get(key2);
    }

    public void putProperty(Key key2, Object data) {
        this.myProperties.put(key2, data);
    }

    @NotNull
    public static DebuggerTreeNodeImpl createNodeNoUpdate(DebuggerTree tree, NodeDescriptor descriptor) {
        DebuggerTreeNodeImpl node = new DebuggerTreeNodeImpl(tree, descriptor);
        node.updateCaches();
        return node;
    }

    @NotNull
    protected static DebuggerTreeNodeImpl createNode(DebuggerTree tree, NodeDescriptorImpl descriptor, EvaluationContextImpl evaluationContext) {
        final DebuggerTreeNodeImpl node = new DebuggerTreeNodeImpl(tree, descriptor);
        descriptor.updateRepresentationNoNotify(evaluationContext, new DescriptorLabelListener(){

            @Override
            public void labelChanged() {
                node.updateCaches();
                node.labelChanged();
            }
        });
        node.updateCaches();
        return node;
    }
}

