/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.ui.breakpoints.AddWildcardBreakpointDialog;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.WildcardMethodBreakpoint;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class JavaWildcardMethodBreakpointType
extends JavaBreakpointTypeBase<JavaMethodBreakpointProperties> {
    public JavaWildcardMethodBreakpointType() {
        super("java-wildcard-method", JavaDebuggerBundle.message((String)"method.breakpoints.tab.title", (Object[])new Object[0]));
    }

    @NotNull
    public Icon getEnabledIcon() {
        return AllIcons.Debugger.Db_method_breakpoint;
    }

    @NotNull
    public Icon getDisabledIcon() {
        return AllIcons.Debugger.Db_disabled_method_breakpoint;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        return AllIcons.Debugger.Db_muted_method_breakpoint;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        return AllIcons.Debugger.Db_muted_disabled_method_breakpoint;
    }

    protected String getHelpID() {
        return "debugging.methodBreakpoint";
    }

    public String getDisplayName() {
        return JavaDebuggerBundle.message((String)"method.breakpoints.tab.title", (Object[])new Object[0]);
    }

    public String getDisplayText(XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        return JavaMethodBreakpointType.getText(breakpoint);
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XBreakpoint<JavaMethodBreakpointProperties>> createCustomPropertiesPanel(@NotNull Project project) {
        return new MethodBreakpointPropertiesPanel();
    }

    @Nullable
    public JavaMethodBreakpointProperties createProperties() {
        return new JavaMethodBreakpointProperties();
    }

    @Nullable
    public XBreakpoint<JavaMethodBreakpointProperties> addBreakpoint(Project project, JComponent parentComponent) {
        AddWildcardBreakpointDialog dialog = new AddWildcardBreakpointDialog(project);
        if (!dialog.showAndGet()) {
            return null;
        }
        return (XBreakpoint)WriteAction.compute(() -> {
            JavaMethodBreakpointProperties properties = new JavaMethodBreakpointProperties(dialog.getClassPattern(), dialog.getMethodName());
            if (Registry.is((String)"debugger.emulate.method.breakpoints")) {
                properties.EMULATED = true;
            }
            return XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpoint((XBreakpointType)this, (XBreakpointProperties)properties);
        });
    }

    @Override
    @NotNull
    public Breakpoint<JavaMethodBreakpointProperties> createJavaBreakpoint(Project project, XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        return new WildcardMethodBreakpoint(project, breakpoint);
    }
}

