/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.CommonBundle;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.ui.breakpoints.AddFieldBreakpointDialog;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.breakpoints.FieldBreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PairFunction;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaFieldBreakpointProperties;

public class JavaFieldBreakpointType
extends JavaLineBreakpointTypeBase<JavaFieldBreakpointProperties> {
    public JavaFieldBreakpointType() {
        super("java-field", JavaDebuggerBundle.message((String)"field.watchpoints.tab.title", (Object[])new Object[0]));
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    @NotNull
    public Icon getEnabledIcon() {
        return AllIcons.Debugger.Db_field_breakpoint;
    }

    @NotNull
    public Icon getDisabledIcon() {
        return AllIcons.Debugger.Db_disabled_field_breakpoint;
    }

    @NotNull
    public Icon getSuspendNoneIcon() {
        return AllIcons.Debugger.Db_no_suspend_field_breakpoint;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        return AllIcons.Debugger.Db_muted_field_breakpoint;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        return AllIcons.Debugger.Db_muted_disabled_field_breakpoint;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        return AllIcons.Debugger.Db_dep_field_breakpoint;
    }

    protected String getHelpID() {
        return "debugging.fieldWatchpoint";
    }

    public String getDisplayName() {
        return JavaDebuggerBundle.message((String)"field.watchpoints.tab.title", (Object[])new Object[0]);
    }

    public String getShortText(XLineBreakpoint<JavaFieldBreakpointProperties> breakpoint) {
        return this.getText(breakpoint);
    }

    public String getText(XLineBreakpoint<JavaFieldBreakpointProperties> breakpoint) {
        JavaFieldBreakpointProperties properties = (JavaFieldBreakpointProperties)breakpoint.getProperties();
        String className2 = properties.myClassName;
        return className2 != null && !className2.isEmpty() ? className2 + "." + properties.myFieldName : properties.myFieldName;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<JavaFieldBreakpointProperties>> createCustomPropertiesPanel(@NotNull Project project) {
        return new FieldBreakpointPropertiesPanel();
    }

    @Nullable
    public JavaFieldBreakpointProperties createProperties() {
        return new JavaFieldBreakpointProperties();
    }

    @Nullable
    public JavaFieldBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        return new JavaFieldBreakpointProperties();
    }

    @Nullable
    public XLineBreakpoint<JavaFieldBreakpointProperties> addBreakpoint(final Project project, JComponent parentComponent) {
        final Ref result = Ref.create(null);
        AddFieldBreakpointDialog dialog = new AddFieldBreakpointDialog(project){

            @Override
            protected boolean validateData() {
                String className2 = this.getClassName();
                if (className2.length() == 0) {
                    Messages.showMessageDialog((Project)project, (String)JavaDebuggerBundle.message((String)"error.field.breakpoint.class.name.not.specified", (Object[])new Object[0]), (String)JavaDebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
                String fieldName = this.getFieldName();
                if (fieldName.length() == 0) {
                    Messages.showMessageDialog((Project)project, (String)JavaDebuggerBundle.message((String)"error.field.breakpoint.field.name.not.specified", (Object[])new Object[0]), (String)JavaDebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(className2, GlobalSearchScope.allScope((Project)project));
                if (psiClass != null) {
                    PsiFile psiFile = psiClass.getContainingFile();
                    Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
                    if (document != null) {
                        PsiField field = psiClass.findFieldByName(fieldName, false);
                        if (field != null) {
                            int line = document.getLineNumber(field.getTextOffset());
                            WriteAction.run(() -> {
                                XLineBreakpoint fieldBreakpoint = XDebuggerManager.getInstance((Project)project).getBreakpointManager().addLineBreakpoint((XLineBreakpointType)JavaFieldBreakpointType.this, psiFile.getVirtualFile().getUrl(), line, (XBreakpointProperties)new JavaFieldBreakpointProperties(fieldName, className2));
                                result.set((Object)fieldBreakpoint);
                            });
                            return true;
                        }
                        Messages.showMessageDialog((Project)project, (String)JavaDebuggerBundle.message((String)"error.field.breakpoint.field.not.found", (Object[])new Object[]{className2, fieldName, fieldName}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                    }
                } else {
                    Messages.showMessageDialog((Project)project, (String)JavaDebuggerBundle.message((String)"error.field.breakpoint.class.sources.not.found", (Object[])new Object[]{className2, fieldName, className2}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                }
                return false;
            }
        };
        dialog.show();
        return (XLineBreakpoint)result.get();
    }

    @Override
    @NotNull
    public Breakpoint<JavaFieldBreakpointProperties> createJavaBreakpoint(Project project, XBreakpoint breakpoint) {
        return new FieldBreakpoint(project, breakpoint);
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        return JavaFieldBreakpointType.canPutAtElement(file, line, project, (PairFunction<? super PsiElement, ? super Document, Boolean>)((PairFunction)(element, document) -> element instanceof PsiField));
    }
}

