/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.InternalIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdom.Element;

public class RendererConfiguration
implements Cloneable,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance(NodeRendererSettings.class);
    private static final int VERSION = 8;
    private List<NodeRenderer> myRepresentationNodes = new CopyOnWriteArrayList<NodeRenderer>();
    private final NodeRendererSettings myRendererSettings;

    protected RendererConfiguration(NodeRendererSettings rendererSettings) {
        this.myRendererSettings = rendererSettings;
    }

    public RendererConfiguration clone() {
        RendererConfiguration result = null;
        try {
            result = (RendererConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
        }
        result.myRepresentationNodes = new CopyOnWriteArrayList<NodeRenderer>();
        ArrayList<NodeRenderer> cloned = new ArrayList<NodeRenderer>();
        for (NodeRenderer renderer : this.myRepresentationNodes) {
            cloned.add((NodeRenderer)renderer.clone());
        }
        result.setRenderers(cloned);
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RendererConfiguration)) {
            return false;
        }
        return DebuggerUtilsEx.externalizableEqual(this, (RendererConfiguration)o);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (NodeRenderer renderer : this.myRepresentationNodes) {
            element.addContent(this.myRendererSettings.writeRenderer(renderer));
        }
        element.setAttribute("VERSION", String.valueOf(8));
    }

    public void readExternal(Element root) {
        int configurationVersion = StringUtil.parseInt((String)root.getAttributeValue("VERSION"), (int)-1);
        if (configurationVersion != 8) {
            return;
        }
        List children = root.getChildren("Renderer");
        ArrayList<NodeRenderer> renderers = new ArrayList<NodeRenderer>(children.size());
        for (Element nodeElement : children) {
            try {
                renderers.add((NodeRenderer)this.myRendererSettings.readRenderer(nodeElement));
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }
        this.setRenderers(renderers);
    }

    public void addRenderer(NodeRenderer renderer) {
        this.myRepresentationNodes.add(0, renderer);
    }

    public void removeRenderer(NodeRenderer renderer) {
        this.myRepresentationNodes.remove(renderer);
    }

    public void setRenderers(Collection<? extends NodeRenderer> renderers) {
        this.myRepresentationNodes.clear();
        this.myRepresentationNodes.addAll(renderers);
    }

    public void iterateRenderers(InternalIterator<NodeRenderer> iterator) {
        NodeRenderer renderer;
        boolean shouldContinue;
        Iterator<NodeRenderer> iterator2 = this.myRepresentationNodes.iterator();
        while (iterator2.hasNext() && (shouldContinue = iterator.visit((Object)(renderer = iterator2.next())))) {
        }
    }

    public int getRendererCount() {
        return this.myRepresentationNodes.size();
    }

    public boolean contains(NodeRenderer renderer) {
        return this.myRepresentationNodes.contains(renderer);
    }
}

