/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.memory.agent.MemoryAgentUtil;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

class DebuggerLaunchingConfigurable
implements ConfigurableUi<DebuggerSettings> {
    private JRadioButton myRbSocket;
    private JRadioButton myRbShmem;
    private StateRestoringCheckBox myCbForceClassicVM;
    private JCheckBox myCbDisableJIT;
    private JCheckBox myCbShowAlternativeSource;
    private JCheckBox myCbKillImmediately;
    private JCheckBox myCbAlwaysDebug;
    private JCheckBox myCbEnableMemoryAgent;

    DebuggerLaunchingConfigurable() {
    }

    public void reset(@NotNull DebuggerSettings settings) {
        if (!SystemInfo.isWindows) {
            this.myRbSocket.setSelected(true);
            this.myRbShmem.setEnabled(false);
        } else {
            if (settings.getTransport() == 1) {
                this.myRbShmem.setSelected(true);
            } else {
                this.myRbSocket.setSelected(true);
            }
            this.myRbShmem.setEnabled(true);
        }
        this.myCbForceClassicVM.setSelected(settings.FORCE_CLASSIC_VM);
        this.myCbDisableJIT.setSelected(settings.DISABLE_JIT);
        this.myCbShowAlternativeSource.setSelected(settings.SHOW_ALTERNATIVE_SOURCE);
        this.myCbKillImmediately.setSelected(settings.KILL_PROCESS_IMMEDIATELY);
        this.myCbAlwaysDebug.setSelected(settings.ALWAYS_DEBUG);
        this.myCbEnableMemoryAgent.setSelected(settings.ENABLE_MEMORY_AGENT);
    }

    public void apply(@NotNull DebuggerSettings settings) {
        this.getSettingsTo(settings);
    }

    private void getSettingsTo(DebuggerSettings settings) {
        settings.setTransport(this.myRbShmem.isSelected() ? 1 : 0);
        settings.FORCE_CLASSIC_VM = this.myCbForceClassicVM.isSelectedWhenSelectable();
        settings.DISABLE_JIT = this.myCbDisableJIT.isSelected();
        settings.SHOW_ALTERNATIVE_SOURCE = this.myCbShowAlternativeSource.isSelected();
        settings.KILL_PROCESS_IMMEDIATELY = this.myCbKillImmediately.isSelected();
        settings.ALWAYS_DEBUG = this.myCbAlwaysDebug.isSelected();
        settings.ENABLE_MEMORY_AGENT = this.myCbEnableMemoryAgent.isSelected();
    }

    public boolean isModified(@NotNull DebuggerSettings currentSettings) {
        DebuggerSettings debuggerSettings = currentSettings.clone();
        this.getSettingsTo(debuggerSettings);
        return !debuggerSettings.equals(currentSettings);
    }

    @NotNull
    public JComponent getComponent() {
        this.myCbForceClassicVM = new StateRestoringCheckBox(JavaDebuggerBundle.message((String)"label.debugger.launching.configurable.force.classic.vm", (Object[])new Object[0]));
        this.myCbDisableJIT = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.launching.configurable.disable.jit", (Object[])new Object[0]));
        this.myCbShowAlternativeSource = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.show.alternative.source", (Object[])new Object[0]));
        this.myRbSocket = new JRadioButton(JavaDebuggerBundle.message((String)"label.debugger.launching.configurable.socket", (Object[])new Object[0]));
        this.myRbShmem = new JRadioButton(JavaDebuggerBundle.message((String)"label.debugger.launching.configurable.shmem", (Object[])new Object[0]));
        this.myCbKillImmediately = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.kill.immediately", (Object[])new Object[0]));
        this.myCbAlwaysDebug = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.always.debug", (Object[])new Object[0]));
        this.myCbEnableMemoryAgent = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.enable.memory.agent", (Object[])new Object[0]));
        this.myCbEnableMemoryAgent.setToolTipText(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.enable.memory.agent.tooltip.text", (Object[])new Object[0]));
        ButtonGroup gr = new ButtonGroup();
        gr.add(this.myRbSocket);
        gr.add(this.myRbShmem);
        Box box = Box.createHorizontalBox();
        box.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        box.add(this.myRbSocket);
        box.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        box.add(this.myRbShmem);
        JPanel transportPanel = new JPanel(new BorderLayout());
        transportPanel.add((Component)new JLabel(JavaDebuggerBundle.message((String)"label.debugger.launching.configurable.debugger.transport", (Object[])new Object[0])), "West");
        transportPanel.add((Component)box, "Center");
        VerticalBox panel2 = new VerticalBox();
        panel2.setOpaque(false);
        panel2.add((Component)transportPanel);
        panel2.add((Component)this.myCbForceClassicVM);
        panel2.add((Component)this.myCbDisableJIT);
        panel2.add((Component)this.myCbShowAlternativeSource);
        panel2.add((Component)this.myCbKillImmediately);
        if (MemoryAgentUtil.isPlatformSupported()) {
            panel2.add((Component)this.myCbEnableMemoryAgent);
        }
        if (Registry.is((String)"execution.java.always.debug")) {
            panel2.add((Component)this.myCbAlwaysDebug);
        }
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)panel2, "North");
        return result;
    }
}

