/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.MemoryAgentOperations;
import com.intellij.debugger.memory.agent.extractor.AgentExtractor;
import com.intellij.debugger.memory.ui.JavaReferenceInfo;
import com.intellij.debugger.memory.ui.SizedReferenceInfo;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class MemoryAgentUtil {
    private static final Logger LOG = Logger.getInstance(MemoryAgentUtil.class);
    private static final String MEMORY_AGENT_EXTRACT_DIRECTORY = "memory.agent.extract.dir";
    private static final Key<Boolean> LISTEN_MEMORY_AGENT_STARTUP_FAILED = Key.create((String)"LISTEN_MEMORY_AGENT_STARTUP_FAILED");
    private static final Key<Boolean> IS_DEBUGGER_ATTACHED_KEY = Key.create((String)"IS_DEBUGGER_ATTACHED_KEY");
    private static final Key<Boolean> IS_JAVA_DEBUG_PROCESS_KEY = Key.create((String)"IS_JAVA_DEBUG_PROCESS_KEY");
    private static final int ESTIMATE_OBJECTS_SIZE_LIMIT = 2000;

    public static void addMemoryAgent(@NotNull JavaParameters parameters2) {
        if (!DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT) {
            return;
        }
        if (!MemoryAgentUtil.isPlatformSupported()) {
            LOG.warn("Could not use memory agent on current OS.");
            DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT = false;
            return;
        }
        if (MemoryAgentUtil.isIbmJdk(parameters2)) {
            LOG.info("Do not attach memory agent for IBM jdk");
            return;
        }
        ParametersList parametersList = parameters2.getVMParametersList();
        if (parametersList.getParameters().stream().anyMatch(x -> x.contains("memory_agent"))) {
            return;
        }
        boolean isInDebugMode = Registry.is((String)"debugger.memory.agent.debug");
        Path agentFile = null;
        String errorMessage = null;
        long start = System.currentTimeMillis();
        try {
            agentFile = MemoryAgentUtil.getAgentFile(isInDebugMode, parameters2.getJdkPath());
        }
        catch (InterruptedException e) {
            errorMessage = "Interrupted";
        }
        catch (ExecutionException e) {
            LOG.warn(e.getCause());
            errorMessage = "Exception thrown (see logs for details)";
        }
        catch (TimeoutException e) {
            errorMessage = "Timeout";
        }
        catch (CantRunException e) {
            errorMessage = e.getMessage();
        }
        if (errorMessage != null || agentFile == null) {
            LOG.warn("Could not extract agent: " + errorMessage);
            return;
        }
        LOG.info("Memory agent extracting took " + (System.currentTimeMillis() - start) + " ms");
        String path = JavaExecutionUtil.handleSpacesInAgentPath((String)agentFile.toAbsolutePath().toString(), (String)"debugger-memory-agent", (String)MEMORY_AGENT_EXTRACT_DIRECTORY);
        if (path == null) {
            return;
        }
        String args = "";
        if (isInDebugMode) {
            args = "5";
        }
        path = path + "=" + args;
        parametersList.add("-agentpath:" + path);
        MemoryAgentUtil.listenIfStartupFailed();
    }

    @NotNull
    public static List<JavaReferenceInfo> tryCalculateSizes(@NotNull EvaluationContextImpl context, @NotNull List<JavaReferenceInfo> objects) {
        MemoryAgent agent = MemoryAgent.get(context.getDebugProcess());
        if (!agent.capabilities().canEstimateObjectsSizes()) {
            return objects;
        }
        if (objects.size() > 2000) {
            LOG.info("Too many objects to estimate their sizes");
            return objects;
        }
        try {
            long[] sizes = agent.estimateObjectsSizes(context, ContainerUtil.map(objects, x -> x.getObjectReference()));
            return ((StreamEx)IntStreamEx.range((int)0, (int)objects.size()).mapToObj(i -> new SizedReferenceInfo(((JavaReferenceInfo)objects.get(i)).getObjectReference(), sizes[i])).reverseSorted(Comparator.comparing(x -> x.size()))).map(x -> x).toList();
        }
        catch (EvaluateException e) {
            LOG.error("Could not estimate objects sizes", (Throwable)e);
            return objects;
        }
    }

    public static void setupAgent(final @NotNull DebugProcessImpl debugProcess) {
        if (!DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT) {
            return;
        }
        if (DebuggerUtilsImpl.isRemote(debugProcess)) {
            return;
        }
        debugProcess.addDebugProcessListener(new DebugProcessAdapterImpl(){
            private final AtomicBoolean isInitialized = new AtomicBoolean(false);

            @Override
            public void paused(@NotNull SuspendContextImpl suspendContext) {
                EvaluationContextImpl context = new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy());
                if (context.isEvaluationPossible() && this.isInitialized.compareAndSet(false, true)) {
                    debugProcess.removeDebugProcessListener(this);
                    MemoryAgentOperations.initializeAgent(context);
                }
            }
        });
    }

    public static boolean isPlatformSupported() {
        return SystemInfo.isWindows || SystemInfo.isMacIntel64 || SystemInfo.isLinux;
    }

    private static boolean isIbmJdk(@NotNull JavaParameters parameters2) {
        Sdk jdk = parameters2.getJdk();
        String vendor = jdk == null ? null : JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VENDOR);
        return vendor != null && StringUtil.containsIgnoreCase((String)vendor, (String)"ibm");
    }

    private static Path getAgentFile(boolean isInDebugMode, String jdkPath) throws InterruptedException, ExecutionException, TimeoutException {
        String debugAgentPath;
        if (isInDebugMode && !(debugAgentPath = Registry.get((String)"debugger.memory.agent.debug.path").asString()).isEmpty()) {
            LOG.info("Local memory agent will be used: " + debugAgentPath);
            return Paths.get(debugAgentPath, new String[0]);
        }
        return (Path)ApplicationManager.getApplication().executeOnPooledThread(() -> new AgentExtractor().extract(MemoryAgentUtil.detectAgentKind(jdkPath), MemoryAgentUtil.getAgentDirectory())).get(1L, TimeUnit.SECONDS);
    }

    private static AgentExtractor.AgentLibraryType detectAgentKind(String jdkPath) {
        LOG.assertTrue(MemoryAgentUtil.isPlatformSupported());
        if (SystemInfo.isLinux) {
            return AgentExtractor.AgentLibraryType.LINUX;
        }
        if (SystemInfo.isMac) {
            return AgentExtractor.AgentLibraryType.MACOS;
        }
        JdkVersionDetector.JdkVersionInfo versionInfo = JdkVersionDetector.getInstance().detectJdkVersionInfo(jdkPath);
        if (versionInfo == null) {
            LOG.warn("Could not detect jdk bitness. x64 will be used.");
            return AgentExtractor.AgentLibraryType.WINDOWS64;
        }
        return Bitness.x32.equals((Object)versionInfo.bitness) ? AgentExtractor.AgentLibraryType.WINDOWS32 : AgentExtractor.AgentLibraryType.WINDOWS64;
    }

    @NotNull
    private static File getAgentDirectory() {
        String agentDirectory = System.getProperty(MEMORY_AGENT_EXTRACT_DIRECTORY);
        if (agentDirectory != null) {
            File file = new File(agentDirectory);
            if (file.exists() || file.mkdirs()) {
                return file;
            }
            LOG.info("Directory specified in property \"memory.agent.extract.dir\" not found. Default tmp directory will be used");
        }
        return new File(FileUtil.getTempDirectory());
    }

    private static void listenIfStartupFailed() {
        final Project project = JavaDebuggerSupport.getContextProjectForEditorFieldsInDebuggerConfigurables();
        if (Boolean.TRUE.equals(project.getUserData(LISTEN_MEMORY_AGENT_STARTUP_FAILED))) {
            return;
        }
        project.putUserData(LISTEN_MEMORY_AGENT_STARTUP_FAILED, (Object)true);
        project.getMessageBus().connect().subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                if (executorId != "Debug") {
                    return;
                }
                DebugProcess debugProcess = DebuggerManager.getInstance((Project)env.getProject()).getDebugProcess(handler);
                if (debugProcess == null) {
                    return;
                }
                handler.putUserData(IS_JAVA_DEBUG_PROCESS_KEY, (Object)true);
                if (debugProcess.isAttached()) {
                    handler.putUserData(IS_DEBUGGER_ATTACHED_KEY, (Object)true);
                } else {
                    debugProcess.addDebugProcessListener(new DebugProcessListener(){

                        public void processAttached(@NotNull DebugProcess process2) {
                            process2.getProcessHandler().putUserData(IS_DEBUGGER_ATTACHED_KEY, (Object)true);
                            process2.removeDebugProcessListener((DebugProcessListener)this);
                        }
                    });
                }
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
                if (executorId != "Debug" || exitCode == 0 || !this.isJvmDebugProcess(handler)) {
                    return;
                }
                if (this.wasDebuggerAttached(handler)) {
                    return;
                }
                RunContentDescriptor content = env.getContentToReuse();
                if (content == null) {
                    return;
                }
                ExecutionConsole console = content.getExecutionConsole();
                if (!(console instanceof ConsoleViewImpl)) {
                    return;
                }
                ConsoleViewImpl consoleView = (ConsoleViewImpl)console;
                ApplicationManager.getApplication().invokeLater(() -> {
                    Editor editor;
                    if (consoleView.hasDeferredOutput()) {
                        consoleView.flushDeferredText();
                    }
                    if ((editor = consoleView.getEditor()) == null) {
                        return;
                    }
                    Object[] outputLines = StringUtil.splitByLines((String)editor.getDocument().getText());
                    List mentions = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of((Object[])outputLines).skip(1L)).filter(x -> x.contains("memory_agent"))).limit(10L)).toList();
                    if (outputLines.length >= 1 && ((String)outputLines[0]).contains("memory_agent") && !mentions.isEmpty()) {
                        Project project2 = env.getProject();
                        String name2 = env.getRunProfile().getName();
                        String windowId = RunContentManager.getInstance((Project)project2).getToolWindowIdByEnvironment(env);
                        Attachment[] mentionsInOutput = (Attachment[])StreamEx.of((Collection)mentions).map(x -> new Attachment("agent_mention.txt", x)).toArray((Object[])Attachment.EMPTY_ARRAY);
                        RuntimeExceptionWithAttachments exception = new RuntimeExceptionWithAttachments("Could not start debug process with memory agent", mentionsInOutput);
                        String checkboxName = JavaDebuggerBundle.message((String)"label.debugger.general.configurable.enable.memory.agent", (Object[])new Object[0]);
                        String description = "Memory agent could not be loaded. <a href=\"Disable\">Disable</a> the agent. To enable it back use \"" + checkboxName + "\" option in File | Settings | Build, Execution, Deployment | Debugger";
                        ExecutionUtil.handleExecutionError((Project)project2, (String)windowId, (String)name2, (Throwable)exception, (String)description, (HyperlinkListener)new DisablingMemoryAgentListener());
                        LOG.error((Throwable)exception);
                    }
                }, project.getDisposed());
            }

            private boolean isJvmDebugProcess(@NotNull ProcessHandler handler) {
                return Boolean.TRUE.equals(handler.getUserData(IS_JAVA_DEBUG_PROCESS_KEY));
            }

            private boolean wasDebuggerAttached(@NotNull ProcessHandler handler) {
                return Boolean.TRUE.equals(handler.getUserData(IS_DEBUGGER_ATTACHED_KEY));
            }
        });
    }

    private static class DisablingMemoryAgentListener
    implements HyperlinkListener {
        private DisablingMemoryAgentListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT = false;
            }
        }
    }
}

