/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.memory.agent.MemoryAgentCapabilities;
import com.intellij.debugger.memory.agent.MemoryAgentImpl;
import com.intellij.debugger.memory.agent.MemoryAgentOperations;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.intellij.debugger.settings.DebuggerSettings;
import com.sun.jdi.ObjectReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface MemoryAgent {
    public static final int DEFAULT_GC_ROOTS_OBJECTS_LIMIT = 1000;

    @NotNull
    public static MemoryAgent get(@NotNull DebugProcessImpl debugProcess) {
        if (!DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT) {
            return MemoryAgentImpl.DISABLED;
        }
        return MemoryAgentOperations.getAgent(debugProcess);
    }

    @NotNull
    public MemoryAgentCapabilities capabilities();

    public long estimateObjectSize(@NotNull EvaluationContextImpl var1, @NotNull ObjectReference var2) throws EvaluateException;

    public long[] estimateObjectsSizes(@NotNull EvaluationContextImpl var1, @NotNull List<ObjectReference> var2) throws EvaluateException;

    @NotNull
    public ReferringObjectsInfo findReferringObjects(@NotNull EvaluationContextImpl var1, @NotNull ObjectReference var2, int var3) throws EvaluateException;
}

